/***********************************************************************/
/*!
* \file  spi_tclOnCarMsgQThreadable.h
* \brief implements threading based on MsgQthreader for OnCar Wrappers
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    implements threading based on MsgQthreader for OnCar Wrappers
AUTHOR:         jun5kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
05.02.2018  | Unmukt Jain           | Initial version


\endverbatim
*************************************************************************/

#ifndef SPI_TCLONCARMSGQTHREADER_H_
#define SPI_TCLONCARMSGQTHREADER_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "MsgQThreadable.h"
#include "spi_tclOnCarVideoDispatcher.h"
#include "spi_tclOnCarBTDispatcher.h"
#include "spi_tclOnCarAudioDispatcher.h"
#include "spi_tclOnCarSessionDispatcher.h"
#include "spi_tclOnCarInputDispatcher.h"
#include "spi_tclOnCarMetadataDispatcher.h"

using namespace shl::thread;

/****************************************************************************/
/*!
* \class spi_tclOnCarMsgQThreadable
* \brief implements threading based on MsgQthreader for OnCar Wrappers
*
* Responsible for calling the respective dispatchers and to allocate memory
* when a message arrives on Q
*
****************************************************************************/

class spi_tclOnCarMsgQThreadable : public MsgQThreadable
{
   public:

      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarMsgQThreadable::spi_tclOnCarMsgQThreadable()
      ***************************************************************************/
      /*!
      * \fn      spi_tclOnCarMsgQThreadable()
      * \brief   Default Constructor
      * \sa      ~spi_tclOnCarMsgQThreadable()
      **************************************************************************/
      spi_tclOnCarMsgQThreadable();

      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarMsgQThreadable::~spi_tclOnCarMsgQThreadable()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclOnCarMsgQThreadable()
      * \brief   Destructor
      * \sa      spi_tclOnCarMsgQThreadable()
      **************************************************************************/
      ~spi_tclOnCarMsgQThreadable();

   protected:
      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarMsgQThreadable::vExecute
      ***************************************************************************/
      /*!
      * \fn      t_Void vExecute(tShlMessage *poMessage)
      * \brief   Responsible for posting the message to respective dispatchers
      * \param   poMessage : message received from MsgQ for dispatching
      * \retval  t_Void
      **************************************************************************/
      virtual t_Void vExecute(tShlMessage *poMessage);

      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarMsgQThreadable::tShlMessage* poGetMsgBuffer(size_t )
      ***************************************************************************/
      /*!
      * \fn      tShlMessage* poGetMsgBuffer(size_t )
      * \brief  This function will be called for requesting the storage allocation for received
      *           message
      * \param siBuffer: size of the buffer to be allocated for the received message
      * \retval tShlMessage
      **************************************************************************/
      virtual tShlMessage* poGetMsgBuffer(size_t siBuffer);

   private:

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarMsgQThreadable(const spi_tclOnCarMsgQThreadable...
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarMsgQThreadable(const spi_tclOnCarMsgQThreadable& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclOnCarMsgQThreadable()
       ***************************************************************************/
      spi_tclOnCarMsgQThreadable(const spi_tclOnCarMsgQThreadable& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarMsgQThreadable& operator=( const spi_tclOnCarMsgQThreadable...
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarMsgQThreadable& operator=(const spi_tclOnCarMsgQThreadable& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclOnCarMsgQThreadable(const spi_tclOnCarMsgQThreadable& otrSrc)
       ***************************************************************************/
      spi_tclOnCarMsgQThreadable& operator=(const spi_tclOnCarMsgQThreadable& corfoSrc);

      //! Pointer to Video dispatcher
      spi_tclOnCarVideoDispatcher *m_poOnCarVideoDispatcher;

      //! Pointer to BT dispatcher
      spi_tclOnCarBTDispatcher *m_poOnCarBTDispatcher;

      //!Pointer to Audio dispatcher
      spi_tclOnCarAudioDispatcher *m_poOnCarAudioDispatcher;

      //!Pointer to Session dispatcher
      spi_tclOnCarSessionDispatcher *m_poOnCarSessionDispatcher;

      //! Pointer to Input dispatcher
      spi_tclOnCarInputDispatcher *m_poOnCarInputDispatcher;

      //! Pointer to Metadata dispatcher
      spi_tclOnCarMetadataDispatcher *m_poOnCarMetadataDispatcher;

};


#endif /* SPI_TCLONCARMSGQTHREADER_H_ */
