/*!
 *******************************************************************************
 * \file              spi_tclOnCarRespBluetooth.h
 * \brief            OnCar Wrapper Response class for Bluetooth
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   OnCar Wrapper Response class for Bluetooth
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date            |  Author                           | Modifications
29.03.2018  | Rishav Sardar               | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLONCARRESPBLUETOOTH_H_
#define _SPI_TCLONCARRESPBLUETOOTH_H_

#include "SPI_OnCarTypes.h"
#include "RespBase.h"

class spi_tclOnCarRespBluetooth: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarRespBluetooth::spi_tclOnCarRespBluetooth()
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarRespBluetooth()
    * \brief   Constructor
    * \sa      spi_tclOnCarRespBluetooth()
    **************************************************************************/
   spi_tclOnCarRespBluetooth(): RespBase(e16ONCAR_BLUETOOTH_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarRespBluetooth::~spi_tclOnCarRespBluetooth()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclOnCarRespBluetooth()
    * \brief   Destructor
    * \sa      spi_tclOnCarRespBluetooth()
    **************************************************************************/
   virtual ~spi_tclOnCarRespBluetooth() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarRespBluetooth::vPostBTPairingRequest()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostBTPairingRequest()
    * \brief   Called when Pairing request is sent by OnCar device.
    *          Mandatory interface to be implemented.
    * \param   [IN] poszOnCarBTAddress: BT  address of OnCar device
    * \param   [IN] enPairingMethod: Pairing method selected by OnCar device
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostBTPairingRequest(t_String poszOnCarBTAddress,
           tenOnCarBTPairingMethod enPairingMethod) = 0;

};

#endif /* _SPI_TCLAAPRESPBLUETOOTH_H_ */
