/*!
 *******************************************************************************
 * \file              spi_tclOnCarBluetoothCbs.h
 * \brief             BT Endpoint callbacks handler for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    BT Endpoint callbacks handler for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 12.03.2018 |  Rishav Sardar                | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLONCARBLUETOOTHCBS_H_
#define _SPI_TCLONCARBLUETOOTHCBS_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "OnCarBluetoothEndpoint.h"

/* This class includes a general set of IOnCarBluetoothCallbacks that must be set up for the BT Endpoint */
class spi_tclOnCarBluetoothCbs : public IOnCarBluetoothCallbacks
{
public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarBluetoothCbs::spi_tclOnCarBluetoothCbs()
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarBluetoothCbs()
    * \brief   Constructor
    * \sa      ~spi_tclOnCarBluetoothCbs()
    **************************************************************************/
    spi_tclOnCarBluetoothCbs() { }

    /***************************************************************************
     ** FUNCTION:  virtual spi_tclAAPBluetoothCbs::~spi_tclAAPBluetoothCbs()
     ***************************************************************************/
    /*!
     * \fn      virtual ~spi_tclOnCarBluetoothCbs()
     * \brief   Destructor
     * \sa      spi_tclOnCarBluetoothCbs()
     **************************************************************************/
    virtual ~spi_tclOnCarBluetoothCbs() {}

    /**********Start of functions overridden from IOnCarBluetoothCallbacks**********/

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarBluetoothCbs::onBTPairingRequestCallback()
    ***************************************************************************/
    /**
     * Called when BT connection is needed to established between HU and OnCar device.
     * Once this function is called, the HU must make itself prepared for Bluetooth pairing which will be initiated by the phone.
     * @param btAddress BT address of the phone
     * @param btPairingMethod Pairing method used by the phone.
     */
      void onBTPairingRequestCallback(const string &btAddress, BTPAIRING_METHOD btPairingMethod);

    /***********End of functions overridden from IBluetoothCallbacks**********/


private:

   /***************************************************************************
     ** FUNCTION: spi_tclOnCarBluetoothCbs(const spi_tclOnCarBluetoothCbs &rfcoObject)
     ***************************************************************************/
    /*!
     * \fn      spi_tclOnCarBluetoothCbs(const spi_tclOnCarBluetoothCbs &rfcoObject)
     * \brief   Copy constructor not implemented hence made private
     **************************************************************************/
    spi_tclOnCarBluetoothCbs(const spi_tclOnCarBluetoothCbs& rfcoObject);

    /***************************************************************************
     ** FUNCTION: const spi_tclOnCarBluetoothCbs & operator=(
     **                                 const spi_tclOnCarBluetoothCbs &rfcoObject);
     ***************************************************************************/
    /*!
     * \fn      const spi_tclOnCarBluetoothCbs & operator=(const spi_tclOnCarBluetoothCbs &rfcoObject);
     * \brief   assignment operator not implemented hence made private
     **************************************************************************/
    const spi_tclOnCarBluetoothCbs& operator=(const spi_tclOnCarBluetoothCbs& rfcoObject);
};


#endif /* _SPI_TCLONCARPBLUETOOTHCBS_H_ */
