/***********************************************************************/
/*!
* \file  spi_tclOnCarRespAudio.h
* \brief OnCar Audio Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    OnCar Audio Output Interface
AUTHOR:         Rishav Sardar
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                     | Modification
19.04.2018  | Rishav Sardar              | Initial Version
\endverbatim
*************************************************************************/

#ifndef _SPI_TCLONCRRESPAUDIO_H_
#define _SPI_TCLONCRRESPAUDIO_H_

#include "RespBase.h"
#include "SPI_OnCarTypes.h"
/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclOnCarRespAudio
* \brief OnCar Audio Output Interface
*
****************************************************************************/
class spi_tclOnCarRespAudio:public RespBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespAudio::spi_tclOnCarRespAudio()
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarRespAudio()
   * \brief   Constructor
   * \sa      ~spi_tclOnCarRespAudio()
   **************************************************************************/
    spi_tclOnCarRespAudio():RespBase(e16ONCAR_AUDIO_REGID) {}

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespAudio::~spi_tclOnCarRespAudio()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclOnCarRespAudio()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclOnCarRespAudio(RegID enRegId)
   **************************************************************************/
   virtual ~spi_tclOnCarRespAudio() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarRespAudio::vPoststartAudioPlaybackRequest(...)
    ***************************************************************************/
   /*!
    * \fn      t_Void vPoststartAudioPlaybackRequest(const AUDIOSTREAM_TYPE type)
    * \brief   Callback to start audio streaming from IOnCarAudioSinkCallbacks.
    * \sa      vstopAudioPlaybackRequest()
    **************************************************************************/
   virtual t_Void vPoststartAudioPlaybackRequest(const tenOnCarAudioStreamType enStreamType)
   {
       SPI_INTENTIONALLY_UNUSED(enStreamType);
   }

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarRespAudio::vPoststopAudioPlaybackRequest(...)
    ***************************************************************************/
   /*!
    * \fn      t_Void vPoststopAudioPlaybackRequest(const AUDIOSTREAM_TYPE type)
    * \brief   Callback to start audio streaming from IOnCarAudioSinkCallbacks.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPoststopAudioPlaybackRequest(const tenOnCarAudioStreamType enStreamType)
   {
       SPI_INTENTIONALLY_UNUSED(enStreamType);
   }

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarRespAudio::vPostaudioFocusRequestCallback(...)
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostaudioFocusRequestCallback(const AUDIOSTREAM_TYPE streamtype,
    *          const AUDIOFOCUS_REQUEST request)
    * \brief   Callback to change the audio focus from IOnCarAudioSinkCallbacks.
    * \sa      None
    **************************************************************************/
   virtual void vPostaudioFocusRequestCallback(const tenOnCarAudioStreamType enStreamType,
           const tenOnCarAudioFocusRequest enFocusRequest)
   {
       SPI_INTENTIONALLY_UNUSED(enStreamType);
       SPI_INTENTIONALLY_UNUSED(enFocusRequest);
   }

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarRespAudio::vPostaudioErrorCallback(...)
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostaudioErrorCallback(const AUDIOSTREAM_TYPE type)
    * \brief   Callback whenoccured during audio playback from
    *           IOnCarAudioSinkCallbacks.
    * \sa      None
    **************************************************************************/
   virtual void vPostaudioErrorCallback(const tenOnCarSinkError enSinkError)
   {
       SPI_INTENTIONALLY_UNUSED(enSinkError);
   }


   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespAudio::spi_tclOnCarRespAudio()
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarRespAudio(const spi_tclOnCarRespAudio& corfoSrc))
   * \brief   Parameterized Constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \sa      spi_tclOnCarRespAudio(RegID enRegId)
   **************************************************************************/
   spi_tclOnCarRespAudio(const spi_tclOnCarRespAudio& corfoSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespAudio& operator=( const spi_tclMLV...
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarRespAudio& operator=(
   *                          const spi_tclOnCarRespAudio& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclOnCarRespAudio(const spi_tclOnCarRespAudio& otrSrc)
   ***************************************************************************/
   spi_tclOnCarRespAudio& operator=(const spi_tclOnCarRespAudio& corfoSrc);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/
};

#endif /* _SPI_TCLONCRRESPAUDIO_H_ */
