/***********************************************************************/
/*!
 * \file              spi_tclOnCarAudioDispatcher.h
 * \brief             Message Dispatcher for Audio Messages. implemented using
 *                    double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Audio Messages
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 19.04.2018 |  Rishav Sardar        | Initial Version

 \endverbatim
 *************************************************************************/

#ifndef SPI_TCLONCARAUDIODISPATCHER_H_
#define SPI_TCLONCARAUDIODISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPI_OnCarTypes.h"

/**************Forward Declarations******************************************/
class spi_tclOnCarAudioDispatcher;

/****************************************************************************/
/*!
 * \class OnCarAudioMsgBase
 * \brief Base Message type for all Audio messages
 ****************************************************************************/
class OnCarAudioMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  OnCarAudioMsgBase::OnCarAudioMsgBase
       ***************************************************************************/
      /*!
       * \fn      OnCarAudioMsgBase()
       * \brief   Default constructor
       **************************************************************************/
    OnCarAudioMsgBase();

      /***************************************************************************
       ** FUNCTION:  OnCarAudioMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarAudioDispatcher* poOnCarAudioDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param   poAudioDispatcher : pointer to Message dispatcher for Audio
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclOnCarAudioDispatcher* poAudioDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  OnCarAudioMsgBase::~OnCarAudioMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~OnCarAudioMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarAudioMsgBase()
      {

      }

   private:
};

/****************************************************************************/
/*!
 * \class OnCarstartAudioPlaybackRequestMsg
 * \brief Playback start response message
 ****************************************************************************/
class OnCarstartAudioPlaybackRequestMsg: public OnCarAudioMsgBase
{
   public:
      tenOnCarAudioStreamType m_enStreamType;

      /***************************************************************************
       ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::OnCarstartAudioPlaybackRequestMsg
       ***************************************************************************/
      /*!
       * \fn      OnCarstartAudioPlaybackRequestMsg()
       * \brief   Default constructor
       **************************************************************************/
       OnCarstartAudioPlaybackRequestMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::~OnCarstartAudioPlaybackRequestMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCarstartAudioPlaybackRequestMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarstartAudioPlaybackRequestMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarAudioDispatcher* poOnCarAudioDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poOnCarAudioDispatcher : pointer to Message dispatcher for Audio
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarAudioDispatcher* poOnCarAudioDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class OnCarstopAudioPlaybackRequestMsg
 * \brief Playback stop response message
 ****************************************************************************/
class OnCarstopAudioPlaybackRequestMsg: public OnCarAudioMsgBase
{
   public:
      tenOnCarAudioStreamType m_enStreamType;

     /***************************************************************************
       ** FUNCTION:  OnCarstopAudioPlaybackRequestMsg::OnCarstopAudioPlaybackRequestMsg
       ***************************************************************************/
      /*!
       * \fn      OnCarstopAudioPlaybackRequestMsg()
       * \brief   Default constructor
       **************************************************************************/
      OnCarstopAudioPlaybackRequestMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarstopAudioPlaybackRequestMsg::~OnCarstopAudioPlaybackRequestMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCarstopAudioPlaybackRequestMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarstopAudioPlaybackRequestMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarstopAudioPlaybackRequestMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarAudioDispatcher* poOnCarAudioDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poOnCarAudioDispatcher : pointer to Message dispatcher for Audio
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarAudioDispatcher* poOnCarAudioDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarstartAudioPlaybackRequestMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class OnCaraudioFocusRequestMsg
 * \brief Audio Focus response message
 ****************************************************************************/
class OnCaraudioFocusRequestMsg: public OnCarAudioMsgBase
{
   public:
      tenOnCarAudioStreamType m_enStreamType;
      tenOnCarAudioFocusRequest m_enFocusRequest;

      /***************************************************************************
       ** FUNCTION:  OnCaraudioFocusRequestMsg::OnCaraudioFocusRequestMsg
       ***************************************************************************/
      /*!
       * \fn      OnCaraudioFocusRequestMsg()
       * \brief   Default constructor
       **************************************************************************/
        OnCaraudioFocusRequestMsg();

      /***************************************************************************
       ** FUNCTION:  OnCaraudioFocusRequestMsg::~OnCaraudioFocusRequestMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCaraudioFocusRequestMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCaraudioFocusRequestMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCaraudioFocusRequestMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarAudioDispatcher* poOnCarAudioDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poOnCarAudioDispatcher : pointer to Message dispatcher for Audio
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarAudioDispatcher* poOnCarAudioDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCaraudioFocusRequestMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCaraudioFocusRequestMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class OnCaraudioErrorMsg
 * \brief Error response message
 ****************************************************************************/
class OnCaraudioErrorMsg: public OnCarAudioMsgBase
{
   public:
    tenOnCarSinkError m_enSinkError;

      /***************************************************************************
       ** FUNCTION:  OnCaraudioErrorMsg::OnCaraudioErrorMsg
       ***************************************************************************/
      /*!
       * \fn      OnCaraudioErrorMsg()
       * \brief   Default constructor
       **************************************************************************/
    OnCaraudioErrorMsg();

      /***************************************************************************
       ** FUNCTION:  OnCaraudioErrorMsg::~OnCaraudioErrorMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCaraudioErrorMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCaraudioErrorMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCaraudioErrorMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarAudioDispatcher* poOnCarAudioDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poOnCarAudioDispatcher : pointer to Message dispatcher for Audio
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarAudioDispatcher* poOnCarAudioDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCaraudioErrorMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCaraudioErrorMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclOnCarAudioDispatcher
 * \brief Message Dispatcher for Audio Messages
 ****************************************************************************/
class spi_tclOnCarAudioDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioDispatcher::spi_tclOnCarAudioDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarAudioDispatcher()
       * \brief   Default constructor
       **************************************************************************/
       spi_tclOnCarAudioDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioDispatcher::~spi_tclOnCarAudioDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclOnCarAudioDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclOnCarAudioDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioDispatcher::vHandleAudioMsg(
       ** OnCarstartAudioPlaybackRequestMsg* poOnCarstartAudioPlaybackRequestMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleAudioMsg(OnCarstartAudioPlaybackRequestMsg* poOnCarstartAudioPlaybackRequestMsg)
       * \param   poOnCarstartAudioPlaybackRequestMsg : pointer to OnCarstartAudioPlaybackRequestMsg.
       **************************************************************************/
      t_Void vHandleAudioMsg(OnCarstartAudioPlaybackRequestMsg* poOnCarstartAudioPlaybackRequestMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioDispatcher::vHandleAudioMsg(
       ** OnCarstopAudioPlaybackRequestMsg* poOnCarstopAudioPlaybackRequestMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleAudioMsg(OnCarstopAudioPlaybackRequestMsg* poOnCarstopAudioPlaybackRequestMsg)
       * \param   poOnCarstopAudioPlaybackRequestMsg : pointer to OnCarstopAudioPlaybackRequestMsg.
       **************************************************************************/
      t_Void vHandleAudioMsg(OnCarstopAudioPlaybackRequestMsg* poOnCarstopAudioPlaybackRequestMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioDispatcher::vHandleAudioMsg(
       ** OnCaraudioFocusRequestMsg* poOnCaraudioFocusRequestMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleAudioMsg(OnCaraudioFocusRequestMsg* poOnCaraudioFocusRequestMsg)
       * \param   poOnCaraudioFocusRequestMsg : pointer to OnCaraudioFocusRequestMsg.
       **************************************************************************/
      t_Void vHandleAudioMsg(OnCaraudioFocusRequestMsg* poOnCaraudioFocusRequestMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioDispatcher::vHandleAudioMsg(
       ** OnCaraudioErrorMsg* poOnCaraudioErrorMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleAudioMsg(OnCaraudioErrorMsg* poOnCaraudioErrorMsg)
       * \param   poOnCaraudioErrorMsg : pointer to OnCaraudioErrorMsg.
       **************************************************************************/
      t_Void vHandleAudioMsg(OnCaraudioErrorMsg* poOnCaraudioErrorMsg) const;

   protected:
      /***************************************************************************
      *********************************PROTECTED**********************************
      ***************************************************************************/
      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarAudioDispatcher(const spi_tclOnCarAudioDispatcher...
      ***************************************************************************/
      /*!
      * \fn      spi_tclOnCarAudioDispatcher(
      *                             const spi_tclOnCarAudioDispatcher& corfoSrc)
      * \brief   Copy constructor - Do not allow the creation of copy constructor
      * \param   corfoSrc : [IN] reference to source data interface object
      * \retval
      * \sa      spi_tclAAPVideoDispatcher()
      ***************************************************************************/
      spi_tclOnCarAudioDispatcher(const spi_tclOnCarAudioDispatcher& corfoSrc);
      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarAudioDispatcher& operator=( const spi_tclOnCarV...
      ***************************************************************************/
      /*!
      * \fn      spi_tclOnCarAudioDispatcher& operator=(
      *                          const spi_tclOnCarAudioDispatcher& corfoSrc))
      * \brief   Assignment operator
      * \param   corfoSrc : [IN] reference to source data interface object
      * \retval
      * \sa      spi_tclOnCarAudioDispatcher(const spi_tclOnCarAudioDispatcher& otrSrc)
      ***************************************************************************/
      spi_tclOnCarAudioDispatcher& operator=(const spi_tclOnCarAudioDispatcher& corfoSrc);
      /***************************************************************************
      ****************************END OF PROTECTED********************************
      ***************************************************************************/
   private:
      /***************************************************************************
      *********************************PRIVATE************************************
      ***************************************************************************/
      /***************************************************************************
      ****************************END OF PRIVATE *********************************
      ***************************************************************************/
};

#endif /* SPI_TCLONCARAUDIODISPATCHER_H_ */
