/*!
 *******************************************************************************
 * \file              spi_tclOnCarAudioCbs.h
 * \brief             Audio Endpoint callbacks handler for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Audio Endpoint callbacks handler for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 20.03.2018 |  Rishav Sardar               | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLONCARAUDIOCBS_H_
#define _SPI_TCLONCARAUDIOCBS_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "OnCarAudioSinkEndpoint.h"
#include "BaseTypes.h"

/* This class includes a general set of IOnCarAudioSinkCallbacks that must be set up for the Audio Endpoint */
class spi_tclOnCarAudioCbs : public IOnCarAudioSinkCallbacks
{
public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarAudioCbs::spi_tclOnCarAudioCbs()
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarAudioCbs()
    * \brief   Constructor
    * \sa      ~spi_tclOnCarAudioCbs()
    **************************************************************************/
    spi_tclOnCarAudioCbs() { }

    /***************************************************************************
     ** FUNCTION:  virtual spi_tclOnCarAudioCbs::~spi_tclOnCarAudioCbs()
     ***************************************************************************/
    /*!
     * \fn      virtual ~spi_tclOnCarAudioCbs()
     * \brief   Destructor
     * \sa      spi_tclOnCarAudioCbs()
     **************************************************************************/
    virtual ~spi_tclOnCarAudioCbs() {}

    /**********Start of functions overridden from IOnCarAudioSinkCallbacks**********/

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarAudioCbs::startAudioPlaybackRequestCallback()
    ***************************************************************************/
    /*!
     * Called when MD wants to start audio streaming. This callback should be called after
     * HU has invoked setAudioFocus for the requested stream type. On receipt of this callback,
     * HU will allocate audio channel and MD must not send audio packets untill HU has acknowledged
     * this call back with acknowledgeStartAudioRequest() for the requested stream type.
     * @param type Enumeration of AUDIOSTREAM_TYPE
     */
      void startAudioPlaybackRequestCallback(const AUDIOSTREAM_TYPE type);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarAudioCbs::stopAudioPlaybackRequestCallback()
    ***************************************************************************/
    /*!
     *Called when MD wants to stop audio streaming. On receipt of this callback,
     * HU will deallocate audio channel and will acknowledge this request by invoking acknowledgeStopAudioRequest().
     * After that MD should send audioFocusRequestCallback(AUDIOSTREAM_TYPE,eAUDIOFOCUS_REQUEST_RELEASE) and HU will
     * acknowledge it by invoking setAudioFocus(AUDIOSTREAM_TYPE,eAUDIOFOCUS_STATE_LOSS).
     * @param type Enumeration of AUDIOSTREAM_TYPE
     * \note
     *  HU is not expecting any callback from MD when user has paused the audio playback on OnCar APP.
     */
      void stopAudioPlaybackRequestCallback(const AUDIOSTREAM_TYPE type);

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclOnCarAudioCbs::audioFocusRequestCallback()
     ***************************************************************************/
    /*!
     *Called when the OnCar source wishes to change the audio focus.
     * @param streamtype Enumeration of AUDIOSTREAM_TYPE
     * @param request Enumeration of AUDIOFOCUS_REQUEST
     */
      void audioFocusRequestCallback(const AUDIOSTREAM_TYPE streamtype,const AUDIOFOCUS_REQUEST request);

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclOnCarAudioCbs::audioErrorCallback()
     ***************************************************************************/
    /*!
     *Called when error has occured during audio playback.
     * @param enError: enum containing error code.
     */
      void audioErrorCallback(const ONCARSINKERROR enError);

    /***********End of functions overridden from IOnCarVideoSinkCallbacks**********/


private:

    /***************************************************************************
     ** FUNCTION: spi_tclOnCarAudioCbs(const spi_tclOnCarAudioCbs &rfcoObject)
     ***************************************************************************/
    /*!
     * \fn      spi_tclOnCarAudioCbs(const spi_tclOnCarAudioCbs &rfcoObject)
     * \brief   Copy constructor not implemented hence made private
     **************************************************************************/
      spi_tclOnCarAudioCbs(const spi_tclOnCarAudioCbs& rfcoObject);

    /***************************************************************************
     ** FUNCTION: const spi_tclOnCarAudioCbs & operator=(
     **                                 const spi_tclOnCarAudioCbs &rfcoObject);
     ***************************************************************************/
    /*!
     * \fn      const spi_tclOnCarAudioCbs & operator=(const spi_tclOnCarAudioCbs &rfcoObject);
     * \brief   assignment operator not implemented hence made private
     **************************************************************************/
    const spi_tclOnCarAudioCbs& operator=(const spi_tclOnCarAudioCbs& rfcoObject);
};


#endif /* _SPI_TCLONCARAUDIOCBS_H_ */
