/***********************************************************************/
/*!
 * \file  spi_tclOnCarAppMngr.h
 * \brief OnCar Application Manager
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    OnCar Application Manager
 AUTHOR:         irh1kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 09.02.2018  | jun5kor               | Initial Version
 01.06.2018  | irh1kor               | Metadata Implementation
 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLONCARAPPMNGR_H_
#define _SPI_TCLONCARAPPMNGR_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_tclAppMngrDefines.h"
#include "spi_tclAppMngrDev.h"
#include "spi_tclOnCarRespMetadata.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class spi_tclOnCarAppMngr
 * \brief OnCar Application Manager
 ****************************************************************************/
class spi_tclOnCarAppMngr: public spi_tclAppMngrDev, public spi_tclOnCarRespMetadata
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAppMngr::spi_tclOnCarAppMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarAppMngr()
       * \brief   default Constructor
       * \sa      ~spi_tclOnCarAppMngr()
       **************************************************************************/
       spi_tclOnCarAppMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAppMngr::~spi_tclOnCarAppMngr()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclOnCarAppMngr()
       * \brief   Destructor
       * \sa      spi_tclOnCarAppMngr()
       **************************************************************************/
      ~spi_tclOnCarAppMngr();

      /********Start of functions overridden from spi_tclAppMngrDev********/

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarAppMngr::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the OnCar App Mngr related things
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAppMngr::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief   To Uninitialize all the OnCar App Mngr related things
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclOnCarAppMngr::vRegisterAppMngrCallbacks()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegisterAppMngrCallbacks(const trAppMngrCallbacks& corfrAppMngrCbs)
       * \brief   To Register for the asynchronous responses that are required from App Mngr
       * \param   corfrAppMngrCbs : [IN] Application Manager callabcks structure
       * \retval  t_Void
       **************************************************************************/
      t_Void vRegisterAppMngrCallbacks(const trAppMngrCallbacks& corfrAppMngrCbs);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAppMngr::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vSelectDevice(const t_U32 cou32DevId,
       *          const tenDeviceConnectionReq coenConnReq)
       * \brief   To update the changes in the app list of the selected device
       * \param  corfrSelectReq : Device selection request details
       * \retval  t_Void
       **************************************************************************/
      t_Void vSelectDevice(const trSelectDeviceRequest& corfrSelectReq);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarAppMngr::bLaunchApp()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bLaunchApp(const t_U32 cou32DevId,
       *           t_U32 u32AppHandle,
       *           tenDiPOAppType enDiPOAppType,
       *           t_String szTelephoneNumber,
       *           tenEcnrSetting enEcnrSetting)
       * \brief   To Launch the requested app
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \param  [IN] enDevCat : Device Type Information(Mirror Link/DiPO).
       * \param  [IN] u32AppHandle : Uniquely identifies an Application on
       *              the target Device. This value will be obtained from AppList Interface.
       *              This value will be set to 0xFFFFFFFF if DeviceCategory = DEV_TYPE_DIPO.
       * \param  [IN] enDiPOAppType : Identifies the application to be launched on a DiPO device.
       *              This value will be set to NOT_USED if DeviceCategory = DEV_TYPE_MIRRORLINK.
       * \param  [IN] szTelephoneNumber : Number to be dialed if the DiPO application to be launched
       *              is a phone application. If not valid to be used, this will be set to NULL,
       *              zero length string. Will not be used if DeviceCategory = DEV_TYPE_MIRRORLINK.
       * \param  [IN] enEcnrSetting : Sets voice or server echo cancellation and noise reduction
       *              settings if the DiPO application to be launched is a phone application.
       *              If not valid to be used, this will be set to ECNR_NOCHANGE.
       * \retval  t_Bool
       * \sa      vTerminateApp()
       **************************************************************************/
      t_Void vLaunchApp(const t_U32 cou32DevId, t_U32 u32AppId, const trUserContext& rfrcUsrCntxt,
               tenDiPOAppType enDiPOAppType, t_String szTelephoneNumber, tenEcnrSetting enEcnrSetting);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAppMngr::vTerminateApp()
       ***************************************************************************/
      /*!
       * \fn      t_Void vTerminateApp
       * \brief   To Terminate an Application asynchronously.
       * \param   rUserContext : [IN] Context Message
       * \param   u32DeviceId  : [IN] Device Id
       * \param   u32AppId     : [IN] Application Id
       * \retval  t_Void
       * \sa      t_Bool bLaunchApp(t_U32 u32DeviceId, t_U32 u32AppId)
       **************************************************************************/
      t_Void vTerminateApp(const t_U32 cou32DevId, const t_U32 cou32AppId, const trUserContext& rfrcUsrCntxt);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAppMngr::vGetAppDetailsList()
       ***************************************************************************/
      /*!
       * \fn     virtual t_Void vGetDeviceInfoList(const t_U32 cou32DevId,
       *         t_U32& u32NumAppInfoList,
       *         std::vector<trAppDetails>& corfvecrAppDetailsList)
       * \brief  It provides a list of applications supported by a device.
       * \param  cou32DevId  : [IN] Device Handle
       * \param  u32NumAppInfoList : [OUT] Number of Applications in the List
       * \param  corfvecrAppDetailsList : [OUT] List of applicationinfo's of the
       *                                 Applications supported by the device
       * \retval  t_Void
       **************************************************************************/
      t_Void vGetAppDetailsList(const t_U32 cou32DevId, t_U32& u32NumAppInfoList,
               std::vector<trAppDetails>& corfvecrAppDetailsList);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAppMngr::vGetAppIconData()
       ***************************************************************************/
      /*!
       * \fn     virtual t_Void vGetAppIconData(t_String szAppIconUrl,
       *                                 const trUserContext& rfrcUsrCntxt)
       * \brief  Used to get the application icon data.
       * \param  szAppIconUrl  : [IN] String to store app icon url
       * \param  rfrcUsrCntxt : [IN] Used to store user context info
       * \retval  t_Void
       **************************************************************************/
      t_Void vGetAppIconData(t_String szAppIconUrl, const trUserContext& rfrcUsrCntxt);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAppMngr::bCheckAppValidity()
       ***************************************************************************/
      /*!
       * \fn     virtual t_Void bCheckAppValidity(const t_U32 cou32DevId,
       *                                 const t_U32 cou32AppId)
       * \brief  Used to check the validity of an application.
       * \param  cou32DevId  : [IN] String to store app icon url
       * \param  cou32AppId : [IN] Used to store user context info
       * \retval  t_Void
       **************************************************************************/
      t_Bool bCheckAppValidity(const t_U32 cou32DevId, const t_U32 cou32AppId);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAppMngr::vOnSelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
               const tenResponseCode coenRespCode);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclOnCarAppMngr::vSetVehicleConfig()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetVehicleConfig(tenVehicleConfiguration enVehicleConfig,
       *          t_Bool bSetConfig,const trUserContext& corfrUsrCntxt)
       * \brief  Interface to set the Vehicle configurations.
       * \param  [IN] enVehicleConfig :  Identifies the Vehicle Configuration.
       * \param  [IN] bSetConfig      : Enable/Disable config
       * \param  [IN] corfrUsrCntxt   : User Context Details.
       * \retval t_Void
       **************************************************************************/
      t_Void vSetVehicleConfig(tenVehicleConfiguration enVehicleConfig, t_Bool bSetConfig);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclOnCarAppMngr::bGetAudioHandlingCaps()
       ***************************************************************************/
      /*!
       * \fn     t_Bool bGetAudioHandlingCaps()
       * \brief  Interface to get advanced audio capability
       * \param  [NONE]
       * \retval t_Bool
       **************************************************************************/
      t_Bool bGetAudioHandlingCaps();

      /********End of functions overridden from spi_tclAppMngrDev********/

      /********Start of functions overridden from spi_tclOnCarRespMetadata********/

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAppMngr::vPostOnCarMediaMetadataUpdate()
       ***************************************************************************/
      /*!
       * \fn      t_Void vPostOnCarMediaMetadataUpdate()
       * \brief   Called when media playback metadata is sent by OnCar device.
       *          Mandatory interface to be implemented.
       * \param   [IN] trOnCarMediaMetadata *rOnCarMediaMetadata
       * \sa      None
       **************************************************************************/
       t_Void vPostOnCarMediaMetadataUpdate(const trOnCarMediaMetadata* rOnCarMediaMetadata);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAppMngr::vPostOnCarMediaPlaybackStatusUpdate()
       ***************************************************************************/
      /*!
       * \fn      t_Void vPostOnCarMediaPlaybackStatusUpdate()
       * \brief   Called when media playback status is sent by OnCar device.
       *          Mandatory interface to be implemented.
       * \param   [IN] trOnCarMediaPlaybackStatus* rOnCarMediaPlaybackStatus
       * \sa      None
       **************************************************************************/
       t_Void vPostOnCarMediaPlaybackStatusUpdate(const trOnCarMediaPlaybackStatus* rOnCarMediaPlaybackStatus);

      /********End of functions overridden from spi_tclOnCarRespMetadata********/

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAppMngr::vSetPlaybackRepeatState(const trAAP...
       ***************************************************************************/
      /*!
       * \fn     vSetPlaybackRepeatState(
                 const trOnCarMediaPlaybackStatus* coprOnCarMediaPlaybackStatus)
       * \brief  Gets the repeat all and repeat one states from the given
       *         MediaPlaybackStatus object
       * \brief  Sets repeat all and repeat one states of AppMedia metadata
       * \param  trOnCarMediaPlaybackStatus  for MediaPlaybackStatus update
       **************************************************************************/
       t_Void vSetPlaybackRepeatState(const trOnCarMediaPlaybackStatus* coprOnCarMediaPlaybackStatus, t_Bool& bSolicited);

      /***************************************************************************
       ** FUNCTION:  spi_tclAAPAppMngr::vSetPlaybackMediaSource(const trAAP...
       ***************************************************************************/
      /*!
       * \fn     vSetPlaybackMediaSource(
                 const trAAPMediaPlaybackStatus* coprOnCarMediaPlaybackStatus)
       * \brief  Sets the media source of AppMedia metadata using the given
       *         MediaPlaybackStatus object
       * \param  trOnCarMediaPlaybackStatus  for MediaPlaybackStatus update
       **************************************************************************/
       t_Void vSetPlaybackMediaSource(const trOnCarMediaPlaybackStatus* coprOnCarMediaPlaybackStatus, t_Bool& bSolicited);

      //! call back structure tos end response to Main App lmgr
      trAppMngrCallbacks m_rAppMngrCallbacks;

      //! Device handle of the selected device
      t_U32 m_u32SelectedDevId;

      //Structure for Media metadata
      trAppMediaMetaData m_rAppMediaMetaData;

      //Structure to hold current playtime
      trAppMediaPlaytime m_rAppMediaPlaytime;
      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

};

#endif //_SPI_TCLONCARAPPMNGR_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
