/**
 *******************************************************************************
 * \file              OnCarMetadataEndpoint.h
 * \brief             This sink allows HU to receive Metadata information from OnCar.
 *******************************************************************************/

#ifndef ONCAR_METADATA_ENDPOINT_HPP
#define ONCAR_METADATA_ENDPOINT_HPP
 
#include "OnCarTypes.h"
#include "OnCarEndPointBase.h"

/**
 * This class represents an interface that every sink implementation 
 * must subclass if they wish to receive media metadata.  
 */
class IOnCarMediaMetadataCallbacks 
{
	public:
	  virtual ~IOnCarMediaMetadataCallbacks() { }
	  
	/**
     * Called when media playback metadata message comes through. 
	 * @param metadata structure of OnCarMediaMetadata type.
     */
	  virtual void onCarMediaMetadataUpdate(const OnCarMediaMetadata &metadata) = 0;
	  
	/**
     * Called when media playback status message comes through.
	 * @param playbackstatus structure of OnCarMediaPlaybackStatus type.
     */
	  virtual void onCarMediaPlaybackStatusUpdate(const OnCarMediaPlaybackStatus &playbackstatus) = 0;
};

/**
 * This class represents an interface that every sink implementation 
 * must subclass if they wish to revceive phone metadata.  
 * \note
 *  This class is kept for future use. It is not used now.
 */
class IPhoneStatusCallbacks
{
    public:
	
	  virtual ~IPhoneStatusCallbacks() { }
	  
	/**
     * Called when phone call metadata message comes through. 
	 * @param phonecallmetadata structure of PhoneCallMetaData type.
     */
	  virtual void onCarPhoneCallMetadaCallback(const PhoneCallMetaData &phonecallmetadata) = 0;
	  
	/**
     * Called when phone state metadata message comes through. 
	 * @param phonestatemetadata structure of PhoneStatusMetaData type.
     */
	  virtual void onCarPhoneStatusMetadaCallback(const PhoneStatusMetaData &phonestatemetadata) = 0;
};

/**
 * OnCarMetadataEndpoint: This sink allows OnCar to send metadata to HU.
 * \image html MediaMetaData.jpg
 * \image latex MediaMetaData.eps "OnCar MetaDataEndPoint Sequence" width=\textwidth
 */
class OnCarMetadataEndpoint : public OnCarEndPointBase
{
	public:
	
	/**
     * @brief Constructor
     * @param endpointID End point ID
     */
     OnCarMetadataEndpoint(ONCARENDPOINTID endpointID):OnCarEndPointBase(endpointID)
	 {}

    /**
     * @brief destructor
     */
     virtual ~OnCarMetadataEndpoint(){}
	
     /**
      * Register callback interface to receive Media Metadata-related notifications.
      * @param callbacks object implementing the IOnCarMediaMetadataCallbacks interface
	  */
     virtual void registerCallbacks(const shared_ptr <IOnCarMediaMetadataCallbacks> &callbacks) = 0;
	   
	 /**
      * Register callback interface to receive Phone Metadata-related notifications.
      * @param callbacks object implementing the IPhoneStatusCallbacks interface
      * \note
      *  This method is kept for future use. It is not used now.
	  */
     virtual void registerCallbacks(const shared_ptr <IPhoneStatusCallbacks> &callbacks) = 0;
};

#endif //ONCAR_METADATA_ENDPOINT_HPP
