/*!
 *******************************************************************************
 * \file             spi_tclWifiRespIntf.h
 * \brief            Response to HMI from Wifi manager class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Response to HMI from Wifi manager class
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 15.12.2016 |  Unmukt Jain (RBEI/ECP2)     | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLWIFIRESPINTF_H_
#define SPI_TCLWIFIRESPINTF_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "spi_WifiTypedefs.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclWifiRespIntf
 * \brief Response to HMI from Wifi manager class
 */
class spi_tclWifiRespIntf
{

   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclWifiRespIntf::spi_tclWifiRespIntf
       ***************************************************************************/
      /*!
       * \fn     spi_tclWifiRespIntf()
       * \brief  Default Constructor
       * \sa     ~spi_tclWifiRespIntf()
       **************************************************************************/
      spi_tclWifiRespIntf(){}

      /***************************************************************************
       ** FUNCTION:  spi_tclWifiRespIntf::~spi_tclWifiRespIntf
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclWifiRespIntf()
       * \brief  Virtual Destructor
       * \sa     spi_tclWifiRespIntf()
       **************************************************************************/
      virtual ~spi_tclWifiRespIntf(){}

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclWifiRespIntf::vPostWiFiCredentials(...)
       ***************************************************************************/
      /*!
       * \fn     vPostWiFiCredentials(t_String szSSID, t_String szPassPhrase,
       *            t_U16 u16ChannelNo, tenWifiSecurityType enSecurityType)
       * \brief  It notifies the client about WiFi Credentials.
       * \param  [IN] szSSID       : Indicates the SSID of the Access Point.
       * \param  [IN] szPassPhrase : Indicates the PassPhrase of the Access Point.
       *                             It is required, if security type is not None.
       * \param  [IN] u16ChannelNo : Indicates the Channel number on which access point is active.
       * \param  [IN] enSecurityType  : Indicates the Security Type of the Access Point.
       **************************************************************************/
      virtual t_Void vPostWiFiCredentials(t_String szSSID,
            t_String szPassPhrase,
            t_U16 u16ChannelNo,
            tenWifiSecurityType enSecurityType) = 0;
			
	   /***************************************************************************
       ** FUNCTION:  t_Void spi_tclWifiRespIntf::vSendWiFiCredentials()
       ***************************************************************************/
       /*!
       * \fn      t_Void vSendWiFiCredentials()
       * \brief   To send WiFi credentials to registered clients after User consent.
       * \param  [IN] szBTMACAddress: Indicates Unique ID of the device.
       * \param  [IN] enErrorCode    : Error code generated based on User consent and technology settings.
       * \param  [IN] corfrWiFiAPConfig   : Indicates the configuration of the Access Point.
       * \param  [IN] corfrUsrCntxt  : Indicates the User context.
       * \sa      None
       **************************************************************************/
       virtual t_Void vSendWiFiCredentials(t_String /*szBTMACAddress*/,
                               tenErrorCode /*enErrorCode*/,
                               const trWiFiAPConfig& /*corfrWiFiAPConfig*/,
                               const trUserContext& /*corfrUsrCntxt*/){}

};
#endif // SPI_TCLWIFIRESPINTF_H_
