/*!
 *******************************************************************************
 * \file             spi_tclWiFiSetupHndlrRespIntf.h
 * \brief            Response to HMI from Wifi SetupHndlr class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Response to HMI from Wifi SetupHndlr class
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 15.03.2017 |  Unmukt Jain (RBEI/ECP2)     | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLWIFISETUPHNDLRRESPINTF_H_
#define SPI_TCLWIFISETUPHNDLRRESPINTF_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclWiFiSetupHndlrRespIntf
 * \brief Response to HMI from Wifi SetupHndlr class
 */
class spi_tclWiFiSetupHndlrRespIntf
{

   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclWiFiSetupHndlrRespIntf::spi_tclWiFiSetupHndlrRespIntf
       ***************************************************************************/
      /*!
       * \fn     spi_tclWiFiSetupHndlrRespIntf()
       * \brief  Default Constructor
       * \sa     ~spi_tclWiFiSetupHndlrRespIntf()
       **************************************************************************/
    spi_tclWiFiSetupHndlrRespIntf(){}

      /***************************************************************************
       ** FUNCTION:  spi_tclWiFiSetupHndlrRespIntf::~spi_tclWiFiSetupHndlrRespIntf
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclWiFiSetupHndlrRespIntf()
       * \brief  Virtual Destructor
       * \sa     spi_tclWiFiSetupHndlrRespIntf()
       **************************************************************************/
      virtual ~spi_tclWiFiSetupHndlrRespIntf(){}

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclWiFiSetupHndlrRespIntf::vPostInitiateWirelessDiscoveryResult(...)
       ***************************************************************************/
      /*!
       * \fn     vPostInitiateWirelessDiscoveryResult(tenErrorCode enErrorCode,
                                                      const trUserContext& corfrUsrCntxt)
       * \brief  It notifies the client about InitiateWirelessDiscovery method result.
       * \param  [IN] enResponseCode : Provides result from the operation.
       * \param  [IN] corfrUsrCntxt  : User Context Details
       **************************************************************************/
      virtual t_Void vPostInitiateWirelessDiscoveryResult(tenResponseCode enResponseCode,
                                                          const trUserContext& corfrUsrCntxt) = 0;

};
#endif // SPI_TCLWIFISETUPHNDLRRESPINTF_H_
