/***********************************************************************/
/*!
* \file  spi_tclAppMngrRespIntf.h
* \brief Application Manager Response Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Mirror Link Application Manager
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
18.02.2014  | Shiva Kumar Gurija    | Initial Version
20.03.2014  | Shihabudheen P M      | Added vPostDeviceDisplayContext()
Handling Devices and App's Info
26.02.2016  | Rachana L Achar       | AAP Navigation implementation
10.03.2016  | Rachana L Achar       | AAP Notification implementation

\endverbatim
*************************************************************************/
#ifndef SPI_TCL_APPMNGR_RESPINTF
#define SPI_TCL_APPMNGR_RESPINTF

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "spi_tclAppMngrDefines.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/


/****************************************************************************/
/*!
* \class spi_tclAppMngrRespIntf
* \brief Application Manager Response Interface
****************************************************************************/
class spi_tclAppMngrRespIntf
{
   public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclAppMngrRespIntf::spi_tclAppMngrRespIntf()
   ***************************************************************************/
   /*!
   * \fn      spi_tclAppMngrRespIntf()
   * \brief   Constructor
   * \sa      ~spi_tclAppMngrRespIntf()
   **************************************************************************/
      spi_tclAppMngrRespIntf()
      {
         //Add code
      }
   /***************************************************************************
   ** FUNCTION:  spi_tclAppMngrRespIntf::~spi_tclAppMngrRespIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclAppMngrRespIntf()
   * \brief   Destructor
   * \sa      spi_tclAppMngrRespIntf()
   **************************************************************************/
      virtual ~spi_tclAppMngrRespIntf()
      {
         //Add code
      }

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostAppStatusInfo
      ***************************************************************************/
      /*!
      * \fn     vPostAppStatusInfo(t_U32 u32DeviceHandle,
      *             tenDeviceConnectionType enDevConnType, tenAppStatusInfo enAppStatus)
      * \brief  It notifies the client upon application list change of a Mirror Link
      *         device. The client can retrieve the detailed information of the
      *         applications via the methods provided. If a Mirror Link device is
      *         disconnected, Device Handle is set to 0xFFFF and DeviceConnectionType
      *         is set to UNKNOWN_CONNECTION.
      * \param  [IN] u32DeviceHandle : Uniquely identifies the target Device.
      * \param  [IN] enDevConnType   : Identifies the Connection Type.
      * \param  [IN] enAppStatus : Provides application Status Information.
      **************************************************************************/
      virtual t_Void vPostAppStatusInfo(t_U32 /*u32DeviceHandle*/,
               tenDeviceConnectionType /*enDevConnType*/,
               tenAppStatusInfo /*enAppStatus*/)
      {
         //Add code
      }

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclRespInterface::vPostAppIconDataResult
      **                   (tenIconMimeType enIconMimeType, t_Char* pczAppIconData, ..)
      ***************************************************************************/
      /*!
      * \fn     vPostAppIconDataResult(tenIconMimeType enIconMimeType,
      *            t_Char* pczAppIconData,t_U32 u32Len, const trUserContext rcUsrCntxt)
      * \brief  It retrieves icon data referenced by the AppList.AppIconXXXURLs
      * \param  [IN] enIconMimeType :  Mime Type of the icon pointed by AppIconURL.
      *              If image is not available then this parameter would be set
      *              to NULL (zero length string).
      * \param  [IN] pczAppIconData : Byte Data Stream from the icon image file.
      *              Format of the file is de-fined by IconMimeType parameter.
      * \param  [IN] u32Len : data stream length
      * \param  [IN] rcUsrCntxt		: User Context Details.
      * \sa     spi_tclCmdInterface::vGetAppIconData
      **************************************************************************/
      virtual t_Void vPostAppIconDataResult(tenIconMimeType /*enIconMimeType*/,
               const t_U8* /*pczAppIconData*/,
               t_U32 /*u32Len*/,
               const trUserContext /*rcUsrCntxt*/)
      {
         //Add code
      }

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostSetAppIconAttributesResult
      **             (tenResponseCode enResponseCode, tenErrorCode enErrorCode,..)
      ***************************************************************************/
      /*!
      * \fn     vPostSetAppIconAttributesResult(tenResponseCode enResponseCode,
      *                          tenErrorCode enErrorCode, const trUserContext rcUsrCntxt)
      * \brief  sets application icon attributes for retrieval of application icons.
      * \param  [IN] enResponseCode :  Provides result from the operation.
      * \param  [IN] enErrorCode : Provides the Error Code in case ResponseCode==FAILURE.
      *              Set to NO_ERROR for successful operation.
	   * \param  [IN] rcUsrCntxt	 : User Context Details.
      * \sa     spi_tclCmdInterface::vSetAppIconAttributes
      **************************************************************************/
      virtual t_Void vPostSetAppIconAttributesResult(tenResponseCode /*enResponseCode*/,
               tenErrorCode /*enErrorCode*/,
               const trUserContext /*rcUsrCntxt*/)
      {
         //Add code
      }
      //SetAppIconAttrResp
      //GetAppIconUrlResp

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostSetMLNotificationEnabledInfoResult()
   ***************************************************************************/
   /*!
   * \fn     vPostSetMLNotificationEnabledInfoResult(t_U32 u32DeviceHandle, 
   *            tenResponseCode enResponseCode, tenErrorCode enErrorCode, 
   *            const trUserContext rcUsrCntxt)
   * \brief  Interface to set the device notification preference for
   *         applications (only for Mirror Link devices). If notification for
   *         all the applications has to be
   * \param  [IN] u32DeviceHandle   : Uniquely identifies the target Device.
   * \param  [IN] enResponseCode :  Provides result from the operation.
   * \param  [IN] enErrorCode : Provides the Error Code in case ResponseCode==FAILURE.
   *              Set to NO_ERROR for successful operation.
   * \param  [IN] rcUsrCntxt	 : User Context Details.
   * \sa     spi_tclCmdInterface::vSetMLNotificationEnabledInfo
   **************************************************************************/
   virtual t_Void vPostSetMLNotificationEnabledInfoResult(t_U32 /*u32DeviceHandle*/,
      tenResponseCode /*enResponseCode*/,
      tenErrorCode /*enErrorCode*/,
      const trUserContext /*rcUsrCntxt*/)
   {
      //add code
   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostNotificationInfo()
   ***************************************************************************/
   /*!
   * \fn     vPostNotificationInfo(t_U32 u32DeviceHandle, t_U32 u32AppHandle,
   *            NotificationData &rfrNotificationData)
   * \brief  Interface to provide Notification Information received from
   *         the Mirror Link server (only for Mirror Link devices).
   * \param  [IN] u32DeviceHandle   :  Handle uniquely identifies a device.
   * \param  [IN] u32AppHandle      : Handle uniquely identifies an application
   *              on the device.
   * \param  [IN] corfrNotificationData : Provides notification event details
   * \sa     spi_tclCmdInterface::vSetMLNotificationEnabledInfo
   **************************************************************************/
   virtual t_Void vPostNotificationInfo(t_U32 /*u32DeviceHandle*/,
      t_U32 /*u32AppHandle*/,
      const trNotiData& /*corfrNotificationData*/)
   {
      //add code
   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostInvokeNotificationActionResult()
   ***************************************************************************/
   /*!
   * \fn     vPostInvokeNotificationActionResult(tenResponseCode enResponseCode,
   *            tenErrorCode enErrorCode, const trUserContext rcUsrCntxt)
   * \brief  Interface to invoke the respective action for the
   *         received Notification Event.
   * \param  [IN] enResponseCode :  Provides result from the operation.
   * \param  [IN] enErrorCode : Provides the Error Code in case ResponseCode==FAILURE.
   *              Set to NO_ERROR for successful operation.
   * \param  [IN] rcUsrCntxt		 : User Context Details.
   * \sa     spi_tclCmdInterface::vInvokeNotificationAction
   **************************************************************************/
   virtual t_Void vPostInvokeNotificationActionResult(tenResponseCode /*enResponseCode*/,
      tenErrorCode /*enErrorCode*/,
      const trUserContext /*rcUsrCntxt*/)
   {
      //add code
   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vUpdateAppBlockingInfo()
   ***************************************************************************/
   /*!
   * \fn     virtual t_Void vUpdateAppBlockingInfo(t_U32 u32DeviceHandle,
   *             tenDeviceCategory enDevCat, tenSessionStatus enSessionStatus)
   * \brief  It notifies the client about the Application blocking using the
   *          session status update
   * \param  [IN] u32DeviceHandle : Uniquely identifies the target Device.
   * \param  [IN] enDevCat   : Identifies the Device category.
   * \param  [IN] enSessionStatus : Session status
   **************************************************************************/
   virtual t_Void vUpdateAppBlockingInfo(t_U32 /*u32DeviceHandle*/,
      tenDeviceCategory /*enDevCat*/,
      tenSessionStatus /*enSessionStatus*/){}

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vUpdateActiveAppInfo()
   ***************************************************************************/
   /*!
   * \fn     t_Void vUpdateActiveAppInfo(const t_U32 cou32DevId,
   *            const tenDeviceCategory coenDevCat,
   *            const t_U32 cou32AppId,
   *            const tenAppCertificationInfo coenAppCertInfo)
   * \brief  method to send the Active App update to HMI
   * \param  cou32DevId       : [IN] Uniquely identifies the target Device.
   * \param  coenDevCat       : [IN] Device category
   * \param  cou32AppId       : [IN] AppId
   * \param  coenAppCertInfo  : [IN] Certification Status
   * \retval t_Void
   **************************************************************************/
   virtual t_Void vUpdateActiveAppInfo(t_U32 /*u32DeviceHandle*/,
      tenDeviceCategory /*enDevCat*/,
      const t_U32 /*cou32AppId*/,
      const tenAppCertificationInfo /*coenAppCertInfo*/){}

   /************************************************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostNavigationStatus(...)
   ************************************************************************************************************/
   /*!
   * \fn     vPostNavigationStatus(const trNavStatusData& corfrNavStatusData)
   * \brief  It notifies the client whenever there is a navigation status change(ACTIVE/INACTIVE/UNAVAILABLE).
   * \param  corfrNavStatusData  : [IN] Structure containing the device handle,
   *                                    device category and navigation status
   ************************************************************************************************************/
   virtual t_Void vPostNavigationStatus(const trNavStatusData& corfrNavStatusData)
   {
      SPI_INTENTIONALLY_UNUSED(corfrNavStatusData);
   }

   /*******************************************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostNavigationNextTurnDataStatus(...)
   *******************************************************************************************************/
   /*!
   * \fn     vPostNavigationNextTurnDataStatus(const trNavNextTurnData& corfrNavNexTurnData)
   * \brief  It notifies the client whenever there is a navigation next turn event information.
   * \param  corfrNavNexTurnData : [IN] Structure containing device handle, device category, road name,
   *                                    next turn details such as side, event, image, angle and number
   *******************************************************************************************************/
   virtual t_Void vPostNavigationNextTurnDataStatus(const trNavNextTurnData& corfrNavNexTurnData)
   {
      SPI_INTENTIONALLY_UNUSED(corfrNavNexTurnData);
   }

   /*******************************************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostNavigationNextTurnDistanceDataStatus(...)
   *******************************************************************************************************/
   /*!
   * \fn     vPostNavigationNextTurnDistanceDataStatus(
   *          const trNavNextTurnDistanceData& corfrNavNextTurnDistData)
   * \brief  It notifies the client whenever there is a change in navigation next turn distance data.
   * \param  corfrNavNextTurnDistData : [IN] Structure containing device handle,
   *                                         device category, distance and time of the next turn
   *******************************************************************************************************/
   virtual t_Void vPostNavigationNextTurnDistanceDataStatus(
                   const trNavNextTurnDistanceData& corfrNavNextTurnDistData)
   {
      SPI_INTENTIONALLY_UNUSED(corfrNavNextTurnDistData);
   }

   /*******************************************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostNotificationData(...)
   *******************************************************************************************************/
   /*!
   * \fn     vPostNotificationData(
   *          const trNotificationData& corfrNotificationData)
   * \brief  It notifies the client whenever a notification is received.
   * \param  corfrNotificationData : [IN] Structure containing device handle,
   *                                      device category and notification data
   *******************************************************************************************************/
   virtual t_Void vPostNotificationData(
                   const trNotificationData& corfrNotificationData)
   {
      SPI_INTENTIONALLY_UNUSED(corfrNotificationData);
   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostSetVideoBlockingModeResult()
   ***************************************************************************/
   /*!
   * \fn     vPostSetVideoBlockingModeResult(tenResponseCode enResponseCode,
   *                         tenErrorCode enErrorCode, const trUserContext& corfrcUsrCntxt)
   * \brief  Interface to set the display blocking mode.
   * \param  [IN] enResponseCode : Provides result from the operation.
   * \param  [IN] enErrorCode : Provides the Error Code in case ResponseCode==FAILURE.
   *              Set to NO_ERROR for successful operation.
   * \param  [IN] corfrcUsrCntxt	 : User Context Details.
   * \sa     spi_tclCmdInterface::vSetVideoBlockingMode
   **************************************************************************/
   virtual t_Void vPostSetVideoBlockingModeResult(tenResponseCode enResponseCode,
      tenErrorCode enErrorCode, 
      const trUserContext& corfrcUsrCntxt)=0;

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostApplicationMediaMetaData(t_U32& ...
   ***************************************************************************/
   /*!
   * \fn     vPostApplicationMediaMetaData(const trAppMediaMetaData& rfcorApplicationMediaMetaData,
   *            const trUserContext& rfcorUsrCntxt)
   * \brief  Interface to notify application media metadata to the client.
   * \param  [IN] rfcorApplicationMediaMetaData : Contains the media metadata information
   *              related to an application.
   * \param  [IN] rfcorUsrCntxt    : User Context Details.
   * \sa
   **************************************************************************/
   virtual t_Void vPostApplicationMediaMetaData(const trAppMediaMetaData& rfcorApplicationMediaMetaData,
      const trUserContext& rfcorUsrCntxt)
   {
       SPI_INTENTIONALLY_UNUSED(rfcorApplicationMediaMetaData);
       SPI_INTENTIONALLY_UNUSED(rfcorUsrCntxt);
   }
   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostApplicationPhoneData(...
   ***************************************************************************/
   /*!
   * \fn     vPostApplicationPhoneData(const trAppPhoneData& rfcorApplicationPhoneData,
   *            const trUserContext& rfcorUsrCntxt)
   * \brief  Interface to notify application media metadata to the client.
   * \param  [IN] rfcorApplicationPhoneData : Contains the phone related information.
   * \param  [IN] rfcorUsrCntxt    : User Context Details.
   * \sa
   **************************************************************************/
   virtual t_Void vPostApplicationPhoneData(const trAppPhoneData& rfcorApplicationPhoneData,
      const trUserContext& rfcorUsrCntxt)
   {
       SPI_INTENTIONALLY_UNUSED(rfcorApplicationPhoneData);
       SPI_INTENTIONALLY_UNUSED(rfcorUsrCntxt);
   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostApplicationPhoneCallData(...
   ***************************************************************************/
   /*!
   * \fn     vPostApplicationPhoneCallData(const trAppPhoneCallData& rfcorApplicationPhoneCallData,
   *            const trUserContext& rfcorUsrCntxt)
   * \brief  Interface to notify application media metadata to the client.
   * \param  [IN] rfcorApplicationPhoneCallData : Contains the phone related information.
   * \param  [IN] rfcorUsrCntxt    : User Context Details.
   * \sa
   **************************************************************************/
   virtual t_Void vPostApplicationPhoneCallData(const trAppPhoneCallData& rfcorApplicationPhoneCallData,
      const trUserContext& rfcorUsrCntxt)
   {
       SPI_INTENTIONALLY_UNUSED(rfcorApplicationPhoneCallData);
       SPI_INTENTIONALLY_UNUSED(rfcorUsrCntxt);
   }
   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostApplicationMediaPlaytime(...
   ***************************************************************************/
   /*!
   * \fn     vPostApplicationMediaPlaytime(const trAppMediaPlaytime& rfcorApplicationMediaPlaytime,
   *            const trUserContext& rfcorUsrCntxt)
   * \brief  Interface to notify application media metadata to the client.
   * \param  [IN] rfcorApplicationMediaPlaytime : Contains the media play time of current playing track.
   * \param  [IN] rfcorUsrCntxt    : User Context Details.
   * \sa
   **************************************************************************/
   virtual t_Void vPostApplicationMediaPlaytime(const trAppMediaPlaytime& rfcorApplicationMediaPlaytime,
      const trUserContext& rfcorUsrCntxt)
   {
       SPI_INTENTIONALLY_UNUSED(rfcorApplicationMediaPlaytime);
       SPI_INTENTIONALLY_UNUSED(rfcorUsrCntxt);
   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostApplicationMediaAlbumArt(const...
   ***************************************************************************/
   /*!
   * \fn     vPostApplicationMediaAlbumArt(const trAppMediaAlbumArt& corfrAppMediaAlbumArt,
   *         const trUserContext& corfrUsrCntxt)
   * \brief  Interface to notify application media albumart to the client.
   * \param  corfrAppMediaAlbumArt : [IN] Contains the media albumart information.
   * \param  corfrUsrCntxt         : [IN] User Context Details.
   * \retval t_Void
   * \sa
   **************************************************************************/
   virtual t_Void vPostApplicationMediaAlbumArt(const trAppMediaAlbumArt& corfrAppMediaAlbumArt,
         const trUserContext& corfrUsrCntxt)
   {
       SPI_INTENTIONALLY_UNUSED(corfrAppMediaAlbumArt);
       SPI_INTENTIONALLY_UNUSED(corfrUsrCntxt);
   }

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostDeviceLockInfo()
   ***************************************************************************/
   /*!
   * \fn      t_Void vPostDeviceLockInfo(t_Bool bDeviceLockEnabled)
   * \brief   Posts the Device Lock info whether it is enabled or disabled
   * \param   bDeviceLockEnabled : [IN]  True - If Device Lock is enabled
   *                                    False - If Device Lock is disabled
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vPostDeviceLockInfo(const t_U32& /*corfu32DeviceHandle*/,
            const tenDeviceCategory& /*corfenDevCat*/, const t_Bool& /*bDeviceLockEnabled*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostTurnByTurnInfo()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostTurnByTurnInfo()
    * \brief   Called when Turn by turn data is available.
    * \param   corfrTurnByTurnInfo: structure to hold turn by turn data
    * \sa      None
    **************************************************************************/
    virtual t_Void vPostTurnByTurnInfo(const trTurnByTurnInfo &corfrTurnByTurnInfo)
    {
        SPI_INTENTIONALLY_UNUSED(corfrTurnByTurnInfo);
    }

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostNaviInfo()
     ***************************************************************************/
    /*!
     * \fn      vPostCDBNaviInfo(const trCDBNavigationInfo& rfcorCDBNaviInfo,
     *          const trUserContext& rfcorUsrCntxt)
     * \brief   method to update the navigation info.
     * \param   rfcorCDBNaviInfo : [IN] Contains Navigation Info.
     * \param   rfcorUsrCntxt    : [IN] User Context Details.
     * \retval  t_Void
     **************************************************************************/
    virtual t_Void vPostCDBNaviInfo(const trMLNavigationInfo& /*rfcorCDBNaviInfo*/, const trUserContext& /*rfcorUsrCntxt*/)
    {

    }

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostCDBNaviTBT()
     ***************************************************************************/
    /*!
     * \fn      vPostCDBNaviTBT(const trCDBNavigationNextManeuver& rfcorCDBNaviTBT,
     *          const trUserContext& rfcorUsrCntxt)
     * \brief   method to update the navigation TBT.
     * \param   rfcorCDBNaviInfo : [IN] Contains Navigation TBT.
     * \param   rfcorUsrCntxt    : [IN] User Context Details.
     * \retval  t_Void
     **************************************************************************/
    virtual t_Void vPostCDBNaviTBT(const trMLNavigationNextManeuver& /*rfcorCDBNaviTBT*/,
             const trUserContext& /*rfcorUsrCntxt*/)
    {

    }

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostCDBNaviSpdLimit()
     ***************************************************************************/
    /*!
     * \fn     vPostCDBNaviSpdLimit(const trCDBNavigationSpeedLimit& rfcorCDBNaviSpdLimit,
     *         const trUserContext& rfcorUsrCntxt)
     * \brief   method to update the navigation Speed Limit.
     * \param   rfcorCDBNaviSpdLimit : [IN] Contains Navigation TBT.
     * \param   rfcorUsrCntxt        : [IN] User Context Details.
     * \retval  t_Void
     **************************************************************************/
    virtual t_Void vPostCDBNaviSpdLimit(const trMLNavigationSpeedLimit& /*rfcorCDBNaviSpdLimit*/,
             const trUserContext& /*rfcorUsrCntxt*/)
    {

    }

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostCDBNaviNextDistance()
     ***************************************************************************/
    /*!
     * \fn     vPostCDBNaviSpdLimit(const trCDBNavigationSpeedLimit& rfcorCDBNaviNextDistance,
     *         const trUserContext& rfcorUsrCntxt)
     * \brief   method to update the navigation next distance.
     * \param   rfcorCDBNaviSpdLimit : [IN] Contains Navigation TBT.
     * \param   rfcorUsrCntxt        : [IN] User Context Details.
     * \retval  t_Void
     **************************************************************************/
    virtual t_Void vPostCDBNaviNextDistance(const trMLNavigationNextDistance& /*rfcorCDBNaviNextDistance*/,
             const trUserContext& /*rfcorUsrCntxt*/)
    {

    }

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostCDBNaviLaneGuidance()
     ***************************************************************************/
    /*!
     * \fn     vPostCDBNaviLaneGuidance(const trCDBNavigationLaneGuidance& rfcorCDBNaviLaneGuidance,
     *         const trUserContext& rfcorUsrCntxt)
     * \brief   method to update the navigation lane guidance.
     * \param   rfcorCDBNaviSpdLimit : [IN] Contains Navigation Lane Guidance.
     * \param   rfcorUsrCntxt        : [IN] User Context Details.
     * \retval  t_Void
     **************************************************************************/
    virtual t_Void vPostCDBNaviLaneGuidance(const trMLNavigationLaneGuidance& /*rfcorCDBNaviLaneGuidance*/,
             const trUserContext& /*rfcorUsrCntxt*/)
    {

    }

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostCDBNaviTripInfo()
     ***************************************************************************/
    /*!
     * \fn     vPostCDBNaviTripInfo(const trCDBNavigationTripInfo& rfcorCDBNaviTripInfo,
     *         const trUserContext& rfcorUsrCntxt)
     * \brief   method to update the navigation trip info.
     * \param   rfcorCDBNaviSpdLimit : [IN] Contains Navigation Trip Info.
     * \param   rfcorUsrCntxt        : [IN] User Context Details.
     * \retval  t_Void
     **************************************************************************/
    virtual t_Void vPostCDBNaviTripInfo(const trMLNavigationTripInfo& /*rfcorCDBNaviTripInfo*/,
             const trUserContext& /*rfcorUsrCntxt*/)
    {

    }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostVendorExtsnData(const...
   ***************************************************************************/
   /*!
   * \fn     vPostVendorExtsnData(const t_U8* poVendorExtsnData,
   *         const trUserContext& corfrUsrCntxt)
   * \brief  Interface to post vendor extension data.
   * \param  poVendorExtsnData     : [IN] Contains the media albumart information.
   * \param  uLengthOfData         : [IN] Length of the Data.
   * \retval t_Void
   * \sa
   **************************************************************************/
   virtual t_Void vPostVendorExtsnData(const t_U8* /*poVendorExtsnData*/, size_t /*uLengthOfData*/)
   {

   }

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclAppMngrRespIntf::vPostSendVendorExtsnDataResult(const...
   ***************************************************************************/
   /*!
   * \fn     vPostVendorExtsnData(const t_U8* poVendorExtsnData,
   *         const trUserContext& corfrUsrCntxt)
   * \brief  Interface to post vendor extension data.
   * \param  poVendorExtsnData     : [IN] Contains the media albumart information.
   * \param  uLengthOfData         : [IN] Length of the Data.
   * \retval t_Void
   * \sa
   **************************************************************************/
   virtual t_Void vPostSendVendorExtsnDataResult(tenResponseCode /*enResponseCode*/,tenErrorCode /*enErrorCode*/,
           const trUserContext /*rcUsrCntxt*/)
    {

    }

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostAAutoTurnByTurnInfo()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAAutoTurnByTurnInfo(t_U32 u32DevHandle,
    *           const trAAutoTBTUpdate &corfrAAutoTBTUpdate)
    * \brief   Called when Android Auto Turn by turn data is available.
    * \param   u32DevHandle       : [IN] Unique identifier of the target device
    * \param   corfrAAutoTBTUpdate: [IN] Structure to hold AndroidAuto Turn-By-Turn data
    * \sa      None
    **************************************************************************/
    virtual t_Void vPostAAutoTurnByTurnInfo(t_U32 u32DevHandle, const trAAutoTBTUpdate &corfrAAutoTBTUpdate)
    {
        SPI_INTENTIONALLY_UNUSED(u32DevHandle);
        SPI_INTENTIONALLY_UNUSED(corfrAAutoTBTUpdate);
    }

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostMLTurnByTurnInfo()
     ***************************************************************************/
    /*!
     * \fn      t_Void vPostMLTurnByTurnInfo(t_U32 u32DevHandle,
     *           const trMLTBTUpdate &corfrMLTBTUpdate)
     * \brief   Called when MirrorLink Turn by turn data is available.
     * \param   u32DevHandle    : [IN] Unique identifier of the target device
     * \param   corfrMLTBTUpdate: [IN] Structure to hold MirrorLink Turn-By-Turn data
     * \sa      None
     **************************************************************************/
     virtual t_Void vPostMLTurnByTurnInfo(t_U32 u32DevHandle, const trMLTBTUpdate &corfrMLTBTUpdate)
     {
         SPI_INTENTIONALLY_UNUSED(u32DevHandle);
         SPI_INTENTIONALLY_UNUSED(corfrMLTBTUpdate);
     }

     /***************************************************************************
      ** FUNCTION:  t_Void spi_tclAppMngrRespIntf::vPostBDCLTurnByTurnInfo()
      ***************************************************************************/
     /*!
      * \fn      t_Void vPostBDCLTurnByTurnInfo(t_U32 u32DevHandle,
      *           const trBDCLTBTUpdate &corfrBDCLTBTUpdate)
      * \brief   Called when Baidu Carlife Turn by turn data is available.
      * \param   u32DevHandle       : [IN] Unique identifier of the target device
      * \param   corfrBDCLTBTUpdate : [IN] Structure to hold Carlife Turn-By-Turn data
      * \sa      None
      **************************************************************************/
      virtual t_Void vPostBDCLTurnByTurnInfo(t_U32 u32DevHandle, const trBDCLTBTUpdate &corfrBDCLTBTUpdate)
      {
          SPI_INTENTIONALLY_UNUSED(u32DevHandle);
          SPI_INTENTIONALLY_UNUSED(corfrBDCLTBTUpdate);
      }

    /********************************************************************************************
     * \FUNCTION   :tVoid spi_tclAppMngrRespIntf:: vPostCarPlayRouteGuidanceUpdate(...)
     *********************************************************************************************/
    virtual t_Void vPostCarPlayRouteGuidanceUpdate(const trDiPORouteGuidanceUpdate &corfrRouteGuidanceUpdate)
    {
        SPI_INTENTIONALLY_UNUSED(corfrRouteGuidanceUpdate);
    }

    /********************************************************************************************
     * \FUNCTION   :tVoid spi_tclAppMngrRespIntf:: vPostCarPlayRouteGuidanceManeuverUpdate(...)
     *********************************************************************************************/
    virtual t_Void vPostCarPlayRouteGuidanceManeuverUpdate(const trDiPORouteGuidanceManeuverUpdate &corfrRouteGuidanceManeuverUpdate)
    {
        SPI_INTENTIONALLY_UNUSED(corfrRouteGuidanceManeuverUpdate);
    }


   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/



   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

};//spi_tclAppMngrRespIntf

#endif //SPI_TCL_APPMNGR_RESPINTF
