/***********************************************************************/
/*!
 * \file  spi_tclExtWiFiDispatcher.cpp
 * \brief Message Dispatcher for WiFi Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for WiFi Messages
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 09.01.2017  | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtWiFiDispatcher.h"
#include "spi_tclExtRespWiFi.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtWiFiDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleWiFiMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  WiFiMsgBase::WiFiMsgBase
 ***************************************************************************/
WiFiMsgBase::WiFiMsgBase()
{
   ETG_TRACE_USR1(("WiFiMsgBase::WiFiMsgBase entered"));
   vSetServiceID(e32MODULEID_EXTWIFI);
}

//!class ConfigureWiFiResultMsg
/***************************************************************************
 ** FUNCTION:  ConfigureWiFiResultMsg::ConfigureWiFiResultMsg
 ***************************************************************************/
ConfigureWiFiResultMsg::ConfigureWiFiResultMsg():
		m_bConfigureWiFiResult(false)
{
   ETG_TRACE_USR1(("[FUNC]ConfigureWiFiResultMsg::ConfigureWiFiResultMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  ConfigureWiFiResultMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(ConfigureWiFiResultMsg, spi_tclExtWiFiDispatcher);

/***************************************************************************
 ** FUNCTION:  ConfigureWiFiResultMsg::vAllocateMsg
 ***************************************************************************/
t_Void ConfigureWiFiResultMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]ConfigureWiFiResultMsg::vAllocateMsg entered"));
}

/***************************************************************************
 ** FUNCTION:  ConfigureWiFiResultMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void ConfigureWiFiResultMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]ConfigureWiFiResultMsg::vDeAllocateMsg entered"));
}

//!class WiFiConfigMsg
/***************************************************************************
 ** FUNCTION:  WiFiConfigMsg::WiFiConfigMsg
 ***************************************************************************/
WiFiConfigMsg::WiFiConfigMsg(): m_rWiFiConfig(NULL),m_pvecAssociatedStationsInfo(NULL)
{
}

/***************************************************************************
 ** FUNCTION:  WiFiConfigMsg::WiFiConfigMsg
 ***************************************************************************/
WiFiConfigMsg::WiFiConfigMsg(const trWiFiConfig &rfcorWiFiConfig,const std::vector<trStationInfo>& corvecStationsInfo):
                             m_rWiFiConfig(NULL),m_pvecAssociatedStationsInfo(NULL)
{
   vAllocateMsg();
   if(NULL != m_rWiFiConfig)
   {
      (*m_rWiFiConfig) = rfcorWiFiConfig;
   }
   if(NULL != m_pvecAssociatedStationsInfo)
   {
	  (*m_pvecAssociatedStationsInfo) = corvecStationsInfo;
   }
}

/***************************************************************************
 ** FUNCTION:  WiFiConfigMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(WiFiConfigMsg, spi_tclExtWiFiDispatcher);

/***************************************************************************
 ** FUNCTION:  WiFiConfigMsg::vAllocateMsg
 ***************************************************************************/
t_Void WiFiConfigMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]WiFiConfigMsg::vAllocateMsg entered"));
   m_rWiFiConfig = new(std::nothrow)trWiFiConfig();
   SPI_NORMAL_ASSERT(NULL == m_rWiFiConfig)
   
   m_pvecAssociatedStationsInfo = new(std::nothrow)std::vector<trStationInfo>;
   SPI_NORMAL_ASSERT(NULL == m_pvecAssociatedStationsInfo)
}

/***************************************************************************
 ** FUNCTION:  WiFiConfigMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void WiFiConfigMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]WiFiConfigMsg::vDeAllocateMsg entered"));
   RELEASE_MEM(m_rWiFiConfig);
   RELEASE_MEM(m_pvecAssociatedStationsInfo);
}

//!class SupportedFrequenciesMsg
/***************************************************************************
 ** FUNCTION:  SupportedFrequenciesMsg::SupportedFrequenciesMsg
 ***************************************************************************/
SupportedFrequenciesMsg::SupportedFrequenciesMsg(): m_mapSupportedFrequencies(NULL)
{
}

/***************************************************************************
 ** FUNCTION:  SupportedFrequenciesMsg::SupportedFrequenciesMsg
 ***************************************************************************/
SupportedFrequenciesMsg::SupportedFrequenciesMsg(const tMapSupportedFrequencies& cormapSupportedFrequencies):
      m_mapSupportedFrequencies(NULL)
{
   vAllocateMsg();
   if(NULL != m_mapSupportedFrequencies)
   {
      (*m_mapSupportedFrequencies) = cormapSupportedFrequencies;
   }
}

/***************************************************************************
 ** FUNCTION:  SupportedFrequenciesMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(SupportedFrequenciesMsg, spi_tclExtWiFiDispatcher);

/***************************************************************************
 ** FUNCTION:  SupportedFrequenciesMsg::vAllocateMsg
 ***************************************************************************/
t_Void SupportedFrequenciesMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]SupportedFrequenciesMsg::vAllocateMsg entered"));
   m_mapSupportedFrequencies = new(std::nothrow)tMapSupportedFrequencies;
   SPI_NORMAL_ASSERT(NULL == m_mapSupportedFrequencies)
}

/***************************************************************************
 ** FUNCTION:  SupportedFrequenciesMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void SupportedFrequenciesMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]SupportedFrequenciesMsg::vDeAllocateMsg entered"));
   RELEASE_MEM(m_mapSupportedFrequencies);
}

//!class spi_tclExtWiFiDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtWiFiDispatcher::spi_tclExtWiFiDispatcher
 ***************************************************************************/
spi_tclExtWiFiDispatcher::spi_tclExtWiFiDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtWiFiDispatcher::spi_tclExtWiFiDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtWiFiDispatcher::~spi_tclExtWiFiDispatcher
 ***************************************************************************/
spi_tclExtWiFiDispatcher::~spi_tclExtWiFiDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtWiFiDispatcher::~spi_tclExtWiFiDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtWiFiDispatcher::vHandleWiFiMsg(ConfigureWiFiResultMsg...)
 ***************************************************************************/
t_Void spi_tclExtWiFiDispatcher::
        vHandleWiFiMsg(ConfigureWiFiResultMsg* poConfigureWiFiResult)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtWiFiDispatcher::vHandleWifiMsg entered "));
   if (NULL != poConfigureWiFiResult)
   {
      CALL_REG_OBJECTS(spi_tclExtRespWiFi,
    		  e16EXT_WIFI_REGID,
    		  vPostConfigureWiFiResult(poConfigureWiFiResult->m_bConfigureWiFiResult));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtWiFiDispatcher::vHandleWiFiMsg(WiFiActiveWifiSetupMsg...)
 ***************************************************************************/
t_Void spi_tclExtWiFiDispatcher::
        vHandleWiFiMsg(WiFiConfigMsg* poWiFiConfig) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtWiFiDispatcher::vHandleWifiMsg entered "));
   if (NULL != poWiFiConfig)
   {
      CALL_REG_OBJECTS(spi_tclExtRespWiFi,
    		  e16EXT_WIFI_REGID,
    		  vPostWiFiConfig(*(poWiFiConfig->m_rWiFiConfig),*(poWiFiConfig->m_pvecAssociatedStationsInfo)));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtWiFiDispatcher::vHandleWiFiMsg(SupportedFrequenciesMsg...)
 ***************************************************************************/
t_Void spi_tclExtWiFiDispatcher::
        vHandleWiFiMsg(SupportedFrequenciesMsg* poSupportedFrequencies) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtWiFiDispatcher::SupportedFrequenciesMsg entered "));
   if (NULL != poSupportedFrequencies)
   {
      CALL_REG_OBJECTS(spi_tclExtRespWiFi,
           e16EXT_WIFI_REGID,
           vPostSupportedFrequenciesInfo(*(poSupportedFrequencies->m_mapSupportedFrequencies)));
   }
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
