/***********************************************************************/
/*!
 * \file  spi_tclExtWiFiDispatcher.h
 * \brief Message Dispatcher for WiFi Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for WiFi Messages
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 09.01.2017  | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLEXTWIFIDISPATCHER_H_
#define _SPI_TCLEXTWIFIDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_WifiTypedefs.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"

/**************Forward Declarations******************************************/
class spi_tclExtWiFiDispatcher;

/****************************************************************************/
/*!
 * \class WiFiMsgBase
 * \brief Base Message type for all WiFi messages
 ****************************************************************************/
class WiFiMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  WiFiMsgBase::WiFiMsgBase
    ***************************************************************************/
   /*!
    * \fn      WiFiMsgBase()
    * \brief   Default constructor
    **************************************************************************/
	WiFiMsgBase();

   /***************************************************************************
    ** FUNCTION:  WiFiMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poWiFiDispatcher : pointer to Message dispatcher for WiFi
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  WiFiMsgBase::~WiFiMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~WiFiMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~WiFiMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class ConfigureWiFiResultMsg
 * \brief Configure WiFi Result msg
 ****************************************************************************/
class ConfigureWiFiResultMsg: public WiFiMsgBase
{
   public:

   t_Bool m_bConfigureWiFiResult;

   /***************************************************************************
    ** FUNCTION:  ConfigureWiFiResultMsg::ConfigureWiFiResultMsg
    ***************************************************************************/
   /*!
    * \fn      ConfigureWiFiResultMsg()
    * \brief   Default constructor
    **************************************************************************/
   ConfigureWiFiResultMsg();

   /***************************************************************************
    ** FUNCTION:  ConfigureWiFiResultMsg::~ConfigureWiFiResultMsg
    ***************************************************************************/
   /*!
    * \fn      ~ConfigureWiFiResultMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~ConfigureWiFiResultMsg(){}

   /***************************************************************************
    ** FUNCTION:  ConfigureWiFiResultMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poWiFiDispatcher : pointer to Message dispatcher for WiFi
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher);

   /***************************************************************************
    ** FUNCTION:  ConfigureWiFiResultMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  ConfigureWiFiResultMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class WiFiConfigMsg
 * \brief ActiveWifiSetup msg
 ****************************************************************************/
class WiFiConfigMsg: public WiFiMsgBase
{
   public:

	trWiFiConfig *m_rWiFiConfig;
	std::vector<trStationInfo> *m_pvecAssociatedStationsInfo;

   /***************************************************************************
    ** FUNCTION:  WiFiConfigMsg::WiFiConfigMsg
    ***************************************************************************/
   /*!
    * \fn      WiFiConfigMsg()
    * \brief   Default constructor
    **************************************************************************/
	WiFiConfigMsg();

   /***************************************************************************
    ** FUNCTION:  WiFiConfigMsg::WiFiConfigMsg
    ***************************************************************************/
   /*!
    * \fn      WiFiConfigMsg(const trWiFiConfig &rfcorWiFiConfig,
	*           const std::vector<trStationInfo>& corvecStationsInfo)
    * \brief   Parameterized constructor
    **************************************************************************/
	WiFiConfigMsg(const trWiFiConfig &rfcorWiFiConfig,const std::vector<trStationInfo>& corvecStationsInfo);

   /***************************************************************************
    ** FUNCTION:  WiFiConfigMsg::~WiFiConfigMsg
    ***************************************************************************/
   /*!
    * \fn      ~WiFiConfigMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~WiFiConfigMsg(){}

   /***************************************************************************
    ** FUNCTION:  WiFiConfigMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poWiFiDispatcher : pointer to Message dispatcher for WiFi
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher);

   /***************************************************************************
    ** FUNCTION:  WiFiConfigMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  WiFiConfigMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class SupportedFrequenciesMsg
 * \brief Supported frequencies msg
 ****************************************************************************/
class SupportedFrequenciesMsg: public WiFiMsgBase
{
   public:

   tMapSupportedFrequencies *m_mapSupportedFrequencies;

   /***************************************************************************
    ** FUNCTION:  SupportedFrequenciesMsg::SupportedFrequenciesMsg
    ***************************************************************************/
   /*!
    * \fn      SupportedFrequenciesMsg()
    * \brief   Default constructor
    **************************************************************************/
   SupportedFrequenciesMsg();

   /***************************************************************************
    ** FUNCTION:  SupportedFrequenciesMsg::SupportedFrequenciesMsg
    ***************************************************************************/
   /*!
    * \fn      SupportedFrequenciesMsg(const tMapSupportedFrequencies
	*           &cormapSupportedFrequencies)
    *       
    * \brief   Parameterized constructor
    **************************************************************************/
   SupportedFrequenciesMsg(const tMapSupportedFrequencies& cormapSupportedFrequencies);

   /***************************************************************************
    ** FUNCTION:  SupportedFrequenciesMsg::~SupportedFrequenciesMsg
    ***************************************************************************/
   /*!
    * \fn      ~SupportedFrequenciesMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~SupportedFrequenciesMsg(){}

   /***************************************************************************
    ** FUNCTION:  SupportedFrequenciesMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poWiFiDispatcher : pointer to Message dispatcher for WiFi
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher);

   /***************************************************************************
    ** FUNCTION:  SupportedFrequenciesMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  SupportedFrequenciesMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclExtWiFiDispatcher
 * \brief Message Dispatcher for WiFi Messages
 ****************************************************************************/
class spi_tclExtWiFiDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtWiFiDispatcher::spi_tclExtWiFiDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtWiFiDispatcher()
    * \brief   Default constructor
    **************************************************************************/
      spi_tclExtWiFiDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtWiFiDispatcher::~spi_tclExtWiFiDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtWiFiDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtWiFiDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtWiFiDispatcher::vHandleWiFiMsg(ConfigureWiFiResultMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleWiFiMsg(ConfigureWiFiResultMsg* poConfigureWiFiResult)
    * \brief   Handles Messages of ConfigureWiFiResultMsg type
    * \param   poConfigureWiFiResult : pointer to ConfigureWiFiResultMsg.
    **************************************************************************/
   t_Void vHandleWiFiMsg(ConfigureWiFiResultMsg* poConfigureWiFiResult) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtWiFiDispatcher::vHandleWiFiMsg(WiFiActiveWifiSetupMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleWiFiMsg(WiFiConfigMsg* poWiFiConfig)
    * \brief   Handles Messages of WiFiConfigMsg type
    * \param   poWiFiConfig : pointer to WiFiConfigMsg.
    **************************************************************************/
   t_Void vHandleWiFiMsg(WiFiConfigMsg* poWiFiConfig) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtWiFiDispatcher::vHandleWiFiMsg(SupportedFrequenciesMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleWiFiMsg(SupportedFrequenciesMsg* poSupportedFrequencies)
    * \brief   Handles Messages of SupportedFrequenciesMsg type
    * \param   poWiFiConfig : pointer to SupportedFrequenciesMsg.
    **************************************************************************/
   t_Void vHandleWiFiMsg(SupportedFrequenciesMsg* poSupportedFrequencies) const;

};

#endif /* _SPI_TCLEXTWIFIDISPATCHER_H_ */
