/*!
 *******************************************************************************
 * \file              spi_tclExtRespWiFi.h
 * \brief             External Interfaces Wrapper Response class for WiFi
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   External Interfaces Wrapper Response class for WiFi
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 09.01.2017 | Unmukt Jain           | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLEEXTRESPWIFI_H_
#define _SPI_TCLEEXTRESPWIFI_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"
#include "spi_WifiTypedefs.h"

class spi_tclExtRespWiFi: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespWiFi::spi_tclExtRespWiFi()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespWiFi()
    * \brief   Constructor
    * \sa      spi_tclExtRespWiFi()
    **************************************************************************/
      spi_tclExtRespWiFi(): RespBase(e16EXT_WIFI_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespWiFi::~spi_tclExtRespWiFi()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespWiFi()
    * \brief   Destructor
    * \sa      spi_tclExtRespWiFi()
    **************************************************************************/
   virtual ~spi_tclExtRespWiFi() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespWiFi::vPostConfigureWiFiResult()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostConfigureWiFiResult()
    * \brief   Called when ConfigureWiFi operation result is sent by WBL Client Handler.
    *          Mandatory interface to be implemented.
    * \param   [IN] bConfigureWiFiResult: Result of ConfigureWiFi operation
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostConfigureWiFiResult(t_Bool /*bConfigureWiFiResult*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespWiFi::vPostWiFiConfig()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostWiFiConfig()
    * \brief   Called when ActiveWifiSetup structure is sent by WBL Client Handler.
    *          Mandatory interface to be implemented.
    * \param   [IN] rWifiAPConfig: structure of type trWiFiConfig
    * \param   [IN] corfvecStationsInfo: List of connected stations.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostWiFiConfig(const trWiFiConfig &rfcorWiFiConfig,const std::vector<trStationInfo>& corvecStationsInfo) = 0;
   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespWiFi::vPostSupportedFrequenciesInfo()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostSupportedFrequenciesInfo()
    * \brief   Called when SupportedFrequencies is updated by WBL client handler
    * \param   [IN] cormapSuppFrequencies: LMap if frequency and frequency details
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostSupportedFrequenciesInfo(const tMapSupportedFrequencies& /*cormapSuppFrequencies*/){};

};

#endif /* _SPI_TCLEEXTRESPWIFI_H_ */
