/*!
*******************************************************************************
* \file              spi_tclExtCmdWiFi.h
* \brief             WiFi Adapter Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    WiFi Adapter Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
11.01.2017 |  Unmukt Jain                 | Initial Version
\endverbatim
******************************************************************************/

#ifndef SPI_TCLEXTCMDWIFI_H_
#define SPI_TCLEXTCMDWIFI_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_tclExtCmdWiFiIntf.h"
#include "FunctionThreader.h"
#include "spi_WifiTypedefs.h"
#include "Lock.h"

class spi_tclWBLClientHandler;
class spi_tclExtCmdWiFi: public spi_tclExtCmdWiFiIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdWiFi::spi_tclExtCmdWiFi()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdWiFi()
   * \brief   Default constructor
   * \sa
   **************************************************************************/
	spi_tclExtCmdWiFi();

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdWiFi::~spi_tclExtCmdWiFi()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdWiFi()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdWiFi();

   /***************************************************************************
   * Application specific methods.
   ***************************************************************************/

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclExtCmdWiFi::vInitiateWirelessDiscovery()
    ***************************************************************************/
   /*!
    * \fn      vInitiateWirelessDiscovery()
    * \brief   vInitiateWirelessDiscovery Method. Invoked by HMI to start CPW session.
    * \param   enDevCategory: Device Category
    **************************************************************************/
   t_Void vInitiateWirelessDiscovery(tenDeviceCategory enDevCategory);

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdWiFi::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdWiFi::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclExtCmdWiFi::vSetWiFiLimitationMode()
    ***************************************************************************/
   /*!
    * \fn      vSetWiFiLimitationMode()
    * \brief   This is to enable/disable restrictions on WiFi feature set when a SPI session is active
    * \param   enDevCategory: Device Category
    * \param   bActivate: TRUE - Activate. FALSE -Deactivate
    **************************************************************************/
    t_Void vSetWiFiLimitationMode(tenDeviceCategory enDevCategory,t_Bool bActivate);

   /***************************************************************************
   ** FUNCTION:  tenWifiFrequency spi_tclExtCmdWiFi::enGetPreferredFrequency(...)
   ***************************************************************************/
   /*!
   * \fn      enGetPreferredFrequency()
   * \brief   Fetches the preferred frequency for the device category
   * \param   [IN]  enCategory: Device category
   * \param   [OUT] enFrequency: Preferred frequency for the device category
   * \retval  None
   **************************************************************************/
   tenWifiFrequency enGetPreferredFrequency(tenDeviceCategory enCategory);

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdWiFi::vOnConfigureWiFiResult(...)
   ***************************************************************************/
   /*!
   * \fn      vOnConfigureWiFiResult()
   * \brief   Interface to receive notification on status of vOnConfigureWiFiResult
   *          operation.
   *          Optional interface to be implemented.
   * \param   [IN] bResult: true or false
   * \retval  None
   **************************************************************************/
   t_Void vOnConfigureWiFiResult(t_Bool bResult);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdWiFi::vOnWiFiConfig(...)
   ***************************************************************************/
   /*!
   * \fn      vOnWiFiConfig()
   * \brief   Interface to receive trWiFiConfig structure.
   *          Optional interface to be implemented.
   * \param   [IN] rWifiAPConfig: structure of trWiFiConfig type
   * \param   [IN] corfvecStationsInfo: List of connected stations.
   * \retval  None
   **************************************************************************/
   t_Void vOnWiFiConfig(const trWiFiConfig &corfrWiFiConfig,const std::vector<trStationInfo>& corfvecStationInfo);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdWiFi::vOnSupportedFrequencyUpdate(...)
   ***************************************************************************/
   /*!
   * \fn      vOnSupportedFrequencyUpdate()
   * \brief   Interface to receive map of supported frequencies.
   * \param   [IN] corfmapSuppFrequencies: map of supported frequencies
   * \retval  None
   **************************************************************************/
   t_Void vOnSupportedFrequencyUpdate(const tMapSupportedFrequencies& corfmapSuppFrequencies);

   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdWiFi::vRegisterWiFiCallbacks()
   ***************************************************************************/
   /*!
   * \fn      vRegisterWiFiCallbacks()
   * \brief   Registers callbacks to WiFi client.
   * \retval  None
   **************************************************************************/
   t_Void vRegisterWiFiCallbacks();



   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdWiFi::vStorePreferredFrequency(tMap...)
   ***************************************************************************/
   /*!
   * \fn      vStorePreferredFrequency(tMapSupportedFrequencies&
   *           corfmapSuppFrequencies()
   * \brief   Populates the preferred frequencies for SPI technologies
   *          on Supported frequencies update.
   * \param   [IN]  corfmapSuppFrequencies: map of supported frequencies
   * \retval  None
   **************************************************************************/
   t_Void vStorePreferredFrequency(const tMapSupportedFrequencies& corfmapSuppFrequencies);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdWiFi::vPrintPreferredFrequencies()
   ***************************************************************************/
   /*!
   * \fn      vPrintPreferredFrequencies()
   * \brief   Helper fn to print m_mapPreferredFrequencies
   * \retval  None
   **************************************************************************/
   t_Void vPrintPreferredFrequencies();

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   spi_tclWBLClientHandler *m_poWBLClientHandler;

   shl::thread::FunctionThreader* m_poGMainLoopThread;
   
   std::map <tenDeviceCategory,tenWifiFrequency> m_mapPreferredFrequencies;

   Lock m_LockPreferredFrequencies;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // #define _SPI_TCLEXTCMDWIFI_H_


