/*!
*******************************************************************************
* \file              spi_tclExtCmdTelephone.cpp
* \brief             Telephone Adapter Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Telephone Adapter Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
10/04/2018 |  BDU6KOR(Dhanya)                | Initial Version
\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdTelephone.h"
#include "Trace.h"
#include "spi_tclTelephoneClient.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtTelephoneDispatcher.h"
#include "spi_tclExtCompMsgQInterface.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdTelephone.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdTelephone:: spi_tclExtCmdTelephone(t_Void)
*******************************************************************************/

spi_tclExtCmdTelephone::spi_tclExtCmdTelephone() : m_poTelClientHandler(NULL)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdTelephone::spi_tclExtCmdTelephone entered "));
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdTelephone::~spi_tclExtCmdTelephone(t_Void)
*******************************************************************************/
spi_tclExtCmdTelephone::~spi_tclExtCmdTelephone()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdTelephone::~spi_tclExtCmdTelephone entered "));
   m_poTelClientHandler = NULL;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdTelephone::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdTelephone::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdTelephone::bInitialize entered "));
    t_Bool bInit = false;
   spi_tclExtClientFactory *poExtClientFactory = spi_tclExtClientFactory::getInstance();
   if(NULL != poExtClientFactory)
   {
      m_poTelClientHandler = poExtClientFactory->poGetTelClientHandlerInstance();
      bInit = (NULL != m_poTelClientHandler);
   }

   if(NULL != m_poTelClientHandler)
   {
       m_poTelClientHandler->vRegisterForProperties();
   }

   //Register for TelePhoneCallbacks
   vRegisterTelCallbacks();
   ETG_TRACE_USR1(("[DESC]spi_tclExtCmdTelephone::bInitialize() status = %d",ETG_ENUM(BOOL,bInit)));
   return bInit;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdTelephone::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdTelephone::bUnInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdTelephone::bUnInitialize entered "));
   t_Bool bUninitSuccess = true;

   m_poTelClientHandler = NULL;

   ETG_TRACE_USR2(("[DESC]spi_tclExtCmdTelephone::bUnInitialize() status = %d ", ETG_ENUM(BOOL,bUninitSuccess)));
   return bUninitSuccess;
}


/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdTelephone::vTriggerAcceptCall(
           t_U16 u16CallInstance)
***************************************************************************/
t_Void spi_tclExtCmdTelephone::vTriggerAcceptCall(t_U16 u16CallInstance)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdTelephone::vTriggerAcceptCall entered "));
   if(NULL != m_poTelClientHandler)
   {
      m_poTelClientHandler->vTriggerAcceptCall(u16CallInstance);
   }
}
/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdTelephone::vTriggerHangUpCall(
t_U16 u16CallInstance)
***************************************************************************/
t_Void spi_tclExtCmdTelephone::vTriggerHangUpCall(t_U16 u16CallInstance)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdTelephone::vTriggerHangUpCall entered "));
   if(NULL != m_poTelClientHandler)
   {
      m_poTelClientHandler->vTriggerHangUpCall(u16CallInstance);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdTelephone::vTriggerRejectCall(
t_U16 u16CallInstance)
***************************************************************************/
t_Void  spi_tclExtCmdTelephone::vTriggerRejectCall(t_U16 u16CallInstance)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdTelephone::vTriggerRejectCall entered "));
   if(NULL != m_poTelClientHandler)
   {
      m_poTelClientHandler->vTriggerRejectCall(u16CallInstance);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdTelephone::vTriggerCancelCall(
t_U16 u16CallInstance)
***************************************************************************/
t_Void  spi_tclExtCmdTelephone::vTriggerCancelCall(t_U16 u16CallInstance)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdTelephone::vTriggerCancelCall entered "));
   if(NULL != m_poTelClientHandler)
   {
      m_poTelClientHandler->vTriggerCancelCall(u16CallInstance);
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclExtCmdTelephone::vActivateExtVR(t_String szBTAddress)
**************************************************************************/
t_Void spi_tclExtCmdTelephone::vActivateExtVR(t_String szBTAddress)
{
   ETG_TRACE_USR1(("spi_tclExtCmdTelephone::vActivateExtVR entered "));
   if(NULL != m_poTelClientHandler)
   {
      m_poTelClientHandler->vActivateExtVR(szBTAddress);
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclExtCmdTelephone::vDeActivateExtVR(t_String szBTAddress)
**************************************************************************/
t_Void spi_tclExtCmdTelephone::vDeActivateExtVR(t_String szBTAddress)
{
   ETG_TRACE_USR1(("spi_tclExtCmdTelephone::vDeActivateExtVR entered "));
   if(NULL != m_poTelClientHandler)
   {
      m_poTelClientHandler->vDeActivateExtVR(szBTAddress);
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclExtCmdTelephone::vDialExtended(t_String...)
**************************************************************************/
t_Void spi_tclExtCmdTelephone::vDialExtended(t_String szTelephoneNumber,
                        t_String szName,
                        tenEcnrSetting enEcnrSetting)
{
   ETG_TRACE_USR1(("spi_tclExtCmdTelephone::vDialExtended entered "));
   if(NULL != m_poTelClientHandler)
   {
      m_poTelClientHandler->vDialExtended(szTelephoneNumber,
                        szName,enEcnrSetting);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdTelephone::vRegisterTelCallbacks()
***************************************************************************/
t_Void spi_tclExtCmdTelephone::vRegisterTelCallbacks()
{
   /*lint -esym(40,fvOnTelephoneCallActivity)fvOnTelephoneCallActivity Undeclared identifier */
   /*lint -esym(40,_1)_1 Undeclared identifier */
   /*lint -esym(40,fvOnTelephoneCallStatus)fvOnTelephoneCallStatus Undeclared identifier */
   /*lint -esym(40,_1)_1 Undeclared identifier */
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdTelephone::vRegisterTelCallbacks() entered"));

   //! Register for Telephone events callbacks
   if (nullptr != m_poTelClientHandler)
   {
     trTelephoneCallbacks rTelephoneCallbacks;
     rTelephoneCallbacks.fvOnTelephoneCallActivity = std::bind(&spi_tclExtCmdTelephone::vOnTelephoneCallActivity,
                 this,
                 SPI_FUNC_PLACEHOLDERS_1);

     rTelephoneCallbacks.fvOnTelephoneCallStatus = std::bind(&spi_tclExtCmdTelephone::vOnTelephoneCallStatus,
                 this,
                 SPI_FUNC_PLACEHOLDERS_1);
     rTelephoneCallbacks.fvOnExtVRStateUpdate = std::bind(&spi_tclExtCmdTelephone::vOnExtVRStateUpdate,
                 this,
                 SPI_FUNC_PLACEHOLDERS_3);
     m_poTelClientHandler->vRegisterCallbacks(rTelephoneCallbacks);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdTelephone::vOnTelephoneCallActivity()
***************************************************************************/
t_Void spi_tclExtCmdTelephone::vOnTelephoneCallActivity(t_Bool bCallActive)
{
   ETG_TRACE_USR4(("spi_tclExtCmdTelephone::vOnTelephoneCallActivity: bIsCallActive-%d ",
         ETG_ENUM(BOOL, bCallActive)));

   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      TelephoneCallActivityMsg oTelephoneCallActivityMsg(bCallActive);
      poExtMsgQinterface->bWriteMsgToQ(&oTelephoneCallActivityMsg,sizeof(oTelephoneCallActivityMsg));
   }
   ETG_TRACE_USR1(("spi_tclExtCmdTelephone::vOnTelephoneCallActivity Left"));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdTelephone::vOnTelephoneCallStatus()
***************************************************************************/
t_Void spi_tclExtCmdTelephone::vOnTelephoneCallStatus(const std::vector<trTelCallStatusInfo>& rTelCallStatusInfo)
{
   ETG_TRACE_USR1(("spi_tclExtCmdTelephone::vOnTelephoneCallStatus entered"));

   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      TelephoneCallStatusMsg oTelephoneCallStatusMsg(rTelCallStatusInfo);
      poExtMsgQinterface->bWriteMsgToQ(&oTelephoneCallStatusMsg,sizeof(oTelephoneCallStatusMsg));
   }//if (NULL != poExtMsgQinterface)
   ETG_TRACE_USR1(("spi_tclExtCmdTelephone::vOnTelephoneCallStatus Left"));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdTelephone::vOnExtVRStateUpdate()
***************************************************************************/
t_Void spi_tclExtCmdTelephone::vOnExtVRStateUpdate(t_String szBTAddress,
                                                   tenExtVRState enExtVRState,
                                                   tenVRErrorCode enVRErrorCode)
{
   ETG_TRACE_USR1(("spi_tclExtCmdTelephone::vOnExtVRStateUpdate entered"));

   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      ExtVRStateUpdateMsg oExtVRStateUpdateMsg(szBTAddress,enExtVRState,enVRErrorCode);
      poExtMsgQinterface->bWriteMsgToQ(&oExtVRStateUpdateMsg,sizeof(oExtVRStateUpdateMsg));
   }//if (NULL != poExtMsgQinterface)
   ETG_TRACE_USR1(("spi_tclExtCmdTelephone::vOnExtVRStateUpdate Left"));
}
//lint -restore
