/*!
 *******************************************************************************
 * \file              spi_tclExtRespTelephone.h
 * \brief             External Interfaces Wrapper Response class for Telephone
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   External Interfaces Wrapper Response class for Telephone
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 10/04/2018 | BDU6KOR(Dhanya)       | Initial Version

 \endverbatim
 *********************************************/
#ifndef SPI_TCLEXTRESPTELEPHONE_H_
#define SPI_TCLEXTRESPTELEPHONE_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"

class spi_tclExtRespTelephone: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespTelephone::spi_tclExtRespTelephone()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespTelephone()
    * \brief   Constructor
    * \sa      spi_tclExtRespTelephone()
    **************************************************************************/
    spi_tclExtRespTelephone(): RespBase(e16EXT_TELEPHONE_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespTelephone::~spi_tclExtRespTelephone()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespTelephone()
    * \brief   Destructor
    * \sa      spi_tclExtRespTelephone()
    **************************************************************************/
   virtual ~spi_tclExtRespTelephone() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespTelephone::vPostTelephoneCallActivityMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostTelephoneCallActivityMsg()
    * \brief   Called when Telephone call Activity result is sent by Telephone Client Handler.
    * \sa      t_Bool: true when call is active else false.
    **************************************************************************/
   virtual t_Void vPostTelephoneCallActivityMsg(t_Bool /*bCallActive*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespTelephone::vPostTelephoneCallStatusMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostTelephoneCallStatusMsg()
    * \brief   Called when Telephone call status result is sent by Telephone Client Handler.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostTelephoneCallStatusMsg(const std::vector<trTelCallStatusInfo> & /*corfTelCallStatusInfoList*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespTelephone::vPostExtVRStateUpdateMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostExtVRStateUpdateMsg()
    * \brief   Called when External VR state update is sent by Telephone Client Handler.
    * \param   enExtVRState : External VR state
    * \param   szBTAddress : BT address
    * \param   enVRErrorCode : VR error codes
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostExtVRStateUpdateMsg(t_String /*szBTAddress*/,
                              tenExtVRState /*enExtVRState*/,
                              tenVRErrorCode /*enVRErrorCode*/){}

};

#endif /* SPI_TCLEXTRESPTELEPHONE_H_ */
