/*!
*******************************************************************************
* \file              spi_tclExtCmdTelephoneIntf.h
* \brief             Telephone Adapter Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class which provides interfaces to register/un-register
                with Telephone data provider.
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author            | Modifications
27.03.2018 |  BDU6KOR           | Initial Version

\endverbatim
******************************************************************************/
#ifndef SPI_TCLEXTCMDTELEPHONEINTF_H_
#define SPI_TCLEXTCMDTELEPHONEINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_BluetoothTypedefs.h"
/**
* \brief   Telephone Intf class
*/
class spi_tclExtCmdTelephoneIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdTelephoneIntf::~spi_tclExtCmdTelephoneIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdTelephoneIntf)
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdTelephoneIntf(){}

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdTelephoneIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdTelephoneIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize() = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephoneIntf::vTriggerAcceptCall(
              t_U16 u16CallInstance)
   ***************************************************************************/
   /*!
   * \fn      vTriggerAcceptCall(t_U16 u16CallInstance)
   * \brief   Method to triggger call accept.
   * \param   u16CallInstance: [IN]  Call Instance
   * \retval  NONE
   **************************************************************************/
   virtual t_Void vTriggerAcceptCall(t_U16 u16CallInstance) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephoneIntf::vTriggerHangUpCall(
   t_U16 u16CallInstance)
   ***************************************************************************/
   /*!
   * \fn      vTriggerHangUpCall(t_U16 u16CallInstance)
   * \brief   Method to triggger call hangup.
   * \param   u16CallInstance: [IN]  Call Instance
   * \retval  NONE
   **************************************************************************/
   virtual t_Void vTriggerHangUpCall(t_U16 u16CallInstance) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephoneIntf::vTriggerRejectCall(
   t_U16 u16CallInstance)
   ***************************************************************************/
   /*!
   * \fn      vTriggerRejectCall(t_U16 u16CallInstance)
   * \brief   Method to trigger call reject.
   * \param   u16CallInstance: [IN]  Call Instance
   * \retval  NONE
   **************************************************************************/
   virtual t_Void  vTriggerRejectCall(t_U16 u16CallInstance) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephoneIntf::vTriggerCancelCall(
   t_U16 u16CallInstance)
   ***************************************************************************/
   /*!
   * \fn      vTriggerCancelCall(t_U16 u16CallInstance)
   * \brief   Method to triggger call cancel.
   * \param   u16CallInstance: [IN]  Call Instance
   * \retval  NONE
   **************************************************************************/
   virtual t_Void  vTriggerCancelCall(t_U16 u16CallInstance) = 0;
   
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephoneIntf::vActivateExtVR(t_String szBTAddress)
   ***************************************************************************/
   /*!
   * \fn      vActivateExtVR(t_String szBTAddress)
   * \brief   Method to request activation of myspin VR.
   * \param   szBTAddress: [IN] BT address
   * \retval  NONE
   **************************************************************************/   
   virtual t_Void vActivateExtVR(t_String szBTAddress) = 0;
   
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephoneIntf::vDeActivateExtVR(t_String szBTAddress)
   ***************************************************************************/
   /*!
   * \fn      vDeActivateExtVR(t_String szBTAddress)
   * \brief   Method to request deactivation of myspin VR.
   * \param   szBTAddress: [IN] BT address
   * \retval  NONE
   **************************************************************************/
   virtual t_Void vDeActivateExtVR(t_String szBTAddress) = 0;
   
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdTelephoneIntf::vDialExtended(...
   ***************************************************************************/
   /*!
   * \fn      vDialExtended(t_String szTelephoneNumber,
   *                        t_String szName,
   *                        tenEcnrSetting enEcnrSetting)
   * \brief   Method to deactivate external VR
   * \param   szTelephoneNumber: [IN]Telephone number
   * \param   szName: [IN]Contact name
   * \param   enEcnrSetting: [IN]Ecnr setting   
   * \retval  NONE
   **************************************************************************/   
   virtual t_Void vDialExtended(t_String szTelephoneNumber,
                        t_String szName,
                        tenEcnrSetting enEcnrSetting) = 0;    
   
   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

};
#endif /* SPI_TCLEXTCMDTELEPHONEINTF_H_ */

