
/***********************************************************************/
/*!
 * \file  spi_tclExtSensorDataDispatcher.cpp
 * \brief Message Dispatcher for Sensor Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Sensor Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 09.01.2017  | Dhiraj Asopa           | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtSensorDataDispatcher.h"
#include "spi_tclExtRespSensorData.h"
//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtSensorDataDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleSensorMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  SensorMsgBase::SensorMsgBase
 ***************************************************************************/
SensorMsgBase::SensorMsgBase()
{
   ETG_TRACE_USR1(("[FUNC]SensorMsgBase::SensorMsgBase constructor entered\n"));
   vSetServiceID(e32MODULEID_EXTSENSOR);
}

//!class SensorDataMsg
/***************************************************************************
 ** FUNCTION:  SensorDataMsg::SensorDataMsg
 ***************************************************************************/
SensorDataMsg::SensorDataMsg()
{
   ETG_TRACE_USR1(("[FUNC]SensorDataMsg::SensorDataMsg constructor entered \n"));
}

/***************************************************************************
 ** FUNCTION:  SensorDataMsg::SensorDataMsg
 ***************************************************************************/
SensorDataMsg::SensorDataMsg(trSensorData rSensorData):
         m_rSensorData(rSensorData)
{
   vAllocateMsg();
}
/***************************************************************************
 ** FUNCTION:  SensorDataMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(SensorDataMsg, spi_tclExtSensorDataDispatcher);

/***************************************************************************
 ** FUNCTION:  SensorDataMsg::vAllocateMsg
 ***************************************************************************/
t_Void SensorDataMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]SensorDataMsg::vAllocateMsg entered\n"));
}

/***************************************************************************
 ** FUNCTION:  SensorDataMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void SensorDataMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]SensorDataMsg::vDeAllocateMsg entered\n"));
}

//!class AccSensorDataMsg
/***************************************************************************
 ** FUNCTION:  AccSensorDataMsg::AccSensorDataMsg
 ***************************************************************************/
AccSensorDataMsg::AccSensorDataMsg() : m_poVecrAccSensorData(NULL)
{
   ETG_TRACE_USR1(("[FUNC]AccSensorDataMsg::AccSensorDataMsg constructor entered \n"));
}

/***************************************************************************
 ** FUNCTION:  AccSensorDataMsg::AccSensorDataMsg
 ***************************************************************************/
AccSensorDataMsg::AccSensorDataMsg(const std::vector<trAccSensorData> &corfVecrAccSensorData)
{
   vAllocateMsg();
   if(NULL != m_poVecrAccSensorData)
   {
      (*m_poVecrAccSensorData) = corfVecrAccSensorData;
   }
}
/***************************************************************************
 ** FUNCTION:  AccSensorDataMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(AccSensorDataMsg, spi_tclExtSensorDataDispatcher);

/***************************************************************************
 ** FUNCTION:  AccSensorDataMsg::vAllocateMsg
 ***************************************************************************/
t_Void AccSensorDataMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AccSensorDataMsg::vAllocateMsg entered\n"));
   m_poVecrAccSensorData = new std::vector<trAccSensorData>;
}

/***************************************************************************
 ** FUNCTION:  AccSensorDataMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void AccSensorDataMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AccSensorDataMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_poVecrAccSensorData);
}

//!class GyroSensorDataMsg
/***************************************************************************
 ** FUNCTION:  GyroSensorDataMsg::GyroSensorDataMsg
 ***************************************************************************/
GyroSensorDataMsg::GyroSensorDataMsg(): m_poVecrGyroSensorData(NULL)
{
   ETG_TRACE_USR1(("[FUNC]GyroSensorDataMsg::GyroSensorDataMsg constructor entered \n"));
}

/***************************************************************************
 ** FUNCTION:  GyroSensorDataMsg::GyroSensorDataMsg
 ***************************************************************************/
GyroSensorDataMsg::GyroSensorDataMsg(const std::vector<trGyroSensorData> &corfVecrGyroSensorData)
{
   vAllocateMsg();
   if(NULL != m_poVecrGyroSensorData)
   {
      (*m_poVecrGyroSensorData) = corfVecrGyroSensorData;
   }
}
/***************************************************************************
 ** FUNCTION:  GyroSensorDataMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(GyroSensorDataMsg, spi_tclExtSensorDataDispatcher);

/***************************************************************************
 ** FUNCTION:  GyroSensorDataMsg::vAllocateMsg
 ***************************************************************************/
t_Void GyroSensorDataMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]GyroSensorDataMsg::vAllocateMsg entered\n"));
   m_poVecrGyroSensorData = new std::vector<trGyroSensorData>;
}

/***************************************************************************
 ** FUNCTION:  GyroSensorDataMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void GyroSensorDataMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]AccSensorDataMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_poVecrGyroSensorData);
}

//!class spi_tclExtSensorDataDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtSensorDataDispatcher::spi_tclExtSensorDataDispatcher
 ***************************************************************************/
spi_tclExtSensorDataDispatcher::spi_tclExtSensorDataDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtSensorDataDispatcher constructor entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtSensorDataDispatcher::~spi_tclExtSensorDataDispatcher
 ***************************************************************************/
spi_tclExtSensorDataDispatcher::~spi_tclExtSensorDataDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtSensorDataDispatcher::~spi_tclExtSensorDataDispatcher destructor entered "));
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtSensorDataDispatcher::vHandleSensorMsg()
 ***************************************************************************/
t_Void spi_tclExtSensorDataDispatcher::vHandleSensorMsg(SensorDataMsg *poSensorDataMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtSensorDataDispatcher::vHandleSensorMsg entered "));
   if (NULL != poSensorDataMsg)
     {
        CALL_REG_OBJECTS(spi_tclExtRespSensorData,
                 e16EXT_SENSOR_REGID,
                 vPostSensorDataResult(poSensorDataMsg->m_rSensorData));
     }
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtSensorDataDispatcher::vHandleSensorMsg()
 ***************************************************************************/
t_Void spi_tclExtSensorDataDispatcher::vHandleSensorMsg(AccSensorDataMsg *poAccSensorDataMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtSensorDataDispatcher::vHandleSensorMsg entered "));
   if (NULL != poAccSensorDataMsg && NULL != poAccSensorDataMsg->m_poVecrAccSensorData )
     {
        CALL_REG_OBJECTS(spi_tclExtRespSensorData,
                 e16EXT_SENSOR_REGID,
                 vPostAccSensorDataResult(*(poAccSensorDataMsg->m_poVecrAccSensorData)));
     }
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtSensorDataDispatcher::vHandleSensorMsg()
 ***************************************************************************/
t_Void spi_tclExtSensorDataDispatcher::vHandleSensorMsg(GyroSensorDataMsg *poGyroSensorDataMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtSensorDataDispatcher::vHandleSensorMsg entered "));
   if (NULL != poGyroSensorDataMsg && NULL != poGyroSensorDataMsg->m_poVecrGyroSensorData )
     {
        CALL_REG_OBJECTS(spi_tclExtRespSensorData,
                 e16EXT_SENSOR_REGID,
                 vPostGyroSensorDataResult(*(poGyroSensorDataMsg->m_poVecrGyroSensorData)));
     }
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
