/*!
*******************************************************************************
* \file              spi_tclExtCmdSensorData.cpp
* \brief             Sensor Data Adapter Implementation Class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Sensor Adapter Implementation Class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        |  Author                       | Modifications
29.09.2016  |  Dhiraj Asopa                 | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdSensorData.h"
#include "Trace.h"
#include "spi_tclSensorDataClientHandler.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtSensorDataDispatcher.h"
#include "spi_tclExtCompMsgQInterface.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdSensorData.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdSensorData:: spi_tclExtCmdSensorData(t_Void)
*******************************************************************************/

spi_tclExtCmdSensorData::spi_tclExtCmdSensorData()
{
   m_poSensorDataClientHandler=NULL;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdSensorData::
*             ~spi_tclExtCmdSensorData(t_Void)
*******************************************************************************/
spi_tclExtCmdSensorData::~spi_tclExtCmdSensorData()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdSensorData::~spi_tclExtCmdSensorData entered "));
}

/*******************************************************************************
* FUNCTION:t_Bool spi_tclExtCmdSensorData::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdSensorData::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdSensorData::bInitialize entered "));
   t_Bool bInit = true;
   spi_tclExtClientFactory *poExtClientFactory=spi_tclExtClientFactory::getInstance();
   if (NULL!=poExtClientFactory)
   {
      m_poSensorDataClientHandler = poExtClientFactory->poGetSensorDataClientHandlerInstance();
      if (NULL != m_poSensorDataClientHandler)
      {
         ETG_TRACE_USR1(("[DESC:]spi_tclExtCmdSensorData::bInitialize registering for callbacks"));
         trSensorDataCallbacks rSensorDataCallbacks;
         rSensorDataCallbacks.fvOnSensorData=std::bind(&spi_tclExtCmdSensorData::vOnSensorData,
                                                                this,
                                                                SPI_FUNC_PLACEHOLDERS_1);
         rSensorDataCallbacks.fvOnAccSensorData=std::bind(&spi_tclExtCmdSensorData::vOnAccSensorData,
                                                                this,
                                                                SPI_FUNC_PLACEHOLDERS_1);
         rSensorDataCallbacks.fvOnGyroSensorData=std::bind(&spi_tclExtCmdSensorData::vOnGyroSensorData,
                                                                this,
                                                                SPI_FUNC_PLACEHOLDERS_1);
         m_poSensorDataClientHandler->vRegisterCallbacks(rSensorDataCallbacks);
      }
   }
   return bInit;
}
/*******************************************************************************
* FUNCTION:t_Bool spi_tclExtCmdSensorData::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdSensorData::bUnInitialize()
{
   ETG_TRACE_USR1(("FUNC]spi_tclExtCmdSensorData::bUnInitialize entered "));
   m_poSensorDataClientHandler=NULL;
   return true;
}

/*******************************************************************************
* FUNCTION: t_Void spi_tclExtCmdSensorData::vStartSensorData(tenSensorDataType enDataType)
*******************************************************************************/
t_Void spi_tclExtCmdSensorData::vStartSensorData(tenSensorDataType enDataType)
{
   ETG_TRACE_USR1(("spi_tclExtCmdSensorData::vStartSensorDataentered "));
   if(NULL != m_poSensorDataClientHandler)
   {
      m_poSensorDataClientHandler->vRegisterForProperty(enDataType);
   }
}

/**********************************************************************************
* FUNCTION: t_Void spi_tclExtCmdSensorData::vStopSensorData(tenSensorDataType enDataType)
*******************************************************************************/
t_Void spi_tclExtCmdSensorData::vStopSensorData(tenSensorDataType enDataType)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdSensorData::vStopSensorData entered "));
   if(NULL != m_poSensorDataClientHandler)
   {
      m_poSensorDataClientHandler->vUnregisterForProperty(enDataType);
   }
}

/**********************************************************************************
* FUNCTION: t_Void spi_tclExtCmdSensorData::vOnSensorData(tenSensorDataType enDataType)
*******************************************************************************/
t_Void spi_tclExtCmdSensorData::vOnSensorData(trSensorData rSensorData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdSensorData::vOnSensorData entered "));
   SensorDataMsg oSensorDataMsg(rSensorData);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface  = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface )
   {
      poExtMsgQinterface ->bWriteMsgToQ(&oSensorDataMsg, sizeof(oSensorDataMsg));
   }//if (NULL != poMsgQinterface)
}

/***********************************************************************************************************
* FUNCTION: t_Void spi_tclExtCmdSensorData::vOnAccSensorData(const std::vector<trAccSensorData> rfvecrAccSensorData)
************************************************************************************************************/
t_Void spi_tclExtCmdSensorData::vOnAccSensorData(const std::vector<trAccSensorData> &rfvecrAccSensorData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdSensorData::vOnAccSensorData entered "));
   AccSensorDataMsg oAccSensorDataMsg(rfvecrAccSensorData);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface  = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface )
   {
      poExtMsgQinterface ->bWriteMsgToQ(&oAccSensorDataMsg, sizeof(oAccSensorDataMsg));
   }//if (NULL != poMsgQinterface)
}
/**************************************************************************************************************
* FUNCTION: t_Void spi_tclExtCmdSensorData::vOnGyroSensorData(const std::vector<trGyroSensorData> rfvecrGyroSensorData)
***************************************************************************************************************/
t_Void spi_tclExtCmdSensorData::vOnGyroSensorData(const std::vector<trGyroSensorData> &rfvecrGyroSensorData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdSensorData::vOnGyroSensorData entered "));
   GyroSensorDataMsg oGyroSensorDataMsg(rfvecrGyroSensorData);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface  = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface )
   {
      poExtMsgQinterface ->bWriteMsgToQ(&oGyroSensorDataMsg, sizeof(oGyroSensorDataMsg));
   }//if (NULL != poMsgQinterface)

}
//lint restore

