/*!
 *******************************************************************************
 * \file              spi_tclExtRespSensorData.h
 * \brief             External Interfaces Wrapper Response class for Sensor
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    External Interfaces Wrapper Response class for Sensor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 09.01.2017 | Dhiraj Asopa          | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _spi_tclExtRespSensorData_H_
#define _spi_tclExtRespSensorData_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"

class spi_tclExtRespSensorData: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespSensorData::spi_tclExtRespSensorData()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespSensorData()
    * \brief   Constructor
    * \sa      spi_tclExtRespSensorData()
    **************************************************************************/
   spi_tclExtRespSensorData(): RespBase(e16EXT_SENSOR_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespSensorData::~spi_tclExtRespSensorData()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespSensorData()
    * \brief   Destructor
    * \sa      spi_tclExtRespSensorData()
    **************************************************************************/
   virtual ~spi_tclExtRespSensorData() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespSensorData::vPostSensorDataResult()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostSensorDataResult()
    * \brief   Called when Sensor data result is sent by Sensor Client Handler.
    *          Mandatory interface to be implemented.
    * \param   [IN]trSensorData:structure to hold sensor data
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostSensorDataResult(trSensorData rSensorData) = 0;

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespSensorData::vPostAccSensorDataResult()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAccSensorDataResult()
    * \brief   Called when ACC Sensor data result is sent by Sensor Client Handler.
    *          Mandatory interface to be implemented.
    * \param   [IN]trAccSensorData:structure to hold ACC sensor data
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostAccSensorDataResult(const std::vector<trAccSensorData> &corfrAccSensorData ) = 0;

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespSensorData::vPostGyroSensorDataResult()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostGyroSensorDataResult()
    * \brief   Called when Gyro Sensor data result is sent by Sensor Client Handler.
    *          Mandatory interface to be implemented.
    * \param   [IN]trGyroSensorData:structure to hold Gyro sensor data
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostGyroSensorDataResult(const std::vector<trGyroSensorData> &corfrGyroSensorData ) = 0;

};

#endif /* _spi_tclExtRespSensorData_H_ */
