/*!
*******************************************************************************
* \file              spi_tclExtCmdSensorDataIntf.h
* \brief             sensor Adapter Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    sensor Adapter Interface class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
29.09.2016 |  Dhiraj Asopa                | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SPI_TCL_SENSOR_ADAPTER_INTERFACE_H_
#define _SPI_TCL_SENSOR_ADAPTER_INTERFACE_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
/**
* \brief   SENSOR class
*/
class spi_tclExtCmdSensorDataIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdSensorDataIntf::~spi_tclExtCmdSensorDataIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdSensorDataIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdSensorDataIntf(){}
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdSensorDataIntf::vStartSensorData(tenSensorDataType enDataType,
            const trSensorDataCallbacks& rfcorSensorDataCb)
   ***************************************************************************/
   /*!
   * \fn      vStartSensorData()
   * \brief   This function is called to start sensor
   * \param   enDataType: [IN] Identifies type of data to be registered
   * \sa
   **************************************************************************/
   virtual t_Void vStartSensorData(tenSensorDataType enDataType)=0;
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdSensorDataIntf::vStopSensorData(tenSensorDataType enDataType)
   ***************************************************************************/
   /*!
   * \fn      vStopSensorData()
   * \brief   This function is called for stop sensor
   * \param   enDataType: [IN] Identifies type of data to be registered
   * \sa
   **************************************************************************/
   virtual t_Void vStopSensorData(tenSensorDataType enDataType)=0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdSensorDataIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize()=0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdSensorDataIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize()=0;

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // spi_tclExtCmdSensorDataIntf
