/*!
*******************************************************************************
* \file              spi_tclExtCmdSensorData.h
* \brief             Sensor Adapter Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Sensor Adapter Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
29.09.2016 |  Dhiraj Asopa                | Initial Version
\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDSENSORDATA_H_
#define _SPI_TCLEXTCMDSENSORDATA_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_tclExtCmdSensorDataIntf.h"

class spi_tclSensorDataClientHandler;
class spi_tclExtCmdSensorData: public spi_tclExtCmdSensorDataIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdSensorData::spi_tclExtCmdSensorData()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdSensorData()
   * \brief   Default constructor
   * \sa
   **************************************************************************/

   spi_tclExtCmdSensorData();
   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdSensorData::~spi_tclExtCmdSensorData()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdSensorData()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdSensorData();

   /***************************************************************************
   * Application specific methods.
   ***************************************************************************/
   /***************************************************************************
      ** FUNCTION:  t_Void spi_tclExtCmdSensorData::vStartSensorData()
      ***************************************************************************/
      /*!
      * \fn      vStopSensorData(tenSensorDataType enDataType,const trSensorDataCallbacks& rfcorSensorDataCb)
      * \brief   This function is called for start sensor
      * \param   enDataType: [IN] Identifies type of data to be registered
      * \sa
      **************************************************************************/
   /**************************************************************************/
    t_Void vStartSensorData(tenSensorDataType enDataType);
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdSensorData::vStopSensorData()
   ***************************************************************************/
   /*!
   * \fn      vStopSensorData(tenSensorDataType enDataType,const trSensorDataCallbacks& rfcorSensorDataCb)
   * \brief   This function is called for stop sensor
   * \param   enDataType: [IN] Identifies type of data to be registered
   *             to be called when subscribed data is received by client handler.
   * \sa
   **************************************************************************/
   t_Void vStopSensorData(tenSensorDataType enDataType);

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdSensorData::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdSensorData::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdSensorData::vOnSensorData()
    ***************************************************************************/
   /*!
    * \fn      vOnSensorData()
    * \brief   Method to get sensor Data
    * \[PARAM] trSensorData:Structure for holding Sensor data
    * \sa      bInitialize()
    **************************************************************************/
   t_Void vOnSensorData (trSensorData rSensorData);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdSensorData::vOnAccSensorData()
    ***************************************************************************/
   /*!
    * \fn      vOnAccSensorData()
    * \brief   Method to get Acceleration sensor Data
    * \[PARAM] const vector<trAccSensorData>:Vector of Structure for holding Acceleration sensor data
    * \sa      bInitialize()
    **************************************************************************/

   t_Void vOnAccSensorData(const std::vector<trAccSensorData> &rfvecrAccSensorData);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdSensorData::vOnGyroSensorData()
    ***************************************************************************/
   /*!
    * \fn      vOnGyroSensorData()
    * \brief   Method to get GyroSensor Data
    * \[PARAM] const vector<trGyroSensorData>:vector of Structure for holding GyroSensor data
    * \sa      bInitialize()
    **************************************************************************/

   t_Void vOnGyroSensorData(const std::vector<trGyroSensorData> &rfvecrGyroSensorData);
   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   spi_tclSensorDataClientHandler *m_poSensorDataClientHandler;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // _SPI_TCLEXTCMDSENSORDATA_H_


