/***********************************************************************/
/*!
 * \file  spi_tclExtRoleSwitchDispatcher.h
 * \brief Message Dispatcher for Role Switch Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Role Switch Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 20.01.2017  | Dhiraj Asopa          | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLEXTROLESWITCHDISPATCHER_H_
#define _SPI_TCLEXTROLESWITCHDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"
#include "spi_ConnMngrTypeDefines.h"

/**************Forward Declarations******************************************/
class spi_tclExtRoleSwitchDispatcher;

/****************************************************************************/
/*!
 * \class RoleSwitchCompleteMsgBase
 * \brief Base Message type for all Role Switch messages
 ****************************************************************************/
class RoleSwitchCompleteMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  RoleSwitchCompleteMsgBase::RoleSwitchCompleteMsgBase
    ***************************************************************************/
   /*!
    * \fn      RoleSwitchCompleteMsgBase()
    * \brief   Default constructor
    **************************************************************************/
   RoleSwitchCompleteMsgBase();

   /***************************************************************************
    ** FUNCTION:  RoleSwitchCompleteMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtRoleSwitchDispatcher* poRoleSwitchDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poRoleSwitchDispatcher: pointer to Message dispatcher for Role Switch
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtRoleSwitchDispatcher *poRoleSwitchDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  RoleSwitchCompleteMsgBase::~RoleSwitchCompleteMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~RoleSwitchCompleteMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~RoleSwitchCompleteMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class RoleSwitchCompleteMsg
 * \brief Device Connected msg
 ****************************************************************************/
class RoleSwitchCompleteMsg: public RoleSwitchCompleteMsgBase
{
   public:

      t_U32  m_cou32DeviceHandle;
      t_Bool m_bSwitchStatus;

   /***************************************************************************
   ** FUNCTION:  RoleSwitchCompleteMsg::RoleSwitchCompleteMsg
   ***************************************************************************/
  /*!
   * \fn      RoleSwitchCompleteMsg(const t_U32 cou32DeviceHandle, t_Bool  bSwitchStatus)
   * \brief   Parameterized constructor
   **************************************************************************/
   RoleSwitchCompleteMsg(const t_U32 cou32DeviceHandle, t_Bool  bSwitchStatus);

   /***************************************************************************
    ** FUNCTION:  RoleSwitchCompleteMsg::~RoleSwitchCompleteMsg
    ***************************************************************************/
   /*!
    * \fn      ~RoleSwitchCompleteMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~RoleSwitchCompleteMsg(){}

   /***************************************************************************
    ** FUNCTION:  RoleSwitchCompleteMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poRoleSwitchDispatcher : pointer to Message dispatcher for Role Switch
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtRoleSwitchDispatcher *poRoleSwitchDispatcher);

   /***************************************************************************
    ** FUNCTION:  RoleSwitchCompleteMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  RoleSwitchCompleteMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class spi_tclExtRoleSwitchDispatcher
 * \brief Message Dispatcher for Role Switch  Messages
 ****************************************************************************/
class spi_tclExtRoleSwitchDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtRoleSwitchDispatcher::
    **                spi_tclExtRoleSwitchDispatcher()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRoleSwitchDispatcher()
    * \brief   Default constructor
    **************************************************************************/
   spi_tclExtRoleSwitchDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtRoleSwitchDispatcher::
    **               ~spi_tclExtRoleSwitchDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtRoleSwitchDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtRoleSwitchDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtRoleSwitchDispatcher::
    **                vHandleRoleSwitchMsg(RoleSwitchCompleteMsg *poRoleSwitchCompleteMsg)
    ***************************************************************************/
   /*!
    * \fn      vHandleRoleSwitchMsg(RoleSwitchCompleteMsg *poRoleSwitchCompleteMsg)
    * \brief   Handles Messages of RoleSwitchCompleteMsg type
    * \param   poRoleSwitchCompleteMsg : pointer to RoleSwitchCompleteMsg.
    **************************************************************************/
   t_Void vHandleRoleSwitchCompleteMsg(RoleSwitchCompleteMsg *poRoleSwitchCompleteMsg)const;

};

#endif /* _SPI_TCLEXTROLESWITCHDISPATCHER_H_ */
