/*!
 *******************************************************************************
 * \file              spi_tclExtRespRoleSwitch.h
 * \brief             External Interfaces Wrapper Response class for Role Switch
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   External Interfaces Wrapper Response class for Role Switch
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 20.01.2017 | Dhiraj Asopa          | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLEEXTRESPRoleSwitch_H_
#define _SPI_TCLEEXTRESPRoleSwitch_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"

class spi_tclExtRespRoleSwitch: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespRoleSwitch::spi_tclExtRespRoleSwitch()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespRoleSwitch()
    * \brief   Constructor
    * \sa      spi_tclExtRespRoleSwitch()
    **************************************************************************/
   spi_tclExtRespRoleSwitch(): RespBase(e16EXT_ROLESWITCH_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespRoleSwitch::~spi_tclExtRespRoleSwitch()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespRoleSwitch()
    * \brief   Destructor
    * \sa      spi_tclExtRespRoleSwitch()
    **************************************************************************/
   virtual ~spi_tclExtRespRoleSwitch() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespRoleSwitch::vPostRoleSwitchCompleteMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostRoleSwitchCompleteMsg()
    * \brief   Called when role switch completes
    * \param   cou32DeviceHandle:Device handle
    * \param   bSwitchStatus: Role Switch status
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostRoleSwitchCompleteMsg(const t_U32 cou32DeviceHandle, t_Bool  bSwitchStatus) = 0;
};

#endif /* _SPI_TCLEEXTRESPRoleSwitch_H_ */
