/*!
*******************************************************************************
* \file              spi_tclExtCmdRoleSwitch.h
* \brief             Role Switch Adapter Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Role Switch Adapter Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
20.01.2017 |  Dhiraj Asopa                | Initial Version
\endverbatim
******************************************************************************/

#ifndef SPI_TCLEXTCMDROLESWITCH_H_
#define SPI_TCLEXTCMDROLESWITCH_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_tclExtCmdRoleSwitchIntf.h"
#include "spi_ConnMngrTypeDefines.h"
class spi_tclMPlayClientHandler;

class spi_tclExtCmdRoleSwitch: public spi_tclExtCmdRoleSwitchIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdRoleSwitch::spi_tclExtCmdRoleSwitch()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdRoleSwitch()
   * \brief   Default constructor
   * \sa
   **************************************************************************/
   spi_tclExtCmdRoleSwitch();

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdRoleSwitch::
   **                       ~spi_tclExtCmdRoleSwitch()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdRoleSwitch()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdRoleSwitch();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdRoleSwitch::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdRoleSwitch::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdRoleSwitch::bRoleSwitchRequest()
    ***************************************************************************/
   /*!
    * \fn      bRoleSwitchRequest()
    * \brief   Function to activate the dipo device
    * \sa      bRoleSwitchRequest()
    **************************************************************************/

   t_Bool bRoleSwitchRequest(t_U32 u32DeviceTag, tenDeviceConnectionReq enDevConnReq, trEAPAppInfo rEAPAppInfo, tenDeviceCategory endDeviceCat = e8DEV_TYPE_DIPO);

   /***************************************************************************

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdRoleSwitch::vOnRoleSwitchCompleteCb(...)
   ***************************************************************************/
   /*!
   * \fn      vOnRoleSwitchCompleteCb()
   * \brief   Called when role switch completes.
   * \param   cou32DeviceHandle: Device handle
   * \param   bSwitchStatus    : Role Switch status
   * \retval  None
   **************************************************************************/
   t_Void vOnRoleSwitchCompleteCb(const t_U32 cou32DeviceHandle, t_Bool  bSwitchStatus);


   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdRoleSwitch::vRegisterRoleSwitchCallbacks()
   ***************************************************************************/
   /*!
   * \fn      vRegisterRoleSwitchCallbacks()
   * \brief   Registers Role Switch callbacks to MediaPlayer client.
   * \retval  None
   **************************************************************************/
   t_Void vRegisterRoleSwitchCallbacks();

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   //! MediaPlayer client handler pointer
   spi_tclMPlayClientHandler *m_poMPlayClientHandler;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // #define SPI_TCLEXTCMDRoleSwitch_H_


