/*!
*******************************************************************************
* \file              spi_tclExtCmdPositionData.cpp
* \brief             Position Data Adapter Implementation Class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Pos Data Adapter Implementation Class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        |  Author                       | Modifications
9.01.2017  |  Dhiraj Asopa                 | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdPositionData.h"
#include "spi_tclExtPositionDataDispatcher.h"
#include "spi_tclExtCompMsgQInterface.h"
#include "Trace.h"
#include "spi_tclSensorPVDataClientHandler.h"
#include "spi_tclExtClientFactory.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdPositionData.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdPositionData:: spi_tclExtCmdPositionData(t_Void)
*******************************************************************************/
spi_tclExtCmdPositionData::spi_tclExtCmdPositionData()
{
   ETG_TRACE_USR1(("FUNC]spi_tclExtCmdPositionData::spi_tclExtCmdPositionData constructor entered "));
   m_poPosDataClientHandler=NULL;
}

/*******************************************************************************
* FUNCTION:t_Bool spi_tclExtCmdPositionData::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdPositionData::bInitialize()
{
   ETG_TRACE_USR1(("FUNC]spi_tclExtCmdPositionData::bInitialize entered "));
   t_Bool bInit = true;
   spi_tclExtClientFactory *poExtClientFactory=spi_tclExtClientFactory::getInstance();
   if (NULL!=poExtClientFactory)
   {
      m_poPosDataClientHandler = poExtClientFactory->poGetPosDataClientHandlerInstance();
      if (NULL!=m_poPosDataClientHandler)
      {
         trLocationDataCallbacks rLocationDataCallbacks;
         rLocationDataCallbacks.fvOnGpsData=std::bind(&spi_tclExtCmdPositionData::vOnDeadReckoningData,
                                                      this,
                                                      SPI_FUNC_PLACEHOLDERS_1);
         m_poPosDataClientHandler->vRegisterCallbacks(rLocationDataCallbacks);
      }
   }
   return bInit;
}
/*******************************************************************************
* FUNCTION:t_Bool spi_tclExtCmdPositionData::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdPositionData::bUnInitialize()
{
   ETG_TRACE_USR1(("FUNC]spi_tclExtCmdPositionData::bUnInitialize entered "));
   m_poPosDataClientHandler=NULL;
   return true;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdPositionData::
*             ~spi_tclExtCmdPositionData(t_Void)
*******************************************************************************/
spi_tclExtCmdPositionData::~spi_tclExtCmdPositionData()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdPositionData::~spi_tclExtCmdPositionData destructor entered "));
}
/*******************************************************************************
* FUNCTION: t_Void spi_tclExtCmdPositionData::vStartLocData(tenSensorDataType enDataType)
*******************************************************************************/
t_Void spi_tclExtCmdPositionData::vStartLocData(tenSensorDataType enDataType)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdPositionData::vStartLocData entered "));
   if(NULL!=m_poPosDataClientHandler)
   {
      m_poPosDataClientHandler->vRegisterForProperties(enDataType);
   }
}
/*******************************************************************************
* FUNCTION: t_Void spi_tclExtCmdPositionData::vStopLocData(tenSensorDataType enDataType)
*******************************************************************************/
t_Void spi_tclExtCmdPositionData::vStopLocData(tenSensorDataType enDataType)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdPositionData::vStopLocData entered "));
   if(NULL!=m_poPosDataClientHandler)
   {
     m_poPosDataClientHandler->vUnregisterForProperties(enDataType);
   }
}
/**********************************************************************************************************
* FUNCTION: t_Void spi_tclExtCmdPositionData::vOnDeadReckoningData(trDeadReckoningData rDeadReckoningData)
**********************************************************************************************************/
t_Void spi_tclExtCmdPositionData::vOnDeadReckoningData(trDeadReckoningData rDeadReckoningData)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdPositionData::vOnDeadReckoningData entered"));
   PositionDataMsg oPositionDataMsg(rDeadReckoningData);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface  = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface )
   {
      poExtMsgQinterface ->bWriteMsgToQ(&oPositionDataMsg, sizeof(oPositionDataMsg));
   }//if (NULL != poMsgQinterface)
}
//lint restore
