/*!
 *******************************************************************************
 * \file              spi_tclExtRespPositionData.h
 * \brief             External Interfaces Wrapper Response class for Position
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    External Interfaces Wrapper Response class for Position
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 09.01.2017 | Dhiraj Asopa          | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _spi_tclExtRespPositionData_H_
#define _spi_tclExtRespPositionData_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"

class spi_tclExtRespPositionData: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespPositionData::spi_tclExtRespPositionData()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespPositionData()
    * \brief   Constructor
    * \sa      spi_tclExtRespPositionData()
    **************************************************************************/
   spi_tclExtRespPositionData(): RespBase(e16EXT_POSITION_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespPositionData::~spi_tclExtRespPositionData()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespPositionData()
    * \brief   Destructor
    * \sa      spi_tclExtRespPositionData()
    **************************************************************************/
   virtual ~spi_tclExtRespPositionData() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespPositionData::vPostPositionDataResult()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostPositionDataResult()
    * \brief   Called when position data result is sent by Sensorpv Client Handler.
    *          Mandatory interface to be implemented.
    * \param   [IN]trDeadReckoningData:Structure to hold dead reckoning data.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostPositionDataResult(trDeadReckoningData rDeadReckoningData) = 0;


};

#endif /* _spi_tclExtRespPositionData_H_ */
