/***********************************************************************/
/*!
 * \file  spi_tclExtPositionDataDispatcher.h
 * \brief Message Dispatcher for Position Messages.Implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Position Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 09.01.2017  |Dhiraj Asopa           | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLEXTPOSITIONDATADISPATCHER_H_
#define _SPI_TCLEXTPOSITIONDATADISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"

/**************Forward Declarations******************************************/
class spi_tclExtPositionDataDispatcher;

/****************************************************************************/
/*!
 * \class PositionMsgBase
 * \brief Base Message type for all Position messages
 ****************************************************************************/
class PositionMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  PositionMsgBase::PositionMsgBase
    ***************************************************************************/
   /*!
    * \fn      PositionMsgBase()
    * \brief   Default constructor
    **************************************************************************/
   PositionMsgBase();

   /***************************************************************************
    ** FUNCTION:  PositionMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtPositionDataDispatcher* poPositionDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poPositionDispatcher : pointer to Message dispatcher for Position
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtPositionDataDispatcher* poPositionDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  PositionMsgBase::~PositionMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~PositionMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~PositionMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class PositionDataMsg
 * \brief Configure Position Result msg
 ****************************************************************************/
class PositionDataMsg: public PositionMsgBase
{
   public:
      trDeadReckoningData m_rDeadReckoningData;
   /***************************************************************************
    ** FUNCTION:  PositionDataMsg::PositionDataMsg
    ***************************************************************************/
   /*!
    * \fn      PositionDataMsg()
    * \brief   Default constructor
    **************************************************************************/
   PositionDataMsg();
   /***************************************************************************
    ** FUNCTION:  PositionDataMsg::PositionDataMsg
    ***************************************************************************/
   /*!
    * \fn      PositionDataMsg(trDeadReckoningData rDeadReckoningData)
    * \brief   Paramaterized constructor
    **************************************************************************/
   PositionDataMsg(trDeadReckoningData rDeadReckoningData);
   /***************************************************************************
    ** FUNCTION:  PositionDataMsg::~PositionDataMsg
    ***************************************************************************/
   /*!
    * \fn      ~PositionDataMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~PositionDataMsg();

   /***************************************************************************
    ** FUNCTION:  PositionDataMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtPositionDataDispatcher* poPositionDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poPositionDispatcher : pointer to Message dispatcher for Position
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtPositionDataDispatcher* poPositionDispatcher);

   /***************************************************************************
    ** FUNCTION:  PositionDataMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  PositionDataMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclExtPositionDataDispatcher
 * \brief Message Dispatcher for Sensor Messages
 ****************************************************************************/
class spi_tclExtPositionDataDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtPositionDataDispatcher::spi_tclExtPositionDataDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtPositionDataDispatcher()
    * \brief   Default constructor
    **************************************************************************/
      spi_tclExtPositionDataDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtPositionDataDispatcher::~spi_tclExtPositionDataDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtPositionDataDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtPositionDataDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtPositionDataDispatcher::vHandlePositionMsg(PositionDataMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandlePositionMsg(PositionDataMsg* poPosDataMsg)
    * \brief   Handles Messages of PositionDataMsg type
    * \param   poPosDataMsg : pointer to poPosDataMsg.
    **************************************************************************/
   t_Void vHandlePositionMsg(PositionDataMsg* poPosDataMsg) const;

};
#endif /* _SPI_TCLEXTPOSITIONDATADISPATCHER_H_ */
