
/***********************************************************************/
/*!
 * \file  spi_tclExtNavDataDispatcher.cpp
 * \brief Message Dispatcher for NavData Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for NavData Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 30.01.2017  | Dhiraj Asopa           | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtNavDataDispatcher.h"
#include "spi_tclExtRespNavData.h"
//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtNavDataDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleNavDataMsg(this);                \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  NavDataMsgBase::NavDataMsgBase
 ***************************************************************************/
NavDataMsgBase::NavDataMsgBase()
{
   ETG_TRACE_USR1(("[FUNC]NavDataMsgBase::NavDataMsgBase constructor entered"));
   vSetServiceID(e32MODULEID_NAVDATA);
}

//!class DipoLocationInfoMsg
/***************************************************************************
 ** FUNCTION:  DipoLocationInfoMsg::DipoLocationInfoMsg
 ***************************************************************************/
DipoLocationInfoMsg::DipoLocationInfoMsg(t_Bool bStartLocData,const std::vector<tenNmeaSentenceType> &cocorfVecrNmeaSentenceType,t_U8 u8RequestedBy):m_bStartLocData(bStartLocData),m_u8RequestedBy(u8RequestedBy)
{
   vAllocateMsg();
   if(NULL != m_poVecrNmeaSentenceType)
   {
      (*m_poVecrNmeaSentenceType) = cocorfVecrNmeaSentenceType;
   }
}
/***************************************************************************
 ** FUNCTION:  DipoLocationInfoMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DipoLocationInfoMsg, spi_tclExtNavDataDispatcher);

/***************************************************************************
 ** FUNCTION:  DipoLocationInfoMsg::vAllocateMsg
 ***************************************************************************/
t_Void DipoLocationInfoMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DipoLocationInfoMsg::vAllocateMsg entered"));
   m_poVecrNmeaSentenceType = new std::vector<tenNmeaSentenceType>;
}

/***************************************************************************
 ** FUNCTION:  DipoLocationInfoMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void DipoLocationInfoMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DipoLocationInfoMsg::vDeAllocateMsg entered"));
   RELEASE_MEM(m_poVecrNmeaSentenceType);
}

//!class DipoGPRMCDataStatusValuesInfoMsg
/***************************************************************************
 ** FUNCTION:  DipoGPRMCDataStatusValuesInfoMsg::DipoGPRMCDataStatusValuesInfoMsg
 ***************************************************************************/
DipoGPRMCDataStatusValuesInfoMsg::DipoGPRMCDataStatusValuesInfoMsg(t_U32 u32DeviceId,t_U8 u8GPRMCDataStatusValues):m_u32DeviceId(u32DeviceId),m_u8GPRMCDataStatusValues(u8GPRMCDataStatusValues)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  DipoGPRMCDataStatusValuesInfoMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DipoGPRMCDataStatusValuesInfoMsg, spi_tclExtNavDataDispatcher);

/***************************************************************************
 ** FUNCTION:  DipoGPRMCDataStatusValuesInfoMsg::vAllocateMsg
 ***************************************************************************/
t_Void DipoGPRMCDataStatusValuesInfoMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DipoGPRMCDataStatusValuesInfoMsg::vAllocateMsg entered"));
}

/***************************************************************************
 ** FUNCTION:  DipoGPRMCDataStatusValuesInfoMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void DipoGPRMCDataStatusValuesInfoMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DipoGPRMCDataStatusValuesInfoMsg::vDeAllocateMsg entered"));
}

//!class DiPORouteGuidanceUpdateMsg
/***************************************************************************
 ** FUNCTION:  DiPORouteGuidanceUpdateMsg::DiPORouteGuidanceUpdateMsg
 ***************************************************************************/
DiPORouteGuidanceUpdateMsg::DiPORouteGuidanceUpdateMsg(const trDiPORouteGuidanceUpdate &corfrDiPORouteGuidanceUpdate)
{
   vAllocateMsg();
   if(NULL != m_porDiPORouteGuidanceUpdate)
   {
      (*m_porDiPORouteGuidanceUpdate) = corfrDiPORouteGuidanceUpdate;
   }
}
/***************************************************************************
 ** FUNCTION:  DiPORouteGuidanceUpdateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DiPORouteGuidanceUpdateMsg, spi_tclExtNavDataDispatcher);

/***************************************************************************
 ** FUNCTION:  DiPORouteGuidanceUpdateMsg::vAllocateMsg
 ***************************************************************************/
t_Void DiPORouteGuidanceUpdateMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DiPORouteGuidanceUpdateMsg::vAllocateMsg entered"));
   m_porDiPORouteGuidanceUpdate = new(std::nothrow)trDiPORouteGuidanceUpdate();
   SPI_NORMAL_ASSERT(NULL == m_porDiPORouteGuidanceUpdate)
}

/***************************************************************************
 ** FUNCTION:  DiPORouteGuidanceUpdateMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void DiPORouteGuidanceUpdateMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DiPORouteGuidanceUpdateMsg::vDeAllocateMsg entered"));
   RELEASE_MEM(m_porDiPORouteGuidanceUpdate);
}

//!class DiPORouteGuidanceManeuverUpdateMsg
/***************************************************************************
 ** FUNCTION:  DiPORouteGuidanceManeuverUpdateMsg::DiPORouteGuidanceManeuverUpdateMsg
 ***************************************************************************/
DiPORouteGuidanceManeuverUpdateMsg::DiPORouteGuidanceManeuverUpdateMsg(const
                           trDiPORouteGuidanceManeuverUpdate &corfrDiPORouteGuidanceManeuverUpdate)
{
   vAllocateMsg();
   if(NULL != m_porDiPORouteGuidanceManeuverUpdate)
   {
      (*m_porDiPORouteGuidanceManeuverUpdate) = corfrDiPORouteGuidanceManeuverUpdate;
   }
}
/***************************************************************************
 ** FUNCTION:  DiPORouteGuidanceManeuverUpdateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DiPORouteGuidanceManeuverUpdateMsg, spi_tclExtNavDataDispatcher);

/***************************************************************************
 ** FUNCTION:  DiPORouteGuidanceManeuverUpdateMsg::vAllocateMsg
 ***************************************************************************/
t_Void DiPORouteGuidanceManeuverUpdateMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DiPORouteGuidanceManeuverUpdateMsg::vAllocateMsg entered"));
   m_porDiPORouteGuidanceManeuverUpdate = new(std::nothrow)trDiPORouteGuidanceManeuverUpdate();
   SPI_NORMAL_ASSERT(NULL == m_porDiPORouteGuidanceManeuverUpdate)
}

/***************************************************************************
 ** FUNCTION:  DiPORouteGuidanceManeuverUpdateMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void DiPORouteGuidanceManeuverUpdateMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DiPORouteGuidanceManeuverUpdateMsg::vDeAllocateMsg entered"));
   RELEASE_MEM(m_porDiPORouteGuidanceManeuverUpdate);
}

//!class spi_tclExtNavDataDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtNavDataDispatcher::spi_tclExtNavDataDispatcher
 ***************************************************************************/
spi_tclExtNavDataDispatcher::spi_tclExtNavDataDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNavDataDispatcher constructor entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtNavDataDispatcher::~spi_tclExtNavDataDispatcher
 ***************************************************************************/
spi_tclExtNavDataDispatcher::~spi_tclExtNavDataDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNavDataDispatcher::~spi_tclExtNavDataDispatcher destructor entered "));
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtNavDataDispatcher::vHandleNavDataMsg()
 ***************************************************************************/
t_Void spi_tclExtNavDataDispatcher::vHandleNavDataMsg(DipoLocationInfoMsg *poNavDataMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNavDataDispatcher::vHandleNavDataMsg entered "));
   if (NULL != poNavDataMsg && NULL != poNavDataMsg->m_poVecrNmeaSentenceType)
     {
        CALL_REG_OBJECTS(spi_tclExtRespNavData,
                 e16EXT_NAVDATA_REGID,
                 vPostNavDataResult(poNavDataMsg->m_bStartLocData,*(poNavDataMsg->m_poVecrNmeaSentenceType),poNavDataMsg->m_u8RequestedBy));
     }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtNavDataDispatcher::vHandleNavDataMsg()
 ***************************************************************************/
t_Void spi_tclExtNavDataDispatcher::vHandleNavDataMsg(DipoGPRMCDataStatusValuesInfoMsg *poNavDataMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNavDataDispatcher::vHandleNavDataMsg(DipoGPRMCDataStatusValuesInfoMsg) entered "));
   if (NULL != poNavDataMsg)
     {
        CALL_REG_OBJECTS(spi_tclExtRespNavData,
                 e16EXT_NAVDATA_REGID,
                 vPostGPRMCDataStatusValues(poNavDataMsg->m_u32DeviceId,poNavDataMsg->m_u8GPRMCDataStatusValues));
     }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtNavDataDispatcher::vHandleNavDataMsg()
 ***************************************************************************/
t_Void spi_tclExtNavDataDispatcher::vHandleNavDataMsg(DiPORouteGuidanceUpdateMsg* poDiPORouteGuidanceUpdateMsg) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNavDataDispatcher::vHandleNavDataMsg entered "));
   if (NULL != poDiPORouteGuidanceUpdateMsg && NULL != poDiPORouteGuidanceUpdateMsg->m_porDiPORouteGuidanceUpdate)
     {
        CALL_REG_OBJECTS(spi_tclExtRespNavData,
                 e16EXT_NAVDATA_REGID,
                 vPostDiPORouteGuidanceUpdateMsg(*(poDiPORouteGuidanceUpdateMsg->m_porDiPORouteGuidanceUpdate)));
     }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtNavDataDispatcher::vHandleNavDataMsg()
 ***************************************************************************/
t_Void spi_tclExtNavDataDispatcher::vHandleNavDataMsg(DiPORouteGuidanceManeuverUpdateMsg* poDiPORouteGuidanceManeuverUpdateMsg) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtNavDataDispatcher::vHandleNavDataMsg entered "));
   if (NULL != poDiPORouteGuidanceManeuverUpdateMsg && NULL != poDiPORouteGuidanceManeuverUpdateMsg->m_porDiPORouteGuidanceManeuverUpdate)
     {
        CALL_REG_OBJECTS(spi_tclExtRespNavData,
                 e16EXT_NAVDATA_REGID,
                 vPostDiPORouteGuidanceManeuverUpdateMsg(*(poDiPORouteGuidanceManeuverUpdateMsg->m_porDiPORouteGuidanceManeuverUpdate)));
     }
}


///////////////////////////////////////////////////////////////////////////////
// <EOF>
