/*!
 *******************************************************************************
 * \file              spi_tclExtRespNavData.h
 * \brief             External Interfaces Wrapper Response class for Nav Data
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    External Interfaces Wrapper Response class for Nav Data
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 30.01.2017 | Dhiraj Asopa          | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLEXTRESPNAVDATA_H_
#define _SPI_TCLEXTRESPNAVDATA_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"
#include "spi_TBTTypes.h"

class spi_tclExtRespNavData: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespNavData::spi_tclExtRespNavData()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespNavData()
    * \brief   Constructor
    * \sa      spi_tclExtRespNavData()
    **************************************************************************/
   spi_tclExtRespNavData(): RespBase(e16EXT_NAVDATA_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespNavData::~spi_tclExtRespNavData()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespNavData()
    * \brief   Destructor
    * \sa      spi_tclExtRespNavData()
    **************************************************************************/
   virtual ~spi_tclExtRespNavData() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespNavData::vPostNavDataResult()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostNavDataResult()
    * \brief   Called when Nav Data data result is sent by Nav Data Client Handler.
    *          Mandatory interface to be implemented.
    * \param   [IN]vector<tenNmeaSentenceType>:vector to hold NMEA sentences
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostNavDataResult(t_Bool bStartLocData,const std::vector<tenNmeaSentenceType>& rfcoNmeaSentencesList,t_U8 u8RequestedBy)
   {
       SPI_INTENTIONALLY_UNUSED(bStartLocData);
       SPI_INTENTIONALLY_UNUSED(rfcoNmeaSentencesList);
       SPI_INTENTIONALLY_UNUSED(u8RequestedBy);
   }

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespNavData::vPostGPRMCDataStatusValues()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostGPRMCDataStatusValues()
    * \brief   Called when GPRMC Data Status Values are sent by Nav Data Client Handler.
    *          Mandatory interface to be implemented.
    * \param   [IN]u32DeviceId : Device ID
    * \param   [IN]u8GPRMCDataStatusValues : GPRMC Data Status Values i.e. A, V, X
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostGPRMCDataStatusValues(t_U32 u32DeviceId,t_U8 u8GPRMCDataStatusValues)
   {
       SPI_INTENTIONALLY_UNUSED(u32DeviceId);
       SPI_INTENTIONALLY_UNUSED(u8GPRMCDataStatusValues);
   }

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespNavData::vPostDiPORouteGuidanceUpdateMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostDiPORouteGuidanceUpdateMsg()
    * \brief   Called when DiPORouteGuidanceUpdate data is sent by MediaPlayer Client Handler.
    * \param   corfrTurnByTurnInfo: structure to hold trDiPORouteGuidanceUpdate data
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostDiPORouteGuidanceUpdateMsg(const trDiPORouteGuidanceUpdate &corfrDiPORouteGuidanceUpdate)
   {
       SPI_INTENTIONALLY_UNUSED(corfrDiPORouteGuidanceUpdate);
   }

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespNavData::vPostDiPORouteGuidanceManeuverUpdateMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostDiPORouteGuidanceManeuverUpdateMsg()
    * \brief   Called when DiPORouteGuidanceManeuverUpdate data is sent by MediaPlayer Client Handler.
    * \param   corfrDiPORouteGuidanceManeuverUpdate: structure to trDiPORouteGuidanceManeuverUpdate data
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostDiPORouteGuidanceManeuverUpdateMsg(const trDiPORouteGuidanceManeuverUpdate &corfrDiPORouteGuidanceManeuverUpdate)
   {
       SPI_INTENTIONALLY_UNUSED(corfrDiPORouteGuidanceManeuverUpdate);
   }

};

#endif /* _SPI_TCLEXTRESPNAVDATA_H_ */
