/*!
*******************************************************************************
* \file              spi_tclExtCmdNavData.h
* \brief             Nav Data Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Nav Data Adapter Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
27.01.2017 | Dhiraj Asopa                 | Initial Version
\endverbatim
******************************************************************************/

#ifndef SPI_TCLEXTCMDNAVDATA_H_
#define SPI_TCLEXTCMDNAVDATA_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_tclExtCmdNavDataIntf.h"
#include "spi_TBTTypes.h"

class spi_tclMPlayClientHandler;
class spi_tclExtCmdNavData: public spi_tclExtCmdNavDataIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdNavData::spi_tclExtCmdNavData()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdNavData()
   * \brief   Default constructor
   * \sa
   **************************************************************************/
   spi_tclExtCmdNavData();

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdNavData::~spi_tclExtCmdNavData()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdNavData()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdNavData();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdNavData::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdNavData::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclExtCmdNavData::bTransferGPSData(...)
   ***************************************************************************/
   /*!
    * \fn     bTransferGPSData(t_U32 u32DeviceHandle, t_String szDeviceSerialNo, t_String szGPGGAData,
    *            t_String szGPRMCData, t_String szGPGSVData, t_String szGPHDTData)
    * \brief  Function to transfer GPS date to device.
    * \param  u32DeviceHandle : [IN] Unique device handle of active device
    * \param  szDeviceSerialNo : [IN] Unique serial number of active device
    * \param  szGPGGAData : [IN] GPGGA data
    * \param  szGPRMCData : [IN] GPRMS data
    * \param  szGPGSVData : [IN] GPGSV data
    * \param  szGPHDTData : [IN] GPHDT data
    * \retval bool : true if succees, false otherwise
   **************************************************************************/
   t_Bool bTransferGPSData(t_U32 u32DeviceHandle, t_String szDeviceSerialNo,
            t_String szGPGGAData, t_String szGPRMCData, t_String szGPGSVData, t_String szGPHDTData);

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclExtCmdNavData::bTransferDrData(...)
   ***************************************************************************/
   /*!
   * \fn     bTransferDrData(t_U32 u32DeviceHandle, t_String szDeviceSerialNo, t_String szPASCDData,
   *            t_String szPAGCDData, t_String szPAACDData)
   * \brief  Function to transfer DR date to device.
   * \param  u32DeviceHandle : [IN] Unique device handle of active device
   * \param  szDeviceSerialNo : [IN] Unique serial number of active device
   * \param  szPASCDData : [IN] PASCD data
   * \param  szPAGCDData : [IN] PAGCD data
   * \param  szPAACDData : [IN] PAGCD data
   * \retval bool : true if succees, false otherwise
   **************************************************************************/
   t_Bool bTransferDrData(t_U32 u32DeviceHandle, t_String szDeviceSerialNo,
            t_String szPASCDData, t_String szPAGCDData, t_String szPAACDData);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNavData::vRegisterForNavDataProperties()
   **************************************************************************/
   /*!
   * \fn      vRegisterForNavDataProperties()
   * \brief   Registers for all interested properties to NavData
   **************************************************************************/
   virtual t_Void vRegisterForNavDataProperties();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNavData::vUnregisterForNavDataProperties()
   **************************************************************************/
   /*!
   * \fn      vUnregisterForNavDataProperties()
   * \brief   Un-registers all subscribed properties to NavData
   **************************************************************************/
   virtual t_Void vUnregisterForNavDataProperties();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNavData::vDipoStartRouteGuidanceUpdate()
   **************************************************************************/
   /*!
   * \fn      vDipoStartRouteGuidanceUpdate()
   * \brief   Function to start route guidance
   * \param   cou32DevHandle: Device handle of the device
   * \sa      vDipoStopRouteGuidance()
   **************************************************************************/
   t_Void vDipoStartRouteGuidanceUpdate(const t_U32 cou32DevHandle);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNavData::vDipoStopRouteGuidanceUpdate()
   **************************************************************************/
   /*!
   * \fn      vDipoStopRouteGuidanceUpdate()
   * \brief   Function to stop route guidance
   * \param   cou32DevHandle: Device handle of the device
   * \sa      vDipoStartRouteGuidance()
   **************************************************************************/
   t_Void vDipoStopRouteGuidanceUpdate(const t_U32 cou32DevHandle);

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclExtCmdNavData::bOnRegRouteGuidanceDisplayConf()
   ***************************************************************************/
   /*!
    * \fn     bOnRegRouteGuidanceDisplayConf(const std::vector<trDiPORouteGuidanceDisplayComponent>& corfvecRouteGuidanceDisplayComponent)
    * \brief  Interface to send device list details
    * \param  [IN] corfvecRouteGuidanceDisplayComponent : registered display component list
    * \retval t_Bool  TRUE- Enabled FALSE-Disabled
    **************************************************************************/
   t_Bool bOnRegRouteGuidanceDisplayConf(const std::vector<trDiPORouteGuidanceDisplayComponent>& corfvecRouteGuidanceDisplayComponent);

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclExtCmdNavData::bOnStartRouteGuidanceUpdates
    ***************************************************************************/
   /*!
    * \fn     bOnStartRouteGuidanceUpdates(const trStartRouteGuidanceUpdates& corfStartRouteGuidanceUpdates)
    * \brief  Interface to start route guidance updates
    * \param  [IN] cou32DevHandle : currently selected device handle
    * \param  [IN] trStartRouteGuidanceUpdates : start route guidance parameters
    * \retval t_Bool  TRUE- Enabled FALSE-Disabled
    **************************************************************************/
    t_Bool bOnStartRouteGuidanceUpdates(t_U32 cou32DevHandle, trStartRouteGuidanceUpdates& corfStartRouteGuidanceUpdates);

    /***************************************************************************
     ** FUNCTION: t_Void spi_tclExtCmdNavData::bOnStopRouteGuidanceUpdates
     ***************************************************************************/
    /*!
     * \fn     bOnStopRouteGuidanceUpdates(const trStopRouteGuidanceUpdates& corfStopRouteGuidanceUpdates)
     * \brief  Interface to stop route guidance updates
    * \param  [IN] cou32DevHandle : currently selected device handle
     * \param  [IN] trStartRouteGuidanceUpdates : stop route guidance parameters
     * \retval t_Bool  TRUE- Enabled FALSE-Disabled
     **************************************************************************/
     t_Bool bOnStopRouteGuidanceUpdates(t_U32 cou32DevHandle, trStopRouteGuidanceUpdates& corfStopRouteGuidanceUpdates);

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdNavData::vOnDipoLocationInfo()
    ***************************************************************************/
   /*!
    * \fn      vOnDipoLocationInfo()
    * \brief   Method to get Dipo Location Data
    * \[PARAM] const vector<tenNmeaSentenceType>:vector of Structure for holding NMEA sentences data
    **************************************************************************/

   t_Void vOnDipoLocationInfo(t_Bool bStartLocData,const std::vector<tenNmeaSentenceType>& rfcoNmeaSentencesList,t_U8 u8RequestedBy);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdNavData::vOnDipoGPRMCDataStatusValues()
    ***************************************************************************/
   /*!
    * \fn      vOnDipoGPRMCDataStatusValues()
    * \brief   Method to get Dipo Location Data
    * \[PARAM] u32DeviceId : Device Id
    * \[PARAM] u8GPRMCDataStatusValues : GPRMC Data Values (A, V, X)
    **************************************************************************/
   t_Void vOnDipoGPRMCDataStatusValues(t_U32 u32DeviceId,t_U8 u8GPRMCDataStatusValues);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdNavData::vOnTurnByTurnInfoUpdateCb()
    ***************************************************************************/
   /*!
    * \fn      vOnDiPORouteGuidanceUpdateCallback()
    * \brief   Method to get Turn by turn updates
    * \[PARAM] const &corfrDiPORouteGuidanceUpdate: Structure for holding trDiPORouteGuidanceUpdate
    **************************************************************************/
   t_Void vOnDiPORouteGuidanceUpdateCallback(const trDiPORouteGuidanceUpdate& corfrDiPORouteGuidanceUpdate);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdNavData::vOnDiPORouteGuidanceManeuverUpdateCallback()
    ***************************************************************************/
   /*!
    * \fn      vOnDiPORouteGuidanceManeuverUpdateCallback()
    * \brief   Method to get Turn by turn updates
    * \[PARAM] const &corfrDiPORouteGuidanceManeuverUpdate: Structure for holding trDiPORouteGuidanceManeuverUpdate
    **************************************************************************/
   t_Void vOnDiPORouteGuidanceManeuverUpdateCallback(const trDiPORouteGuidanceManeuverUpdate& corfrDiPORouteGuidanceManeuverUpdate);

   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   //! MediaPlayer client handler pointer
   spi_tclMPlayClientHandler *m_poMPlayClientHandler;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNavData::vRegisterNavDataCallbacks()
   ***************************************************************************/
   /*!
   * \fn      vRegisterNavDataCallbacks()
   * \brief   Registers NavData callbacks.
   * \retval  None
   **************************************************************************/
   t_Void vRegisterNavDataCallbacks();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNavData::vRegisterTBTCallbacks()
   ***************************************************************************/
   /*!
   * \fn      vRegisterTBTCallbacks()
   * \brief   Registers Turn by Turn callbacks.
   * \retval  None
   **************************************************************************/
   t_Void vRegisterTBTCallbacks();

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // #define SPI_TCLEXTCMDNAVDATA_H_


