/*
 * spi_tclExtCmdNativeTransport.h
 *
 *  Created on: Jan 27, 2017
 *      Author: dao8kor
 */

/*!
*******************************************************************************
* \file              spi_tclExtCmdNativeTransport.h
* \brief             Native Transport Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Native Transport Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
24.01.2017 |  Unmukt Jain                 | Initial Version
\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDNATIVETRANSPORT_H_
#define _SPI_TCLEXTCMDNATIVETRANSPORT_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_tclExtCmdNativeTransportIntf.h"

class spi_tclMPlayClientHandler;
class spi_tclExtCmdNativeTransport: public spi_tclExtCmdNativeTransportIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdNativeTransport::spi_tclExtCmdNativeTransport()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdNativeTransport()
   * \brief   Default constructor
   * \sa
   **************************************************************************/
	spi_tclExtCmdNativeTransport();

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdNativeTransport::~spi_tclExtCmdNativeTransport()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdNativeTransport()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdNativeTransport();

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclExtCmdNativeTransport::bInitialize()
   ***************************************************************************/
   /*!
   * \fn      bInitialize()
   * \brief   Method to Initialize
   * \sa      bInitialize()
   **************************************************************************/
   virtual t_Bool bInitialize();

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclExtCmdNativeTransport::bUnInitialize()
   ***************************************************************************/
   /*!
   * \fn      bUnInitialize()
   * \brief   Method to UnInitialize
   * \sa      bInitialize()
   **************************************************************************/
   virtual t_Bool bUnInitialize();

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclExtCmdNativeTransport::bLaunchApp(const t_U32 cou32DevId, const tenDeviceCategory enDevcat,trEAPAppInfo rEAPAppInfo)
   ***************************************************************************/
   /*!
   * \fn     bLaunchApp(const t_U32 cou32DevId)
   * \brief  Function to connect and launch a particular app
   * \retval bool : true if succees, false otherwise
   **************************************************************************/
   t_Bool bLaunchApp(const t_U32 cou32DevId, const tenDeviceCategory enDevcat,trEAPAppInfo rEAPAppInfo);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNativeTransport::bSendPlayBackCtrlEvent()
   ***************************************************************************/
   /*!
   * \fn      bSendPlayBackCtrlEvent()
   * \brief   This method is used to send media playback control events
   * \retval  bool : true if succees, false otherwise
   **************************************************************************/
   t_Bool bSendPlayBackCtrlEvent(const t_U32 cou32DevId, tenKeyCode enKeyCode, tenKeyMode enKeyMode);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNativeTransport::vRegisterGetSelectedDevSerialCb()
   **************************************************************************/
   /*!
   * \fn      vRegisterGetSelectedDevSerialCb()
   * \brief   Registers for all callbacks properties to respective service
   * \sa      vUnregisterForProperties()
   **************************************************************************/
    t_Void vRegisterGetSelectedDevSerialCb(
              const tfvGetSelectedDevSerialCallback cofvGetSelectedDevSerialCallback);


   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNativeTransport::vOnNativeTransportStartCb(...)
   ***************************************************************************/
   /*!
   * \fn      vOnNativeTransportStartCb()
   * \brief   Called by MPlay client handler to inform native transport has started
   * \param   u32DeviceId: Device ID
   * \retval  None
   **************************************************************************/
   t_Void vOnNativeTransportStart(t_U32 u32DeviceId);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdNativeTransport::vOnNativeTransportStopCb(...)
   ***************************************************************************/
   /*!
   * \fn      vOnNativeTransportStopCb()
   * \brief   Called by MPlay client handler to inform native transport has stopped
   * \param   u32DeviceId: Device ID
   * \retval  None
   **************************************************************************/
   t_Void vOnNativeTransportStop(t_U32 u32DeviceId);

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdNativeTransport::vBTProfileInfoCb()
    ***************************************************************************/
   /*!
    * \fn      vBTProfileInfoCb
    * \brief   Informs the current state of App Transition
    * \param   bIsHFP :
    * \param   bIsA2DP :
    * \param   szFriendlyName:
    * \retval  None
    **************************************************************************/
   t_Void vBTProfileInfoCb(const t_U32 cou32DeviceHandle, t_Bool bIsHFP, t_Bool bIsA2DP, t_String szFriendlyName);

   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdMetaData::vRegisterIAPCallbacks()
   ***************************************************************************/
   /*!
   * \fn      vRegisterIAPCallbacks()
   * \brief   Registers Native Transport callbacks to MediaPlayer client.
   * \retval  None
   **************************************************************************/
   t_Void vRegisterIAPCallbacks();

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   //! MediaPlayer client handler pointer
   spi_tclMPlayClientHandler *m_poMPlayClientHandler;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // #define _SPI_TCLEXTCMDNATIVETRANSPORT_H_


