/*!
*******************************************************************************
* \file              spi_tclExtCmdMetaData.cpp
* \brief             Meta Data Adapter Implementation Class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Meta Data Adapter Implementation Class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        |  Author                       | Modifications
24.01.2017  |  Unmukt Jain                  | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdMetaData.h"
#include "Trace.h"
#include "spi_tclMPlayClientHandler.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtCompMsgQInterface.h"
#include "spi_tclExtMetaDataDispatcher.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdMetaData.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdMetaData:: spi_tclExtCmdMetaData(t_Void)
*******************************************************************************/

spi_tclExtCmdMetaData::spi_tclExtCmdMetaData() : m_poMPlayClientHandler(NULL)
{
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdMetaData::~spi_tclExtCmdMetaData(t_Void)
*******************************************************************************/
spi_tclExtCmdMetaData::~spi_tclExtCmdMetaData()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::~spi_tclExtCmdMetaData destructor entered "));
   m_poMPlayClientHandler  = NULL;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdMetaData::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdMetaData::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::bInitialize entered "));
   t_Bool bInit = false;
   spi_tclExtClientFactory *poExtClientFactory = spi_tclExtClientFactory::getInstance();
   if(NULL != poExtClientFactory)
   {
      m_poMPlayClientHandler = poExtClientFactory->poGetMPlayClientHandlerInstance();
      SPI_NORMAL_ASSERT(NULL == m_poMPlayClientHandler);
   }

   bInit = (NULL != m_poMPlayClientHandler);

   vRegisterMetaDataCallbacks();

   ETG_TRACE_USR1(("[DESC]spi_tclExtCmdMetaData::bInitialize() status = %d",ETG_ENUM(BOOL,bInit)));
   return bInit;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdMetaData::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdMetaData::bUnInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::bUnInitialize entered "));
   t_Bool bUninitSuccess = true;

   m_poMPlayClientHandler = NULL;

   ETG_TRACE_USR2(("[DESC]spi_tclExtCmdMetaData::bUnInitialize() status = %d ", ETG_ENUM(BOOL,bUninitSuccess)));
   return bUninitSuccess;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdMetaData::bDiPOGetAlbumArtInfo(t_String sAlbumArt)
***************************************************************************/
t_Bool spi_tclExtCmdMetaData::bDiPOGetAlbumArtInfo(t_String sAlbumArt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::bDiPOGetAlbumArtInfo entered "));
   t_Bool bResult = false;
   if(NULL != m_poMPlayClientHandler)
   {
      bResult = m_poMPlayClientHandler->bDiPOGetAlbumArtInfo(sAlbumArt);
   }
   return bResult;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdMetaData::bDiPOGetAlbumArt(t_String sUrl)
***************************************************************************/
t_Bool spi_tclExtCmdMetaData::bGetDiPOAlbumArt(t_String szAlbumArtUrl, const trUserContext& corfrUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::bGetDiPOAlbumArt entered "));
   t_Bool bResult = false;
   if(NULL != m_poMPlayClientHandler)
   {
      bResult = m_poMPlayClientHandler->bGetDiPOAlbumArt(szAlbumArtUrl, corfrUsrCntxt);
   }
   return bResult;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdMetaData::vRegisterForMetadataProperties()
**************************************************************************/
t_Void spi_tclExtCmdMetaData::vRegisterForMetadataProperties()
{
   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vRegisterForMetadataProperties();
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdMetaData::vUnregisterForMetadataProperties()
**************************************************************************/
t_Void spi_tclExtCmdMetaData::vUnregisterForMetadataProperties()
{
   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vUnregisterForMetadataProperties();
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdMetaData::vRegisterMetaDataCallbacks()
***************************************************************************/
t_Void spi_tclExtCmdMetaData::vRegisterMetaDataCallbacks()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::vRegisterMetaDataCallbacks() entered "));
   trMetaDataCbs rMetaDataCbs;
   rMetaDataCbs.fvAppMediaAlbumArt = std::bind(&spi_tclExtCmdMetaData::vAppMediaAlbumArtCb, this,
            SPI_FUNC_PLACEHOLDERS_2);
   rMetaDataCbs.fvAppMediaMetaData = std::bind(&spi_tclExtCmdMetaData::vAppMediaMetaDataCb, this,
            SPI_FUNC_PLACEHOLDERS_2);
   rMetaDataCbs.fvAppMediaPlaytime = std::bind(&spi_tclExtCmdMetaData::vAppMediaPlaytimeCb, this,
            SPI_FUNC_PLACEHOLDERS_2);
   rMetaDataCbs.fvAppPhoneData = std::bind(&spi_tclExtCmdMetaData::vAppPhoneDataCb, this,
            SPI_FUNC_PLACEHOLDERS_2);
   rMetaDataCbs.fvAppPhoneCallData = std::bind(&spi_tclExtCmdMetaData::vAppPhoneCallDataCb, this,
            SPI_FUNC_PLACEHOLDERS_2);
   rMetaDataCbs.fvAppDeviceTimeUpdate = std::bind(&spi_tclExtCmdMetaData::vPostAppDeviceTimeUpdateCb, this,
                     SPI_FUNC_PLACEHOLDERS_1);
   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vRegisterMetaDataCallbacks(rMetaDataCbs);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdMetaData::vAppMediaAlbumArtCb()
***************************************************************************/
t_Void spi_tclExtCmdMetaData::vAppMediaAlbumArtCb(const trAppMediaAlbumArt& rAppMediaAlbumArt, const trUserContext& rUserContext)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::vAppMediaAlbumArtCb() entered "));
   AppMediaAlbumArtMsg oAppMediaAlbumArtMsg(rAppMediaAlbumArt, rUserContext);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oAppMediaAlbumArtMsg,sizeof(oAppMediaAlbumArtMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdMetaData::vAppMediaMetaDataCb()
***************************************************************************/
t_Void spi_tclExtCmdMetaData::vAppMediaMetaDataCb(const trAppMediaMetaData &rAppMediaMetaData,
		                                          const trUserContext &rUserContext)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::vAppMediaMetaDataCb() entered "));
   AppMediaMetaDataMsg oAppMediaMetaDataMsg(rAppMediaMetaData, rUserContext);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oAppMediaMetaDataMsg,sizeof(oAppMediaMetaDataMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdMetaData::vAppMediaPlaytimeCb()
***************************************************************************/
t_Void spi_tclExtCmdMetaData::vAppMediaPlaytimeCb(const trAppMediaPlaytime& rfcorAppMediaPlaytime,
                                                  const trUserContext& rfcorUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::vAppMediaPlaytimeCb() entered "));
   AppMediaPlaytimeMsg oAppMediaPlaytimeMsg(rfcorAppMediaPlaytime, rfcorUsrCntxt);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oAppMediaPlaytimeMsg,sizeof(oAppMediaPlaytimeMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdMetaData::vAppPhoneDataCb()
***************************************************************************/
t_Void spi_tclExtCmdMetaData::vAppPhoneDataCb(const trAppPhoneData& rfcorApplicationPhoneData,
                                              const trUserContext& rfcorUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::vAppPhoneDataCb() entered "));
   AppPhoneDataMsg oAppPhoneDataMsg(rfcorApplicationPhoneData, rfcorUsrCntxt);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oAppPhoneDataMsg,sizeof(oAppPhoneDataMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdMetaData::vAppPhoneCallDataCb()
***************************************************************************/
t_Void spi_tclExtCmdMetaData::vAppPhoneCallDataCb(const trAppPhoneCallData& rfcorApplicationPhoneCallData,
                                              const trUserContext& rfcorUsrCntxt)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::vAppPhoneCallDataCb() entered "));
   AppPhoneCallDataMsg oAppPhoneCallDataMsg(rfcorApplicationPhoneCallData, rfcorUsrCntxt);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oAppPhoneCallDataMsg,sizeof(oAppPhoneCallDataMsg));
   }//if (NULL != poExtMsgQinterface)

}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdMetaData::vPostAppDeviceTimeUpdateCb()
***************************************************************************/
t_Void spi_tclExtCmdMetaData::vPostAppDeviceTimeUpdateCb(const trDeviceTime& rfcoDeviceTime)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdMetaData::vPostAppDeviceTimeUpdateCb() entered "));
   AppDeviceTimeUpdateMsg oAppDeviceTimeUpdateMsg(rfcoDeviceTime);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oAppDeviceTimeUpdateMsg,sizeof(oAppDeviceTimeUpdateMsg));
   }//if (NULL != poExtMsgQinterface)

}

/**************************************************************************
** FUNCTION   : t_Void spi_tclExtCmdMetaData:: vTriggerNowPlayingStatus()
***************************************************************************/
t_Void spi_tclExtCmdMetaData::vTriggerNowPlayingStatus()
{
   ETG_TRACE_USR1(("spi_tclExtCmdAppleDiscoverer::vTriggerNowPlayingStatus Entered"));

   if (nullptr != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vTriggerNowPlayingStatus();
   }//if (nullptr != m_pSpiCmdIntf)
}
//lint �restore

