/*!
 *******************************************************************************
 * \file              spi_tclExtRespMetaData.h
 * \brief             External Interfaces Wrapper Response class for Meta Data
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   External Interfaces Wrapper Response class for Meta Data
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 25.01.2017 | Dhiraj Asopa           | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLEEXTRESPMetaData_H_
#define _SPI_TCLEEXTRESPMetaData_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"

class spi_tclExtRespMetaData: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespMetaData::spi_tclExtRespMetaData()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespMetaData()
    * \brief   Constructor
    * \sa      spi_tclExtRespMetaData()
    **************************************************************************/
	spi_tclExtRespMetaData(): RespBase(e16EXT_METADATA_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespMetaData::~spi_tclExtRespMetaData()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespMetaData()
    * \brief   Destructor
    * \sa      spi_tclExtRespMetaData()
    **************************************************************************/
   virtual ~spi_tclExtRespMetaData() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespMetaData::vPostAppMediaMetaDataMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppMediaMetaDataMsg()
    * \brief   Called when DiPO Now Playing Status is detected
    * \param   rAppMediaMetaData: a trAppMediaMetaData type structure
    * \param   rUserContext: User context info
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostAppMediaMetaDataMsg(const trAppMediaMetaData &rfcoAppMediaMetaData, const trUserContext &rfcoUserContext) = 0;

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespMetaData::vPostAppMediaAlbumArtMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppMediaAlbumArtMsg()
    * \brief   Called when DiPO get media object album art
    * \param   rAppMediaAlbumArt: a trAppMediaAlbumArt type structure
    * \param   rUserContext: User context info
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostAppMediaAlbumArtMsg(const trAppMediaAlbumArt &rfcoAppMediaAlbumArt, const trUserContext &rfcoUserContext)=0;

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespMetaData::vPostAppMediaPlaytimeMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppMediaPlaytimeMsg()
    * \brief   Called when DiPO Play time msg arrives.
    * \param   rfcorAppMediaPlaytime: a trAppMediaPlaytime type structure
    * \param   rfcorUsrCntxt: User context info
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostAppMediaPlaytimeMsg(const trAppMediaPlaytime &rfcoAppMediaPlaytime, const trUserContext &rfcoUserContext)=0;
   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespMetaData::vPostAppPhoneDataMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppPhoneDataMsg()
    * \brief   Called when DiPO Called state Status message arrives.
    * \param   rfcorApplicationPhoneData: a trAppPhoneData type structure
    * \param   rfcorUsrCntxt: User context info
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostAppPhoneDataMsg(const trAppPhoneData& rfcorAppPhoneData, const trUserContext &rfcoUserContext)=0;

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespMetaData::vPostAppPhoneCallDataMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppPhoneCallDataMsg()
    * \brief   Called when DiPO Called state Status message arrives.
    * \param   rfcorApplicationPhoneCallData: a trAppPhoneCallData type structure
    * \param   rfcorUsrCntxt: User context info
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostAppPhoneCallDataMsg(const trAppPhoneCallData& rfcorAppPhoneCallData, const trUserContext &rfcoUserContext)=0;


   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespMetaData::vPostAppDeviceTimeUpdateMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppDeviceTimeUpdateMsg()
    * \brief   Called when DiPO Device Time message arrives.
    * \param   rfcoDeviceTime: start time of phone call with reference to device time
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostAppDeviceTimeUpdateMsg(const trDeviceTime& rfcoDeviceTime)=0;
};

#endif /* _SPI_TCLEEXTRESPMetaData_H_ */
