/***********************************************************************/
/*!
 * \file  spi_tclExtMetaDataDispatcher.h
 * \brief Message Dispatcher for Meta Data Messages.Implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Meta Data Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 25.01.2017  | Dhiraj Asopa           | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLEXTMETADATADISPATCHER_H_
#define _SPI_TCLEXTMETADATADISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"

/**************Forward Declarations******************************************/
class spi_tclExtMetaDataDispatcher;

/****************************************************************************/
/*!
 * \class MetaDataMsgBase
 * \brief Base Message type for all Meta Datamessages
 ****************************************************************************/
class MetaDataMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  MetaDataMsgBase::MetaDataMsgBase
    ***************************************************************************/
   /*!
    * \fn      MetaDataMsgBase()
    * \brief   Default constructor
    **************************************************************************/
	MetaDataMsgBase();

   /***************************************************************************
    ** FUNCTION:  MetaDataMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtMetaDataDispatcher* poMetaDataDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poMetaDataDispatcher: pointer to Message dispatcher for Meta Data
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  MetaDataMsgBase::~MetaDataMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~MetaDataMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~MetaDataMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class AppMediaMetaDataMsg
 * \brief AppMediaMetaDataMsg
 ****************************************************************************/
class AppMediaMetaDataMsg: public MetaDataMsgBase
{
   public:

   trAppMediaMetaData *m_prAppMediaMetaData;
   trUserContext      *m_prUserContext;

   /***************************************************************************
   ** FUNCTION:  AppMediaMetaDataMsg::AppMediaMetaDataMsg
   ***************************************************************************/
  /*!
   * \fn      AppMediaMetaDataMsg(const trAppMediaMetaData &rfcoAppMediaMetaData, const trUserContext &rfcoUserContext)
   * \brief   Parameterized constructor
   **************************************************************************/
   AppMediaMetaDataMsg(const trAppMediaMetaData &rfcoAppMediaMetaData, const trUserContext &rfcoUserContext);
   /***************************************************************************
    ** FUNCTION:  AppMediaMetaDataMsg::~AppMediaMetaDataMsg
    ***************************************************************************/
   /*!
    * \fn      ~AppMediaMetaDataMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~AppMediaMetaDataMsg(){}

   /***************************************************************************
    ** FUNCTION:  AppMediaMetaDataMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtWiFiDispatcher* poWiFiDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poMetaDataDispatcher : pointer to Message dispatcher for Meta Data
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher);

   /***************************************************************************
    ** FUNCTION:  AppMediaMetaDataMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  AppMediaMetaDataMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class AppMediaAlbumArtMsg
 * \brief AppMediaAlbumArtMsg
 ****************************************************************************/
class AppMediaAlbumArtMsg: public MetaDataMsgBase
{
   public:

      trAppMediaAlbumArt *m_prAppMediaAlbumArt;
      trUserContext      *m_prUserContext;

   /***************************************************************************
    ** FUNCTION:  AppMediaAlbumArtMsg::AppMediaAlbumArtMsg
    ***************************************************************************/
   /*!
    * \fn      AppMediaAlbumArtMsg( const trAppMediaAlbumArt &rfcoAppMediaAlbumArt, const trUserContext &rfcoUserContext)
    * \brief   Parameterized constructor
    **************************************************************************/
	AppMediaAlbumArtMsg( const trAppMediaAlbumArt &rfcoAppMediaAlbumArt, const trUserContext &rfcoUserContext);

   /***************************************************************************
    ** FUNCTION:  AppMediaAlbumArtMsg::~AppMediaAlbumArtMsg
    ***************************************************************************/
   /*!
    * \fn      ~AppMediaAlbumArtMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~AppMediaAlbumArtMsg(){}

   /***************************************************************************
    ** FUNCTION:  AppMediaAlbumArtMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poMetaDataDispatcher : pointer to Message dispatcher for Meta Data
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher);

   /***************************************************************************
    ** FUNCTION:  AppMediaAlbumArtMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  AppMediaAlbumArtMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class AppMediaPlaytimeMsg
 * \brief AppMediaPlaytimeMsg
 ****************************************************************************/
class AppMediaPlaytimeMsg: public MetaDataMsgBase
{
   public:

      trAppMediaPlaytime *m_prAppMediaPlaytime;
      trUserContext      *m_prUserContext;

   /***************************************************************************
    ** FUNCTION:  AppMediaPlaytimeMsg::AppMediaPlaytimeMsg
    ***************************************************************************/
   /*!
    * \fn      AppMediaPlaytimeMsg( const trAppMediaPlaytime &rfcoAppMediaPlaytime, const trUserContext &rfcoUserContext)
    * \brief   Parameterized constructor
    **************************************************************************/
   AppMediaPlaytimeMsg( const trAppMediaPlaytime &rfcoAppMediaPlaytime, const trUserContext &rfcoUserContext);

   /***************************************************************************
    ** FUNCTION:  AppMediaPlaytimeMsg::~AppMediaPlaytimeMsg
    ***************************************************************************/
   /*!
    * \fn      ~AppMediaPlaytimeMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~AppMediaPlaytimeMsg(){}

   /***************************************************************************
    ** FUNCTION:  AppMediaPlaytimeMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poMetaDataDispatcher : pointer to Message dispatcher for Meta Data
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher);

   /***************************************************************************
    ** FUNCTION:  AppMediaPlaytimeMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  AppMediaPlaytimeMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class AppPhoneDataMsg
 * \brief AppPhoneDataMsg
 ****************************************************************************/
class AppPhoneDataMsg: public MetaDataMsgBase
{
   public:

      trAppPhoneData     *m_prAppPhoneData;
      trUserContext      *m_prUserContext;

   /***************************************************************************
    ** FUNCTION:  AppPhoneDataMsg::AppPhoneDataMsg
    ***************************************************************************/
   /*!
    * \fn      AppPhoneDataMsg( const trAppPhoneData& rfcorAppPhoneData, const trUserContext &rfcoUserContext)
    * \brief   Parameterized constructor
    **************************************************************************/
   AppPhoneDataMsg(const trAppPhoneData& rfcorAppPhoneData, const trUserContext &rfcoUserContext);

   /***************************************************************************
    ** FUNCTION:  AppPhoneDataMsg::~AppPhoneDataMsg
    ***************************************************************************/
   /*!
    * \fn      ~AppPhoneDataMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~AppPhoneDataMsg(){}

   /***************************************************************************
    ** FUNCTION:  AppPhoneDataMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poMetaDataDispatcher : pointer to Message dispatcher for Meta Data
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher);

   /***************************************************************************
    ** FUNCTION:  AppPhoneDataMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  AppPhoneDataMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class AppPhoneCallDataMsg
 * \brief AppPhoneCallDataMsg
 ****************************************************************************/
class AppPhoneCallDataMsg: public MetaDataMsgBase
{
   public:

      trAppPhoneCallData     *m_prAppPhoneCallData;
      trUserContext      *m_prUserContext;

   /***************************************************************************
    ** FUNCTION:  AppPhoneCallDataMsg::AppPhoneCallDataMsg
    ***************************************************************************/
   /*!
    * \fn      AppPhoneCallDataMsg( const trAppPhoneCallData& rfcorAppPhoneCallData, const trUserContext &rfcoUserContext)
    * \brief   Parameterized constructor
    **************************************************************************/
   AppPhoneCallDataMsg(const trAppPhoneCallData& rfcorAppPhoneCallData, const trUserContext &rfcoUserContext);

   /***************************************************************************
    ** FUNCTION:  AppPhoneCallDataMsg::~AppPhoneCallDataMsg
    ***************************************************************************/
   /*!
    * \fn      ~AppPhoneCallDataMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~AppPhoneCallDataMsg(){}

   /***************************************************************************
    ** FUNCTION:  AppPhoneCallDataMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poMetaDataDispatcher : pointer to Message dispatcher for Meta Data
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher);

   /***************************************************************************
    ** FUNCTION:  AppPhoneCallDataMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  AppPhoneCallDataMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class AppDeviceTimeUpdateMsg
 * \brief AppDeviceTimeUpdateMsg
 ****************************************************************************/
class AppDeviceTimeUpdateMsg: public MetaDataMsgBase
{
   public:

      trDeviceTime      *m_prDeviceTime;

   /***************************************************************************
    ** FUNCTION:  AppDeviceTimeUpdateMsg::AppDeviceTimeUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      AppDeviceTimeUpdateMsg(const trDeviceTime& corDeviceTime)
    * \param   rfcoDeviceTime: start time of phone call with reference to device time
    * \brief   Parameterized constructor
    **************************************************************************/
      AppDeviceTimeUpdateMsg(const trDeviceTime& corDeviceTime);

   /***************************************************************************
    ** FUNCTION:  AppDeviceTimeUpdateMsg::~AppIAP2OverWiFiConnectedMsg
    ***************************************************************************/
   /*!
    * \fn      ~AppIAP2OverWiFiConnectedMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~AppDeviceTimeUpdateMsg(){}

   /***************************************************************************
    ** FUNCTION:  AppDeviceTimeUpdateMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poMetaDataDispatcher : pointer to Message dispatcher for Meta Data
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtMetaDataDispatcher *poMetaDataDispatcher);

   /***************************************************************************
    ** FUNCTION:  AppDeviceTimeUpdateMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  AppDeviceTimeUpdateMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclExtMetaDataDispatcher
 * \brief Message Dispatcher for Meta DataMessages
 ****************************************************************************/
class spi_tclExtMetaDataDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtMetaDataDispatcher::
    **                spi_tclExtMetaDataDispatcher()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtMetaDataDispatcher()
    * \brief   Default constructor
    **************************************************************************/
	spi_tclExtMetaDataDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtMetaDataDispatcher::
    **               ~spi_tclExtMetaDataDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtMetaDataDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtMetaDataDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtMetaDataDispatcher::
    **                vHandleMetaDataMsg(AppMediaMetaDataMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleMetaDataMsg(AppMediaMetaDataMsg* poAppMediaMetaDataMsg)
    * \brief   Handles Messages of AppMediaMetaDataMsg type
    * \param   poAppMediaMetaDataMsg : pointer to AppMediaMetaDataMsg.
    **************************************************************************/
   t_Void vHandleMetaDataMsg(AppMediaMetaDataMsg *poAppMediaMetaDataMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtMetaDataDispatcher::
    **                vHandleMetaDataMsg(AppMediaAlbumArtMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleMetaDataMsg(AppMediaAlbumArtMsg* poAppMediaAlbumArtMsg)
    * \brief   Handles Messages of AppMediaAlbumArtMsg type
    * \param   poAppMediaAlbumArtMsg : pointer to AppMediaAlbumArtMsg.
    **************************************************************************/
   t_Void vHandleMetaDataMsg(AppMediaAlbumArtMsg *poAppMediaAlbumArtMsg) const;

    /***************************************************************************
    ** FUNCTION:  spi_tclExtMetaDataDispatcher::
    **                vHandleMetaDataMsg(AppMediaPlaytimeMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleMetaDataMsg(AppMediaPlaytimeMsg* poAppMediaAlbumArtMsg)
    * \brief   Handles Messages of AppMediaPlaytimeMsg type
    * \param   poAppMediaPlaytimeMsg : pointer to AppMediaPlaytimeMsg.
    **************************************************************************/
   t_Void vHandleMetaDataMsg(AppMediaPlaytimeMsg *poAppMediaPlaytimeMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtMetaDataDispatcher::
    **                vHandleMetaDataMsg(AppPhoneDataMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleMetaDataMsg(AppPhoneDataMsg* poAppPhoneDataMsg)
    * \brief   Handles Messages of AppPhoneDataMsg type
    * \param   poAppPhoneDataMsg : pointer to AppPhoneDataMsg.
    **************************************************************************/
   t_Void vHandleMetaDataMsg(AppPhoneDataMsg *poAppPhoneDataMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtMetaDataDispatcher::
    **                vHandleMetaDataMsg(AppPhoneCallDataMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleMetaDataMsg(AppPhoneCallDataMsg* poAppPhoneCallDataMsg)
    * \brief   Handles Messages of AppPhoneCallDataMsg type
    * \param   poAppPhoneCallDataMsg : pointer to AppPhoneCallDataMsg.
    **************************************************************************/
   t_Void vHandleMetaDataMsg(AppPhoneCallDataMsg *poAppPhoneCallDataMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtMetaDataDispatcher::
    **                vHandleMetaDataMsg(AppDeviceTimeUpdateMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleMetaDataMsg(AppDeviceTimeUpdateMsg *poAppDeviceTimeUpdateMsg)
    * \brief   Handles Messages of AppDeviceTimeUpdateMsg type
    * \param   poAppDeviceTimeUpdateMsg : pointer to AppDeviceTimeUpdateMsg
    **************************************************************************/
   t_Void vHandleMetaDataMsg(AppDeviceTimeUpdateMsg *poAppDeviceTimeUpdateMsg) const;
};

#endif /* _SPI_TCLEXTMETADATADISPATCHER_H_ */
