/*!
*******************************************************************************
* \file              spi_tclExtCmdInputIntf.h
* \brief             Input Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class which provides interfaces to send input information to media
                player
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
23.08.2019 |  Ram Chaithanya S A          | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "Trace.h"
#include "spi_tclExtCmdInput.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclMPlayClientHandler.h"
#include "spi_tclDeviceIDDataIntf.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdInput.cpp.trc.h"
#endif

/**
* \brief
*/

/***************************************************************************
** FUNCTION:spi_tclExtCmdInput::spi_tclExtCmdInput()
***************************************************************************/
spi_tclExtCmdInput::spi_tclExtCmdInput():m_poMPlayClientHandler(NULL)
{
}
/***************************************************************************
** FUNCTION: spi_tclExtCmdInput::~spi_tclExtCmdInput()
***************************************************************************/
spi_tclExtCmdInput::~spi_tclExtCmdInput()
{
}
/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdInput::bInitialize()
***************************************************************************/
t_Bool spi_tclExtCmdInput::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdInput::bInitialize entered "));
   t_Bool bRetVal = false;
   spi_tclExtClientFactory *poExtClientFactory = spi_tclExtClientFactory::getInstance();
   if(NULL != poExtClientFactory)
   {
      m_poMPlayClientHandler = poExtClientFactory->poGetMPlayClientHandlerInstance();
      SPI_NORMAL_ASSERT(NULL == m_poMPlayClientHandler);
      bRetVal = true;
   }
   ETG_TRACE_USR1(("[DESC]spi_tclExtCmdInput::bInitialize() status = %d",ETG_ENUM(BOOL,bRetVal)));
   return bRetVal;
}
/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdInput::bUnInitialize()
***************************************************************************/
t_Bool spi_tclExtCmdInput::bUnInitialize()
{
  ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdInput::bUnInitialize entered "));
  t_Bool bRetVal = true;
  m_poMPlayClientHandler = NULL;
  return bRetVal;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdInput::bSetCallControlConfig()
***************************************************************************/
t_Bool spi_tclExtCmdInput::bSetCallControlConfig(const std::set<tenKeyCode>& rfrsetKeyCodes)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdInput::bSetCallControlConfig"));
   t_Bool bRetVal = false;
   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->bSetCallControlConfig(rfrsetKeyCodes);
      bRetVal = true;
   }
   return bRetVal;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdInput::bDiPOAcceptCall()
***************************************************************************/
t_Bool spi_tclExtCmdInput::bDiPOAcceptCall(const t_U32 cou32DeviceHandle, const tenPhoneCallAcceptAction coenCallAcceptAction) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdInput::bDiPOAcceptCall entered with device Id = %d, CallAcceptAction = %d",
      cou32DeviceHandle, ETG_ENUM(CALL_ACCEPTACTION, coenCallAcceptAction)));
   t_Bool bResult = false;
   spi_tclDeviceIDDataIntf oDeviceIDDataIntf;
   t_String szDeviceSerialNumber;
   oDeviceIDDataIntf.vGetSerialNumber(szDeviceSerialNumber,cou32DeviceHandle);
   if(NULL != m_poMPlayClientHandler)
   {
      bResult = m_poMPlayClientHandler->bDiPOAcceptCall(szDeviceSerialNumber, coenCallAcceptAction);
   }
   return bResult;
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclExtCmdInput::bDiPOEndCall()
***************************************************************************/
t_Bool spi_tclExtCmdInput::bDiPOEndCall(const t_U32 cou32DeviceHandle, const tenPhoneCallEndAction coenCallEndAction) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdInput::bDiPOEndCall entered with device Id = %d, CallEndAction = %d",
      cou32DeviceHandle, ETG_ENUM(CALL_ENDACTION, coenCallEndAction)));
   t_Bool bResult = false;
   spi_tclDeviceIDDataIntf oDeviceIDDataIntf;
   t_String szDeviceSerialNumber;
   oDeviceIDDataIntf.vGetSerialNumber(szDeviceSerialNumber,cou32DeviceHandle);
   if(NULL != m_poMPlayClientHandler)
   {
      bResult = m_poMPlayClientHandler->bDiPOEndCall(szDeviceSerialNumber, coenCallEndAction);
   }
   return bResult;
}

