/*!
*******************************************************************************
* \file              spi_tclExtCmdInputIntf.h
* \brief             Input Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class which provides interfaces to send input information to media
                player
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
23.08.2019 |  Ram Chaithanya S A          | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDINPUTINTF_H_
#define _SPI_TCLEXTCMDINPUTINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include <set>
/**
* \brief
*/
class spi_tclExtCmdInputIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdInputIntf::~spi_tclExtCmdInputIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdInputIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdInputIntf(){}

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdInputIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdInputIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdInput::bSetCallControlConfig()
    ***************************************************************************/
   /*!
    * \fn      bSetCallControlConfig()
    * \brief   Method to set call controlconfiguration
    * \param   rfrsetKeyCodes : [IN] Set keycodes by HMI
    * \sa      vSetCallControlConfig()
    **************************************************************************/
   virtual t_Bool bSetCallControlConfig(const std::set<tenKeyCode>& rfrsetKeyCodes) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdInputIntf::bDiPOAcceptCall(...)
   **************************************************************************/
   /*!
   * \fn      bDiPOAcceptCall(const t_U32 cou32DeviceHandle,
   *           const tenPhoneCallAcceptAction coenCallAcceptAction) const
   * \brief   Function to accept phone call on AcceptCall softkey press
   * \param   cou32DevHandle       : [IN] Device handle of the device
   * \param   coenCallAcceptAction : [IN] Accepting phone call action 
   * \retval  t_Bool
   **************************************************************************/
   virtual t_Bool bDiPOAcceptCall(const t_U32 cou32DeviceHandle, 
      const tenPhoneCallAcceptAction coenCallAcceptAction) const = 0;

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdInputIntf::bDiPOEndCall()
    **************************************************************************/
    /*!
   * \fn      bDiPOEndCall(const t_U32 cou32DeviceHandle,
   *           const tenPhoneCallEndAction coenCallEndAction) const
   * \brief   Function to end phone call on EndCall softkey press
   * \param   cou32DevHandle    : [IN] Device handle of the device
   * \param   coenCallEndAction : [IN] Accepting phone call action 
    * \retval  t_Bool
    **************************************************************************/
    virtual t_Bool bDiPOEndCall(const t_U32 cou32DeviceHandle,
       const tenPhoneCallEndAction coenCallEndAction) const = 0;


   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // #define _SPI_TCLEXTCMDINPUTINTF_H

