/*!
 *******************************************************************************
 * \file             spi_tclExtClientFactory.cpp
 * \brief            Object Factory class responsible for creation of Client Handlers
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Object Factory class responsible for creation of Client Handlers
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 09.01.2017 |  Dhiraj Asopa                | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/

#include "spi_tclExtClientFactory.h"
//! Includes for Trace files
#include "Trace.h"
#include "spi_tclSensorPVDataClientHandler.h"
#include "spi_tclSensorDataClientHandler.h"
#include "spi_tclWBLClientHandler.h"
#include "spi_tclMPlayClientHandler.h"
#include "spi_tclBluetoothClient.h"
#include "spi_tclTelephoneClient.h"
#include "spi_tclClockClientHandler.h"
#include "ahl_if.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtClientFactory.cpp.trc.h"
#endif
#endif

//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported


/***************************************************************************
 *********************************PUBLIC*************************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclExtClientFactory::~spi_tclExtClientFactory
 ***************************************************************************/
spi_tclExtClientFactory::~spi_tclExtClientFactory()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::~spi_tclExtClientFactory() destructor entered\n"));
   m_poMainApp       = NULL;
   m_poSensorDataClient = NULL;
   m_poPosDataClient=NULL;
   m_poWBLClientHandler = NULL;
   m_poMPlayClientHandler = NULL;
   m_poBTClientHandler = NULL;
   m_poTelClientHandler = NULL;
   m_poClockClient = NULL;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclExtClientFactory::bInitialize()
 ***************************************************************************/
t_Bool spi_tclExtClientFactory::bInitialize()
{
   ETG_TRACE_USR1(("FUNC]spi_tclExtClientFactory::bInitialize() entered\n"));

   //! Create Client Handlers
   if ((NULL != m_poMainApp))
   {
      m_poSensorDataClient = new spi_tclSensorDataClientHandler(m_poMainApp);
      SPI_NORMAL_ASSERT(NULL == m_poSensorDataClient);
      m_poPosDataClient = new spi_tclSensorPVDataClientHandler(m_poMainApp);
      SPI_NORMAL_ASSERT(NULL == m_poPosDataClient);
      m_poWBLClientHandler = new spi_tclWBLClientHandler();
      SPI_NORMAL_ASSERT(NULL == m_poWBLClientHandler);
      m_poMPlayClientHandler = new spi_tclMPlayClientHandler(m_poMainApp);
      SPI_NORMAL_ASSERT(NULL == m_poMPlayClientHandler);

      m_poBTClientHandler = new spi_tclBluetoothClient(m_poMainApp);
      SPI_NORMAL_ASSERT(NULL == m_poBTClientHandler);

	  m_poTelClientHandler = new spi_tclTelephoneClient(m_poMainApp, CCA_C_U16_SRV_FB_TELEPHONE);
      SPI_NORMAL_ASSERT(NULL != m_poTelClientHandler);

      m_poClockClient = new spi_tclClockClientHandler(m_poMainApp);
      SPI_NORMAL_ASSERT(NULL == m_poClockClient);	  
   }
   t_Bool bInit = ( (NULL != m_poSensorDataClient) &&
		            (NULL != m_poPosDataClient)&&
		            (NULL != m_poWBLClientHandler)&&
		            (NULL != m_poMPlayClientHandler)&&
		            (NULL != m_poBTClientHandler)&&
					(NULL != m_poTelClientHandler)&&
					(NULL != m_poClockClient)
		          );

   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::bInitialize() left with bInit=%d\n",ETG_ENUM(BOOL,bInit)));
   return bInit;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclExtClientFactory::bUnInitialize()
 ***************************************************************************/
t_Bool spi_tclExtClientFactory::bUnInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::bUnInitialize() entered\n"));
   //! Uninitialize Client Handlers
   t_Bool bUnInit = true; // return is not handled, hence it is always true.
   //! Release resources
   RELEASE_MEM(m_poSensorDataClient);
   RELEASE_MEM(m_poPosDataClient);
   RELEASE_MEM(m_poWBLClientHandler);
   RELEASE_MEM(m_poMPlayClientHandler);
   RELEASE_MEM(m_poBTClientHandler);
   RELEASE_MEM(m_poTelClientHandler);
   RELEASE_MEM(m_poClockClient);

   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::bUnInitialize() left"));
   return bUnInit;
}

/****************************************************************************************************************
 ** spi_tclSensorDataClientHandler* spi_tclExtClientFactory::poGetSensorDataClientHandlerInstance()
 ****************************************************************************************************************/
spi_tclSensorDataClientHandler* spi_tclExtClientFactory::poGetSensorDataClientHandlerInstance()
{
   return m_poSensorDataClient;
}

/****************************************************************************************************************
 ** spi_tclSensorPVDataClientHandler* spi_tclExtClientFactory::poGetSensorDataClientHandlerInstance()
 ****************************************************************************************************************/
spi_tclSensorPVDataClientHandler* spi_tclExtClientFactory::poGetPosDataClientHandlerInstance()
{
   return m_poPosDataClient;
}

/****************************************************************************************************************
 ** spi_tclWBLClientHandler* spi_tclExtClientFactory::poGetWBLClientHandlerInstance()
 ****************************************************************************************************************/
spi_tclWBLClientHandler* spi_tclExtClientFactory::poGetWBLClientHandlerInstance()
{
   return m_poWBLClientHandler;
}

/****************************************************************************************************************
 ** spi_tclMPlayClientHandler* spi_tclExtClientFactory::poGetMPlayClientHandlerInstance()
 ****************************************************************************************************************/
spi_tclMPlayClientHandler* spi_tclExtClientFactory::poGetMPlayClientHandlerInstance()
{
   return m_poMPlayClientHandler;
}

/*************************************************************************************************************
 ** FUNCTION:  spi_tclBluetoothClient* spi_tclExtClientFactory::poGetBTClientHandlerInstance
 *************************************************************************************************************/
spi_tclBluetoothClient* spi_tclExtClientFactory::poGetBTClientHandlerInstance()
{
	return m_poBTClientHandler;
}

/*************************************************************************************************************
 ** FUNCTION:  spi_tclTelephoneClient* spi_tclExtClientFactory::poGetTelClientHandlerInstance
 *************************************************************************************************************/
spi_tclTelephoneClient* spi_tclExtClientFactory::poGetTelClientHandlerInstance()
{
   return m_poTelClientHandler;
}

/****************************************************************************************************************
 ** spi_tclClockClientHandler* spi_tclExtClientFactory::poGetClockClientHandlerInstance()
 ****************************************************************************************************************/
spi_tclClockClientHandler* spi_tclExtClientFactory::poGetClockClientHandlerInstance()
{
   return m_poClockClient;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclExtClientFactory::vRestoreSettings()
 ***************************************************************************/
t_Void spi_tclExtClientFactory::vRestoreSettings()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::vRestoreSettings() entered "));

   if (nullptr != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vRestoreSettings();
   }//if (nullptr != m_pSpiCmdIntf)
}


/***************************************************************************
 ** FUNCTION:  t_Void spi_tclExtClientFactory::vPrepareForRestoreSettings()
 ***************************************************************************/
t_Void spi_tclExtClientFactory::vPrepareForRestoreSettings()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::vPrepareForRestoreSettings() entered "));

   if (nullptr != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vPrepareForRestoreSettings();
   }//if (nullptr != m_poMPlayClientHandler)
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclExtClientFactory::vRestoreSettingsComplete()
 ***************************************************************************/
t_Void spi_tclExtClientFactory::vRestoreSettingsComplete()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::vRestoreSettingsComplete() entered "));

   if (nullptr != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vRestoreSettingsComplete();
   }//if (nullptr != m_poMPlayClientHandler)
}

/***************************************************************************
 *********************************PRIVATE***********************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclExtClientFactory::spi_tclExtClientFactory
 ***************************************************************************/
spi_tclExtClientFactory::spi_tclExtClientFactory(ahl_tclBaseOneThreadApp* poMainAppl) :
                                                              m_poMainApp(poMainAppl),
		                                                        m_poSensorDataClient(NULL),
		                                                        m_poPosDataClient(NULL),
		                                                        m_poWBLClientHandler(NULL),
		                                                        m_poMPlayClientHandler(NULL),
		                                                        m_poBTClientHandler(NULL),
																m_poTelClientHandler(NULL),
																m_poClockClient(NULL)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::spi_tclExtClientFactory() parameterized constructor entered\n"));
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtClientFactory::spi_tclExtClientFactory
 ***************************************************************************/
spi_tclExtClientFactory::spi_tclExtClientFactory()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::spi_tclExtClientFactory() constructor entered\n"));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtClientFactory::vLoadSettings()
***************************************************************************/
t_Void spi_tclExtClientFactory::vLoadSettings(const trSpiFeatureSupport& corfrSpiFeatureSupport)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::vLoadSettings() entered"));
   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vSetFeatureSupport(corfrSpiFeatureSupport);
   }

   ETG_TRACE_USR1(("[FUNC]spi_tclExtClientFactory::vLoadSettings exit"));
}

//lint ?restore

