/***********************************************************************/
/*!
 * \file  spi_tclExtCompMsgQInterface.h
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for External Interface
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    interface for writing data to Q to use the MsgQ based
                 threading model for External Interface
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                		| Modification
 06.01.2017  |  Unmukt Jain (RBEI/ECP2)     | Initial Version

 \endverbatim
 *************************************************************************/

#ifndef SPI_TCLEXTCOMPMSGQINTERFACE_H_
#define SPI_TCLEXTCOMPMSGQINTERFACE_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "MsgQThreader.h"
#include "spi_tclExtCompMsgQThreadable.h"
#include "GenericSingleton.h"

using namespace shl::thread;

/****************************************************************************/
/*!
* \class spi_tclExtCompMsgQInterface
* \brief interface for writing data to Q to use the MsgQ based
*        threading model for External Interface
****************************************************************************/
class spi_tclExtCompMsgQInterface : public GenericSingleton<spi_tclExtCompMsgQInterface>
{
   public:

      /***************************************************************************
      ** FUNCTION:  spi_tclExtCompMsgQInterface::~spi_tclExtCompMsgQInterface()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclExtCompMsgQInterface()
      * \brief   Destructor
      * \sa      spi_tclExtCompMsgQInterface()
      **************************************************************************/
      ~spi_tclExtCompMsgQInterface();

      /***************************************************************************
      ** FUNCTION:  spi_tclExtCompMsgQInterface::bWriteMsgToQ
      ***************************************************************************/
      /*!
      * \fn      bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize)
      * \brief   Write Msg to Q for dispatching the message by a separate thread
      * \param prMsgBase : Pointer to Base Message type
      * \param u32MsgSize :  size of the message to be written to the MsgQ
      **************************************************************************/
      t_Bool bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize);

      //! Base Singleton class
      friend class GenericSingleton<spi_tclExtCompMsgQInterface> ;

   private:

      /***************************************************************************
      ** FUNCTION:  spi_tclExtCompMsgQInterface::spi_tclExtCompMsgQInterface()
      ***************************************************************************/
      /*!
      * \fn      spi_tclExtCompMsgQInterface()
      * \brief   Default Constructor
      * \sa      ~spi_tclExtCompMsgQInterface()
      **************************************************************************/
      spi_tclExtCompMsgQInterface();
	  
      /***************************************************************************
       ** FUNCTION:  spi_tclExtCompMsgQInterface(const spi_tclExtCompMsgQInterface...
       ***************************************************************************/
      /*!
       * \fn      spi_tclExtCompMsgQInterface(
       *                             const spi_tclExtCompMsgQInterface& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclExtCompMsgQInterface()
       ***************************************************************************/
       spi_tclExtCompMsgQInterface(const spi_tclExtCompMsgQInterface& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclExtCompMsgQInterface& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclExtCompMsgQInterface& operator=(
       *                          const spi_tclExtCompMsgQInterface& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclExtCompMsgQInterface(const spi_tclExtCompMsgQInterface& otrSrc)
       ***************************************************************************/
       spi_tclExtCompMsgQInterface& operator=(const spi_tclExtCompMsgQInterface& corfoSrc);	  

      //! Pointer to the overridden MsgQThreadable class
      spi_tclExtCompMsgQThreadable *m_poExtCompMsgQThreadable;

      //! pointer to MsgQThreader
      MsgQThreader *m_poExtCompMsgQThreader;

};


#endif /* SPI_TCLEXTCOMPMSGQINTERFACE_H_ */
