/*!
*******************************************************************************
* \file              spi_tclExtCmdClock.cpp
* \brief             Clock Adapter Implementation Class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Clock Adapter Implementation Class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        |  Author                       | Modifications
23.01.2019  |  Rajendra Naik Vadthe         | Initial Version


\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdClock.h"
#include "Trace.h"
#include "spi_tclClockClientHandler.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtClockDispatcher.h"
#include "spi_tclExtCompMsgQInterface.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdClock.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdClock:: spi_tclExtCmdClock(t_Void)
*******************************************************************************/

spi_tclExtCmdClock::spi_tclExtCmdClock()
{
   m_poClockClientHandler=NULL;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdClock::
*             ~spi_tclExtCmdClock(t_Void)
*******************************************************************************/
spi_tclExtCmdClock::~spi_tclExtCmdClock()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdClock::~spi_tclExtCmdClock entered "));
}

/*******************************************************************************
* FUNCTION:t_Bool spi_tclExtCmdClock::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdClock::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdClock::bInitialize entered "));
   t_Bool bInit = true;
   spi_tclExtClientFactory *poExtClientFactory=spi_tclExtClientFactory::getInstance();
   if (NULL!=poExtClientFactory)
   {
      m_poClockClientHandler = poExtClientFactory->poGetClockClientHandlerInstance();
      if (NULL != m_poClockClientHandler)
      {
         ETG_TRACE_USR1(("[DESC:]spi_tclExtCmdClock::bInitialize registering for callbacks"));
         trClockCbs rClockCallbacks;
         rClockCallbacks.fvOnClockData = std::bind(&spi_tclExtCmdClock::vOnClockData,
                                                                  this,
                                                                  SPI_FUNC_PLACEHOLDERS_1);
         m_poClockClientHandler->vRegisterCallbacks(rClockCallbacks);
      }
   }
   return bInit;
}
/*******************************************************************************
* FUNCTION:t_Bool spi_tclExtCmdClock::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdClock::bUnInitialize()
{
   ETG_TRACE_USR1(("FUNC]spi_tclExtCmdClock::bUnInitialize entered "));
   m_poClockClientHandler=NULL;
   return true;
}

/*******************************************************************************
* FUNCTION: t_Void spi_tclExtCmdClock::vStartClock(tenClockType enDataType)
*******************************************************************************/
t_Void spi_tclExtCmdClock::vStartClock()
{
   ETG_TRACE_USR1(("spi_tclExtCmdClock::vStartClockentered "));
   if(NULL != m_poClockClientHandler)
   {
      m_poClockClientHandler->vRegisterForProperty();
   }
}

/**********************************************************************************
* FUNCTION: t_Void spi_tclExtCmdClock::vStopClock(tenClockType enDataType)
*******************************************************************************/
t_Void spi_tclExtCmdClock::vStopClock()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdClock::vStopClock entered "));
   if(NULL != m_poClockClientHandler)
   {
      m_poClockClientHandler->vUnregisterForProperty();
   }
}

/**********************************************************************************
* FUNCTION: t_Void spi_tclExtCmdClock::vOnClock(tenClockType enDataType)
*******************************************************************************/
t_Void spi_tclExtCmdClock::vOnClockData(const t_U8 cou8TimeFormat)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdClock::vOnClockData entered "));
   ClockMsg oClockMsg(cou8TimeFormat);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface  = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface )
   {
      poExtMsgQinterface ->bWriteMsgToQ(&oClockMsg, sizeof(oClockMsg));
   }//if (NULL != poMsgQinterface)
}

//lint restore

