
/***********************************************************************/
/*!
 * \file  spi_tclExtClockDispatcher.cpp
 * \brief Message Dispatcher for Clock Messages. Implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Clock Messages
 AUTHOR:         Rajendra Naik Vadthe
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 25.01.2019  | Rajendra Naik Vadthe  | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtClockDispatcher.h"
#include "spi_tclExtRespClock.h"
//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtClockDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleClockMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  ClockMsgBase::ClockMsgBase
 ***************************************************************************/
ClockMsgBase::ClockMsgBase()
{
   ETG_TRACE_USR1(("[FUNC]ClockMsgBase::ClockMsgBase constructor entered\n"));
   vSetServiceID(e32MODULEID_CLOCK);
}

//!class ClockMsg
/***************************************************************************
 ** FUNCTION:  ClockMsg::ClockMsg
 ***************************************************************************/
ClockMsg::ClockMsg()
{
   ETG_TRACE_USR1(("[FUNC]ClockMsg::ClockMsg constructor entered \n"));
   m_cou8TimeFormat = e8VD_CLOCK_TIMEFORMAT_UNKNOWN;
}

/***************************************************************************
 ** FUNCTION:  ClockMsg::ClockMsg
 ***************************************************************************/
ClockMsg::ClockMsg(const t_U8 cou8TimeFormat):
         m_cou8TimeFormat(cou8TimeFormat)
{
   vAllocateMsg();
}
/***************************************************************************
 ** FUNCTION:  ClockMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(ClockMsg, spi_tclExtClockDispatcher);

/***************************************************************************
 ** FUNCTION:  ClockMsg::vAllocateMsg
 ***************************************************************************/
t_Void ClockMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]ClockMsg::vAllocateMsg entered\n"));
}

/***************************************************************************
 ** FUNCTION:  ClockMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void ClockMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]ClockMsg::vDeAllocateMsg entered\n"));
}

//!class spi_tclExtClockDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtClockDispatcher::spi_tclExtClockDispatcher
 ***************************************************************************/
spi_tclExtClockDispatcher::spi_tclExtClockDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClockDispatcher constructor entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtClockDispatcher::~spi_tclExtClockDispatcher
 ***************************************************************************/
spi_tclExtClockDispatcher::~spi_tclExtClockDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClockDispatcher::~spi_tclExtClockDispatcher destructor entered "));
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtClockDispatcher::vHandleClockMsg()
 ***************************************************************************/
t_Void spi_tclExtClockDispatcher::vHandleClockMsg(ClockMsg *poClockMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtClockDispatcher::vHandleClockMsg entered "));
   if (NULL != poClockMsg)
     {
        CALL_REG_OBJECTS(spi_tclExtRespClock,
                 e16EXT_CLOCK_REGID,
                 vPostClockResult(poClockMsg->m_cou8TimeFormat));
     }
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
