/*!
 *******************************************************************************
 * \file              spi_tclExtRespClock.h
 * \brief             External Interfaces Wrapper Response class for Clock
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    External Interfaces Wrapper Response class for Clock
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 23.01.2019 |  Rajendra Naik Vadthe | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _spi_tclExtRespClock_H_
#define _spi_tclExtRespClock_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"

class spi_tclExtRespClock: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespClock::spi_tclExtRespClock()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespClock()
    * \brief   Constructor
    * \sa      spi_tclExtRespClock()
    **************************************************************************/
   spi_tclExtRespClock(): RespBase(e16EXT_CLOCK_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespClock::~spi_tclExtRespClock()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespClock()
    * \brief   Destructor
    * \sa      spi_tclExtRespClock()
    **************************************************************************/
   virtual ~spi_tclExtRespClock() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespClock::vPostClockResult()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostClockResult()
    * \brief   Called when Clock data result is sent by Clock Client Handler.
    *          Mandatory interface to be implemented.
    * \param   [IN]cou8TimeFormat:Time Format of the clock
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostClockResult(const t_U8 cou8TimeFormat) = 0;

};

#endif /* _spi_tclExtRespClock_H_ */
