/*!
*******************************************************************************
* \file              spi_tclExtCmdClockIntf.h
* \brief             clock Adapter Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    clock Adapter Interface class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
23.01.2019 |  Rajendra Naik Vadthe        | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SPI_TCL_CLOCK_ADAPTER_INTERFACE_H_
#define _SPI_TCL_CLOCK_ADAPTER_INTERFACE_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
/**
* \brief   CLOCK class
*/
class spi_tclExtCmdClockIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdClockIntf::~spi_tclExtCmdClockIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdClockIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdClockIntf(){}
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdClockIntf::vStartClock()
   ***************************************************************************/
   /*!
   * \fn      vStartClock()
   * \brief   This function is called to start Clock
   * \sa
   **************************************************************************/
   virtual t_Void vStartClock()=0;
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdClockIntf::vStopClock()
   ***************************************************************************/
   /*!
   * \fn      vStopClock()
   * \brief   This function is called for stop Clock
   * \sa
   **************************************************************************/
   virtual t_Void vStopClock()=0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdClockIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize()=0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdClockIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize()=0;

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // spi_tclExtCmdClockIntf
