/*!
*******************************************************************************
* \file              spi_tclExtCmdClock.h
* \brief             Clock Adapter Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Clock Adapter Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
23.01.2019 |  Rajendra Naik Vadthe        | Initial Version
\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDCLOCK_H_
#define _SPI_TCLEXTCMDCLOCK_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_tclExtCmdClockIntf.h"

class spi_tclClockClientHandler;
class spi_tclExtCmdClock: public spi_tclExtCmdClockIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdClock::spi_tclExtCmdClock()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdClock()
   * \brief   Default constructor
   * \sa
   **************************************************************************/

   spi_tclExtCmdClock();
   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdClock::~spi_tclExtCmdClock()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdClock()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdClock();

   /***************************************************************************
   * Application specific methods.
   ***************************************************************************/
   /***************************************************************************
      ** FUNCTION:  t_Void spi_tclExtCmdClock::vStartClock()
      ***************************************************************************/
      /*!
      * \fn      vStopClock(tenClockType enDataType,const trSensorDataCallbacks& rfcorSensorDataCb)
      * \brief   This function is called for start sensor
      * \sa
      **************************************************************************/
   /**************************************************************************/
    t_Void vStartClock();
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdClock::vStopClock()
   ***************************************************************************/
   /*!
   * \fn      vStopClock()
   * \brief   This function is called for stop sensor
   * \sa
   **************************************************************************/
   t_Void vStopClock();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdClock::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdClock::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdClock::vOnClock()
    ***************************************************************************/
   /*!
    * \fn      vOnClockData()
    * \brief   Method to get clock Data
    * \[PARAM] cou8TimeFormat: VD Clock TimeFormat
    * \sa      bInitialize()
    **************************************************************************/
   t_Void vOnClockData (const t_U8 cou8TimeFormat);

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   spi_tclClockClientHandler *m_poClockClientHandler;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // _SPI_TCLEXTCMDSENSORDATA_H_


