/***********************************************************************/
/*!
 * \file  spi_tclExtOOBTDispatcher.cpp
 * \brief Message Dispatcher for OOBT Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for OOBT Messages

 COPYRIGHT:      &copy; RBEI


 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtOOBTDispatcher.h"
#include "spi_tclExtRespOOBT.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtOOBTDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleOOBTMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  OOBTMsgBase::OOBTMsgBase
 ***************************************************************************/
OOBTMsgBase::OOBTMsgBase()
{
   ETG_TRACE_USR1(("OOBTMsgBase::OOBTMsgBase entered"));
   vSetServiceID(e32MODULEID_OOBT);
}

//!class OOBTTriggerMsg
/***************************************************************************
 ** FUNCTION:  OOBTTriggerMsg::OOBTTriggerMsg
 ***************************************************************************/
OOBTTriggerMsg::OOBTTriggerMsg()
{
   ETG_TRACE_USR1(("OOBTTriggerMsg::OOBTTriggerMsg entered "));
}

/***************************************************************************
 ** FUNCTION:  OOBTTriggerMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OOBTTriggerMsg, spi_tclExtOOBTDispatcher);

/***************************************************************************
 ** FUNCTION:  OOBTTriggerMsg::vAllocateMsg
 ***************************************************************************/
t_Void OOBTTriggerMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("OOBTTriggerMsg::vAllocateMsg entered\n"));

}

/***************************************************************************
 ** FUNCTION:  OOBTTriggerMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void OOBTTriggerMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("OOBTTriggerMsg::vDeAllocateMsg entered\n"));
}


//!class spi_tclExtOOBTDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtOOBTDispatcher::spi_tclExtOOBTDispatcher
 ***************************************************************************/
spi_tclExtOOBTDispatcher::spi_tclExtOOBTDispatcher()
{
   ETG_TRACE_USR1(("spi_tclExtOOBTDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtOOBTDispatcher::~spi_tclExtOOBTDispatcher
 ***************************************************************************/
spi_tclExtOOBTDispatcher::~spi_tclExtOOBTDispatcher()
{
   ETG_TRACE_USR1(("~spi_tclExtOOBTDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtOOBTDispatcher::vHandleBluetoothMsg((BTLimitationModeMsg..)
 ***************************************************************************/
t_Void spi_tclExtOOBTDispatcher::vHandleOOBTMsg(OOBTTriggerMsg* poOOBTTriggerMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtOOBTDispatcher::vHandleBluetoothMsg entered "));
   if (NULL != poOOBTTriggerMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespOOBT,
               e16EXT_OOBT_REGID,
               vPostOOBTComplete());
   }
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
