/*!
*******************************************************************************
* \file              spi_tclExtCmdMediaDevInfo.cpp
* \brief             Message dispatcher for active media device info
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message dispatcher for active media device info
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                                   | Modifications
03.05.2018 |  Shiva Kumar Gurija                       | Initial Version
\endverbatim
******************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtMediaDevInfoDispatcher.h"
#include "spi_tclExtRespMediaDevInfo.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtMediaDevInfoDispatcher.cpp.trc.h"
   #endif
#endif



#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleMediaDevInfoMsg(this);           \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  MediaDevInfoMsgBase::MediaDevInfoMsgBase
 ***************************************************************************/
MediaDevInfoMsgBase::MediaDevInfoMsgBase()
{
   ETG_TRACE_USR1(("MediaDevInfoMsgBase::MediaDevInfoMsgBase entered"));
   vSetServiceID(e32MODULEID_MEDIADEVINFO);
}

//!class BTMediaDeviceInfoMsg
/***************************************************************************
 ** FUNCTION:  BTMediaDeviceInfoMsg::BTMediaDeviceInfoMsg
 ***************************************************************************/
BTMediaDeviceInfoMsg::BTMediaDeviceInfoMsg(const trMediaDeviceInfo& corfrMediaDeviceInfo)
{
   ETG_TRACE_USR1(("BTMediaDeviceInfoMsg::BTMediaDeviceInfoMsg entered "));
   
   vAllocateMsg();
 
   strncpy(szBTMACAddress,corfrMediaDeviceInfo.szBTMACAddress.c_str(),255);
   bIsConnected = corfrMediaDeviceInfo.bIsConnected;
   bIsMediaPlaying = corfrMediaDeviceInfo.bIsMediaPlaying;
   u32DevID = corfrMediaDeviceInfo.u32DevID;
  
}

/***************************************************************************
 ** FUNCTION:  BTMediaDeviceInfoMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BTMediaDeviceInfoMsg, spi_tclExtMediaDevInfoDispatcher);

/***************************************************************************
 ** FUNCTION:  BTMediaDeviceInfoMsg::vAllocateMsg
 ***************************************************************************/
t_Void BTMediaDeviceInfoMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("BTMediaDeviceInfoMsg::vAllocateMsg entered"));

}

/***************************************************************************
 ** FUNCTION:  BTMediaDeviceInfoMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BTMediaDeviceInfoMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("BTMediaDeviceInfoMsg::vDeAllocateMsg entered"));
}

/***************************************************************************
 ** FUNCTION:BTMediaDeviceInfoMsg::BTMediaDeviceInfoMsg(...)
 ***************************************************************************/
BTMediaDeviceInfoMsg::BTMediaDeviceInfoMsg(const BTMediaDeviceInfoMsg& corfrBTMediaDeviceInfoMsg)
{
    ETG_TRACE_USR1(("BTMediaDeviceInfoMsg() Copy constructor"));

    if(this != &corfrBTMediaDeviceInfoMsg)
    {
       vAllocateMsg();
       strncpy(szBTMACAddress,corfrBTMediaDeviceInfoMsg.szBTMACAddress,255);
       bIsConnected = corfrBTMediaDeviceInfoMsg.bIsConnected;
       bIsMediaPlaying = corfrBTMediaDeviceInfoMsg.bIsMediaPlaying;
       u32DevID = corfrBTMediaDeviceInfoMsg.u32DevID;
    }
}


//!class spi_tclExtMediaDevInfoDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtMediaDevInfoDispatcher::spi_tclExtMediaDevInfoDispatcher
 ***************************************************************************/
spi_tclExtMediaDevInfoDispatcher::spi_tclExtMediaDevInfoDispatcher()
{
   ETG_TRACE_USR1(("spi_tclExtMediaDevInfoDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtMediaDevInfoDispatcher::~spi_tclExtMediaDevInfoDispatcher
 ***************************************************************************/
spi_tclExtMediaDevInfoDispatcher::~spi_tclExtMediaDevInfoDispatcher()
{
   ETG_TRACE_USR1(("~spi_tclExtMediaDevInfoDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtMediaDevInfoDispatcher::vHandleMediaDevInfoMsg((BTLimitationModeMsg..)
 ***************************************************************************/
t_Void spi_tclExtMediaDevInfoDispatcher::vHandleMediaDevInfoMsg(BTMediaDeviceInfoMsg* poBTMediaDeviceInfoMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtMediaDevInfoDispatcher::vHandleMediaDevInfoMsg()"));
   if(NULL != poBTMediaDeviceInfoMsg) 
   {
      trMediaDeviceInfo rMediaDeviceInfo;
      rMediaDeviceInfo.szBTMACAddress = poBTMediaDeviceInfoMsg->szBTMACAddress;
      rMediaDeviceInfo.bIsConnected = poBTMediaDeviceInfoMsg->bIsConnected;
      rMediaDeviceInfo.bIsMediaPlaying = poBTMediaDeviceInfoMsg->bIsMediaPlaying;
      rMediaDeviceInfo.u32DevID = poBTMediaDeviceInfoMsg->u32DevID;

      CALL_REG_OBJECTS(spi_tclExtRespMediaDevInfo,
               e16EXT_MEDIADEVINFO_REGID,
               vPostBTMediaDeviceInfo(rMediaDeviceInfo));
   }
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
