/*!
*******************************************************************************
* \file              spi_tclExtCmdMediaDevInfo.h
* \brief             Adapter class for active media device info
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class for active media device info
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                                   | Modifications
03.05.2018 |  Shiva Kumar Gurija                       | Initial Version
\endverbatim
******************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "Trace.h"
#include "ExtInterfacesTypes.h"
#include "spi_tclMPlayClientHandler.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtCompMsgQInterface.h"
#include "spi_tclExtMediaDevInfoDispatcher.h"
#include "spi_tclExtCmdMediaDevInfoIntf.h"
#include "spi_tclExtCmdMediaDevInfo.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdMediaDevInfo.cpp.trc.h"
#endif

/***************************************************************************
** FUNCTION:  spi_tclExtCmdMediaDevInfo::spi_tclExtCmdMediaDevInfo()
***************************************************************************/
spi_tclExtCmdMediaDevInfo::spi_tclExtCmdMediaDevInfo()
{
   ETG_TRACE_USR1(("spi_tclExtCmdMediaDevInfo::spi_tclExtCmdMediaDevInfo()"));
}

/***************************************************************************
** FUNCTION:  spi_tclExtCmdMediaDevInfo::~spi_tclExtCmdMediaDevInfo()
***************************************************************************/
spi_tclExtCmdMediaDevInfo::~spi_tclExtCmdMediaDevInfo()
{
    ETG_TRACE_USR1(("spi_tclExtCmdMediaDevInfo::~spi_tclExtCmdMediaDevInfo()"));
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclExtCmdMediaDevInfo::bInitialize()
 ***************************************************************************/
t_Bool spi_tclExtCmdMediaDevInfo::bInitialize()
{
    ETG_TRACE_USR1(("spi_tclExtCmdMediaDevInfo::bInitialize()"));

    spi_tclExtClientFactory* poFactory = spi_tclExtClientFactory::getInstance();
    if(NULL != poFactory)
    {
        spi_tclMPlayClientHandler* poMPClientHndlr = poFactory->poGetMPlayClientHandlerInstance();
        if(NULL != poMPClientHndlr)
        {
            trMediaDeviceInfoCbs rMediaDeviceInfoCbs;
            rMediaDeviceInfoCbs.fpvMediaDeviceInfo = std::bind(&spi_tclExtCmdMediaDevInfo::vMediaDeviceInfoUpdate,this,std::placeholders::_1);
            poMPClientHndlr->vRegisterCallbacks(rMediaDeviceInfoCbs);
        }
    }
    return true;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclExtCmdMediaDevInfo::bUnInitialize()
 ***************************************************************************/
t_Bool spi_tclExtCmdMediaDevInfo::bUnInitialize()
{
    ETG_TRACE_USR1(("spi_tclExtCmdMediaDevInfo::bUnInitialize()"));

    return true;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclExtCmdMediaDevInfo::vMediaDeviceInfoUpdate()
 ***************************************************************************/
t_Void spi_tclExtCmdMediaDevInfo::vMediaDeviceInfoUpdate(const trMediaDeviceInfo& corfrMediaDeviceInfo)
{
	ETG_TRACE_USR1(("spi_tclExtCmdMediaDevInfo::vMediaDeviceInfoUpdate()"));

   //Dispatcher
   BTMediaDeviceInfoMsg oBTMediaDeviceInfoMsg(corfrMediaDeviceInfo);
   
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oBTMediaDeviceInfoMsg,sizeof(oBTMediaDeviceInfoMsg));
   }//if (NULL != poExtMsgQinterface)
}
