/*!
*******************************************************************************
* \file              spi_tclExtCmdBluetooth.cpp
* \brief             Bluetooth Adapter Implementation Class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Bluetooth Adapter Implementation Class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        |  Author                       | Modifications
02.02.2017  |  Unmukt Jain                  | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdBluetooth.h"
#include "Trace.h"
#include "spi_tclBluetoothClient.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtBluetoothDispatcher.h"
#include "spi_tclExtCompMsgQInterface.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdBluetooth.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth:: spi_tclExtCmdBluetooth(t_Void)
*******************************************************************************/

spi_tclExtCmdBluetooth::spi_tclExtCmdBluetooth() : m_poBTClientHandler(NULL)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::spi_tclExtCmdBluetooth entered "));
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdWiFi::~spi_tclExtCmdWiFi(t_Void)
*******************************************************************************/
spi_tclExtCmdBluetooth::~spi_tclExtCmdBluetooth()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::~spi_tclExtCmdBluetooth entered "));
   m_poBTClientHandler = NULL;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdBluetooth::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::bInitialize entered "));
   t_Bool bInit = false;
   spi_tclExtClientFactory *poExtClientFactory = spi_tclExtClientFactory::getInstance();
   if(NULL != poExtClientFactory)
   {
      m_poBTClientHandler = poExtClientFactory->poGetBTClientHandlerInstance();
      bInit = (NULL != m_poBTClientHandler);
   }

   vRegisterBTCallbacks();
   vRegisterPairingInfoCallbacks();

   if(NULL != m_poBTClientHandler)
   {
      m_poBTClientHandler->vRegisterForProperties();
   }

   ETG_TRACE_USR1(("[DESC]spi_tclExtCmdBluetooth::bInitialize() status = %d",ETG_ENUM(BOOL,bInit)));
   return bInit;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdBluetooth::bUnInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::bUnInitialize entered "));
   t_Bool bUninitSuccess = true;

   m_poBTClientHandler = NULL;

   ETG_TRACE_USR2(("[DESC]spi_tclExtCmdBluetooth::bUnInitialize() status = %d ", ETG_ENUM(BOOL,bUninitSuccess)));
   return bUninitSuccess;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::bGetPairingStatus(...)
*******************************************************************************/
t_Bool spi_tclExtCmdBluetooth::bGetPairingStatus(const t_String& rfcoszDeviceBTAddress)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::bGetPairingStatus entered "));
   t_Bool bRet = false;
   if(NULL != m_poBTClientHandler)
   {
      bRet = m_poBTClientHandler->bGetPairingStatus(rfcoszDeviceBTAddress);
   }
   return bRet;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::u32GetBTDeviceHandle()
*******************************************************************************/
t_U32 spi_tclExtCmdBluetooth::u32GetBTDeviceHandle(const t_String& rfcoszDeviceBTAddress)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::u32GetBTDeviceHandle entered "));
   t_U32 u8BTDevHandle = 0;
   if(NULL != m_poBTClientHandler)
   {
      u8BTDevHandle = m_poBTClientHandler->u32GetBTDeviceHandle(rfcoszDeviceBTAddress);
   }
   return u8BTDevHandle;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::szGetConnectedDeviceBTAddress()
*******************************************************************************/
t_String spi_tclExtCmdBluetooth::szGetBTDeviceName(const t_String& rfcszDeviceBTAddress)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::szGetConnectedDeviceBTAddress entered "));
   t_String szDeviceName = "";
   if(NULL != m_poBTClientHandler)
   {
      szDeviceName = m_poBTClientHandler->szGetBTDeviceName(rfcszDeviceBTAddress);
   }
   return szDeviceName;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::szGetVehicleBTFriendlyName()
*******************************************************************************/
t_String spi_tclExtCmdBluetooth::szGetVehicleBTFriendlyName()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::szGetVehicleBTFriendlyName entered "));
   t_String szVehicleBTFriendlyName = "";
   if(NULL != m_poBTClientHandler)
   {
      szVehicleBTFriendlyName = m_poBTClientHandler->szGetVehicleBTFriendlyName();
   }
   return szVehicleBTFriendlyName;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::bGetBTServiceAvailability()
*******************************************************************************/
t_Bool spi_tclExtCmdBluetooth::bGetBTServiceAvailability()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::bGetBTServiceAvailability entered "));
   t_Bool bRet = false;
   if(NULL != m_poBTClientHandler)
   {
      bRet = m_poBTClientHandler->bGetBTServiceAvailability();
   }
return bRet;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::bSetBTLimitationMode()
*******************************************************************************/
t_Bool spi_tclExtCmdBluetooth::bSetBTLimitationMode(const t_String& rfcszBTAddress, const t_String& rfcszBTDeviceName, tenBTTechnology enTechnology,
                                                    tenBTCommunicationChannel enCommChannel, tenBTLimitationAction enAction)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::bSetBTLimitationMode entered "));
   t_Bool bRet = false;
   if(NULL != m_poBTClientHandler)
   {
      bRet = m_poBTClientHandler->bSetBTLimitationMode(rfcszBTAddress,rfcszBTDeviceName,enTechnology,enCommChannel,enAction);
   }
   return bRet;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::bSetBTPairingResponse()
*******************************************************************************/
t_Bool spi_tclExtCmdBluetooth::bSetBTPairingResponse(tenPairingResponseType enBTPairingResponse)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::bSetBTPairingResponse entered "));
   t_Bool bRet = false;
   if(NULL != m_poBTClientHandler)
   {
      bRet = m_poBTClientHandler->bSetBTPairingResponse(enBTPairingResponse);
   }
   return bRet;
}
/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::vGetBtMacAddress()
*******************************************************************************/
t_Void spi_tclExtCmdBluetooth::vGetBtMacAddress(const t_String& rfcszDevName, t_String& rfszMACAddress)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vGetBtMacAddress entered "));
   if(NULL != m_poBTClientHandler)
   {
      m_poBTClientHandler->vGetBtMacAddress(rfcszDevName,rfszMACAddress);
   }
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdBluetooth::vRegisterDeviceNameCallback()
*******************************************************************************/
t_Void spi_tclExtCmdBluetooth::vRegisterDeviceNameCallback(const t_String& rfcszAAPBTAddress)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vRegisterDeviceNameCallback entered "));
   trBTDeviceNameCbInfo rBTDevNameCb;
   rBTDevNameCb.szBTAddress = rfcszAAPBTAddress;
   rBTDevNameCb.fvOnBTDeviceNameUpdate = std::bind(&spi_tclExtCmdBluetooth::vOnBTDeviceNameUpdateCb,
                                                    this,
                                                    SPI_FUNC_PLACEHOLDERS_2);
    if(m_poBTClientHandler)
    {
       m_poBTClientHandler->vRegisterDeviceNameCallback(rBTDevNameCb);
    }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vRegisterBTCallbacks()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vRegisterBTCallbacks()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vRegisterBTCallbacks() entered "));
   trBluetoothCallbacks rBluetoothCallbacks;
   rBluetoothCallbacks.fvOnBTConnectionChanged = std::bind(&spi_tclExtCmdBluetooth::vOnBTConnectionChangedCb,
                                                        this,
                                                        SPI_FUNC_PLACEHOLDERS_2);
   rBluetoothCallbacks.fvOnBTLimitationMode = std::bind(&spi_tclExtCmdBluetooth::vOnBTLimitationModeCb,
                                                        this,
                                                        SPI_FUNC_PLACEHOLDERS_1);
   rBluetoothCallbacks.fvOnBTLimitationModeResult = std::bind(&spi_tclExtCmdBluetooth::vOnSetBTLimitationModeResultCb,
                                                        this,
                                                        SPI_FUNC_PLACEHOLDERS_1);
   rBluetoothCallbacks.fvOnBTServiceAvailability = std::bind(&spi_tclExtCmdBluetooth::vOnBTServiceAvailabilityCb,
                                                        this,
                                                        SPI_FUNC_PLACEHOLDERS_1);
   rBluetoothCallbacks.fvOnBTProfileStatus = std::bind(&spi_tclExtCmdBluetooth::vOnBTProfileStatus,
                                                        this);
   rBluetoothCallbacks.fvOnBTPairingStatus = std::bind(&spi_tclExtCmdBluetooth::vOnBTPairingStatusCb,
                                                        this,
                                                        SPI_FUNC_PLACEHOLDERS_2);


   if(NULL != m_poBTClientHandler)
   {
      m_poBTClientHandler->vRegisterCallbacks(rBluetoothCallbacks);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vRegisterPairingInfoCallbacks()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vRegisterPairingInfoCallbacks()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vRegisterPairingInfoCallbacks() entered "));
   trBluetoothPairingCallbacks rBTPairInfoCallbacks;
   rBTPairInfoCallbacks.fvOnBTPairingInfo = std::bind(&spi_tclExtCmdBluetooth::vOnBTPairingInfoCb,
                                                      this,
                                                      SPI_FUNC_PLACEHOLDERS_1);
   if(NULL != m_poBTClientHandler)
   {
      m_poBTClientHandler->vRegisterPairingInfoCallbacks(rBTPairInfoCallbacks);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vRegisterBTMacAddressCallbacks()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vRegisterBTMacAddressCallbacks(trVehicleBTAddressCallback &rVehicleBTAddress)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vRegisterBTMacAddressCallbacks() entered "));
   if(NULL != m_poBTClientHandler)
   {
      m_poBTClientHandler->vRegisterBTMacAddressCallbacks(rVehicleBTAddress);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vOnBTConnectionChangedCb()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vOnBTConnectionChangedCb(t_String szBTDeviceAddress, tenBTConnectionResult enBTConnResult)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vOnBTConnectionChangedCb() entered "));
   BTConnectionChangedMsg oBBTConnectionChangedMsg(szBTDeviceAddress,enBTConnResult);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oBBTConnectionChangedMsg,sizeof(oBBTConnectionChangedMsg));
   }//if (NULL != poExtMsgQinterface)
}
/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vOnBTLimitationModeCb()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vOnBTLimitationModeCb(trBTLimitationModeInfo rBTLimitationModeInfo)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vOnBTLimitationModeCb() entered "));
   BTLimitationModeMsg oBTLimitationModeMsg(rBTLimitationModeInfo);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oBTLimitationModeMsg,sizeof(oBTLimitationModeMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vOnBTPairingStatusCb()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vOnBTPairingStatusCb(tenBTSetPairingStatus enBTSetPairingStatus, t_String szBTDeviceAddress)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vOnBTPairingStatusCb() entered "));
   BTPairingStatusMsg oBTPairingStatusMsg(enBTSetPairingStatus, szBTDeviceAddress);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oBTPairingStatusMsg, sizeof(oBTPairingStatusMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vOnSetBTLimitationModeResultCb()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vOnSetBTLimitationModeResultCb(t_Bool bSetBTLimitationModeResult)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vOnSetBTLimitationModeResultCb() entered "));
   SetBTLimitationModeResultMsg oSetBTLimitationModeResultMsg(bSetBTLimitationModeResult);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oSetBTLimitationModeResultMsg,sizeof(oSetBTLimitationModeResultMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vOnBTServiceAvailabilityCb()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vOnBTServiceAvailabilityCb(t_Bool bServiceAvailable)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vOnBTOnOffChangedCb() entered "));
   BTServiceAvailabilityMsg oBTServiceAvailabilityMsg(bServiceAvailable);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oBTServiceAvailabilityMsg,sizeof(oBTServiceAvailabilityMsg));
   }//if (NULL != poExtMsgQinterface)
}


/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vOnBTPairingInfoCb()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vOnBTPairingInfoCb(trBTPairingRequestInfo rBTPairingReqInfo)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vOnBTPairingInfoCb() entered "));
   BTPairingInfoMsg oBTPairingInfoMsg(rBTPairingReqInfo);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oBTPairingInfoMsg,sizeof(oBTPairingInfoMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vOnBTDeviceNameUpdateCb()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vOnBTDeviceNameUpdateCb(t_String szBTDeviceAddress, t_String szBTDeviceName)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vOnBTDeviceNameUpdateCb() entered "));
   BTDeviceNameUpdateMsg oBTDeviceNameUpdateMsg(szBTDeviceAddress,szBTDeviceName);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oBTDeviceNameUpdateMsg,sizeof(oBTDeviceNameUpdateMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vOnBTProfileStatus()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vOnBTProfileStatus()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vOnBTProfileStatus() entered "));
   BTProfileStatusUpdateMsg oBTProfileStatusUpdateMsg;
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oBTProfileStatusUpdateMsg,sizeof(oBTProfileStatusUpdateMsg));
   }//if (NULL != poExtMsgQinterface)    
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vGetBTProfileStatus()
***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vGetBTProfileStatus(t_U8 u8DeviceHandle,
         t_Bool& rfbIsHFPConn, t_Bool& rfbIsA2DPConn)
{
    ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vGetBTProfileStatus entered "));
    if(NULL != m_poBTClientHandler)
    {
        m_poBTClientHandler->vGetBTProfileStatus(u8DeviceHandle,
          rfbIsHFPConn, rfbIsA2DPConn);
    }
}
/***************************************************************************
 ** FUNCTION:  t_Void spi_tclExtCmdBluetooth::vTriggerBTNameUpdate()
 ***************************************************************************/
t_Void spi_tclExtCmdBluetooth::vTriggerBTNameUpdate(const t_String& rfcszAAPBTAddress)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdBluetooth::vTriggerBTNameUpdate entered "));
   if(NULL != m_poBTClientHandler)
   {
       m_poBTClientHandler->vTriggerBTNameUpdate(rfcszAAPBTAddress);
   }

}
//lint �restore

