/***********************************************************************/
/*!
 * \file  spi_tclExtBluetoothDispatcher.cpp
 * \brief Message Dispatcher for BT Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for BT Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 02.02.2017  | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtBluetoothDispatcher.h"
#include "spi_tclExtRespBluetooth.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtBluetoothDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleBluetoothMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  BluetoothMsgBase::BluetoothMsgBase
 ***************************************************************************/
BluetoothMsgBase::BluetoothMsgBase()
{
   ETG_TRACE_USR1(("BluetoothMsgBase::BluetoothMsgBase entered"));
   vSetServiceID(e32MODULEID_BLUETOOTH);
}

//!class BTConnectionChangedMsg
/***************************************************************************
 ** FUNCTION:  BTConnectionChangedMsg::BTConnectionChangedMsg
 ***************************************************************************/
BTConnectionChangedMsg::BTConnectionChangedMsg(t_String szBTDeviceAddress,tenBTConnectionResult enBTConnResult):m_enBTConnResult(enBTConnResult)
{
   vAllocateMsg();
   if (NULL !=m_poszBTDeviceAddress)
   {
      (*m_poszBTDeviceAddress) = szBTDeviceAddress;
   }
}

/***************************************************************************
 ** FUNCTION:  BTConnectionChangedMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BTConnectionChangedMsg, spi_tclExtBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BTConnectionChangedMsg::vAllocateMsg
 ***************************************************************************/
t_Void BTConnectionChangedMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("BTConnectionChangedMsg::vAllocateMsg entered"));
   m_poszBTDeviceAddress = new t_String;
}

/***************************************************************************
 ** FUNCTION:  BTConnectionChangedMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BTConnectionChangedMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("BTConnectionChangedMsg::vDeAllocateMsg entered"));
   RELEASE_MEM(m_poszBTDeviceAddress);
}


//!class BTPairingStatusMsg
/***************************************************************************
 ** FUNCTION:  BTPairingStatusMsg::BTPairingStatusMsg
 ***************************************************************************/
BTPairingStatusMsg::BTPairingStatusMsg(tenBTSetPairingStatus enBTSetPairingStatus, t_String szBTDeviceAddress) : m_enBTSetPairingStatus(enBTSetPairingStatus)
{
   vAllocateMsg();
   if (NULL !=m_poszBTDeviceAddress)
   {
      (*m_poszBTDeviceAddress) = szBTDeviceAddress;
   }
}

/***************************************************************************
 ** FUNCTION:  BTPairingStatusMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BTPairingStatusMsg, spi_tclExtBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BTPairingStatusMsg::vAllocateMsg
 ***************************************************************************/
t_Void BTPairingStatusMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("BTPairingStatusMsg::vAllocateMsg entered"));
   m_poszBTDeviceAddress = new t_String;
}

/***************************************************************************
 ** FUNCTION:  BTPairingStatusMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BTPairingStatusMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("BTPairingStatusMsg::vDeAllocateMsg entered"));
   RELEASE_MEM(m_poszBTDeviceAddress);
}


//!class BTServiceAvailabilityMsg
/***************************************************************************
 ** FUNCTION:  BTServiceAvailabilityMsg::BTServiceAvailabilityMsg
 ***************************************************************************/
BTServiceAvailabilityMsg::BTServiceAvailabilityMsg(t_Bool bServiceAvailable):m_bServiceAvailable(bServiceAvailable)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BTServiceAvailabilityMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BTServiceAvailabilityMsg, spi_tclExtBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BTServiceAvailabilityMsg::vAllocateMsg
 ***************************************************************************/
t_Void BTServiceAvailabilityMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("BTServiceAvailabilityMsg::vAllocateMsg entered\n"));
}

/***************************************************************************
 ** FUNCTION:  BTServiceAvailabilityMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BTServiceAvailabilityMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("BTServiceAvailabilityMsg::vDeAllocateMsg entered\n"));
}

//!class BTPairingInfoMsg
/***************************************************************************
 ** FUNCTION:  BTPairingInfoMsg::BTPairingInfoMsg
 ***************************************************************************/
BTPairingInfoMsg::BTPairingInfoMsg(trBTPairingRequestInfo rBTPairingRequestInfo)
{
   ETG_TRACE_USR1(("BTPairingInfoMsg::BTPairingInfoMsg entered "));
   vAllocateMsg();
   if (NULL !=m_poBTPairingReqInfo)
   {
      (*m_poBTPairingReqInfo) = rBTPairingRequestInfo;
   }
}

/***************************************************************************
 ** FUNCTION:  BTPairingInfoMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BTPairingInfoMsg, spi_tclExtBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BTPairingInfoMsg::vAllocateMsg
 ***************************************************************************/
t_Void BTPairingInfoMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("BTPairingInfoMsg::vAllocateMsg entered\n"));
   m_poBTPairingReqInfo = new trBTPairingRequestInfo();
}

/***************************************************************************
 ** FUNCTION:  BTPairingInfoMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BTPairingInfoMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("BTPairingInfoMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_poBTPairingReqInfo);
}

//!class BTLimitationModeMsg
/***************************************************************************
 ** FUNCTION:  BTLimitationModeMsg::BTLimitationModeMsg
 ***************************************************************************/
BTLimitationModeMsg::BTLimitationModeMsg(trBTLimitationModeInfo rBTLimitationModeInfo)
{
   ETG_TRACE_USR1(("BTLimitationModeMsg::BTLimitationModeMsg entered "));
   vAllocateMsg();
   if (NULL !=m_poBTLimitationModeInfo)
   {
      (*m_poBTLimitationModeInfo) = rBTLimitationModeInfo;
   }
}

/***************************************************************************
 ** FUNCTION:  BTLimitationModeMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BTLimitationModeMsg, spi_tclExtBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BTLimitationModeMsg::vAllocateMsg
 ***************************************************************************/
t_Void BTLimitationModeMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("BTLimitationModeMsg::vAllocateMsg entered\n"));
   m_poBTLimitationModeInfo = new trBTLimitationModeInfo();
}

/***************************************************************************
 ** FUNCTION:  BTLimitationModeMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BTLimitationModeMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("BTLimitationModeMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_poBTLimitationModeInfo);
}

//!class BTDeviceNameUpdateMsg
/***************************************************************************
 ** FUNCTION:  BTDeviceNameUpdateMsg::BTDeviceNameUpdateMsg
 ***************************************************************************/
BTDeviceNameUpdateMsg::BTDeviceNameUpdateMsg(t_String szBTDeviceAddress,t_String szBTDeviceName)
{
   ETG_TRACE_USR1(("BTDeviceNameUpdateMsg::BTDeviceNameUpdateMsg entered "));
   vAllocateMsg();
   if (NULL != m_poszBTDeviceAddress)
   {
      (*m_poszBTDeviceAddress) = szBTDeviceAddress;
   }
      if (NULL != m_poszBTDeviceName)
   {
      (*m_poszBTDeviceName) = szBTDeviceName;
   }
}

/***************************************************************************
 ** FUNCTION:  BTDeviceNameUpdateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BTDeviceNameUpdateMsg, spi_tclExtBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BTDeviceNameUpdateMsg::vAllocateMsg
 ***************************************************************************/
t_Void BTDeviceNameUpdateMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("BTDeviceNameUpdateMsg::vAllocateMsg entered\n"));
   m_poszBTDeviceAddress = new t_String;
   m_poszBTDeviceName    = new t_String;
}

/***************************************************************************
 ** FUNCTION:  BTDeviceNameUpdateMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BTDeviceNameUpdateMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("BTDeviceNameUpdateMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_poszBTDeviceAddress);
   RELEASE_MEM(m_poszBTDeviceName);
}

//!class BTProfileStatusUpdateMsg
/***************************************************************************
 ** FUNCTION:  BTProfileStatusUpdateMsg::BTProfileStatusUpdateMsg
 ***************************************************************************/
BTProfileStatusUpdateMsg::BTProfileStatusUpdateMsg()
{
   ETG_TRACE_USR1(("BTProfileStatusUpdateMsg::BTProfileStatusUpdateMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BTProfileStatusUpdateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BTProfileStatusUpdateMsg, spi_tclExtBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  BTProfileStatusUpdateMsg::vAllocateMsg
 ***************************************************************************/
t_Void BTProfileStatusUpdateMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("BTProfileStatusUpdateMsg::vAllocateMsg entered\n"));
}

/***************************************************************************
 ** FUNCTION:  BTProfileStatusUpdateMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BTProfileStatusUpdateMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("BTProfileStatusUpdateMsg::vDeAllocateMsg entered\n"));
}

//!class SetBTLimitationModeResultMsg
/***************************************************************************
 ** FUNCTION:  SetBTLimitationModeResultMsg::SetBTLimitationModeResultMsg
 ***************************************************************************/
SetBTLimitationModeResultMsg::SetBTLimitationModeResultMsg(t_Bool bSetBTLimitationModeResult)
{
   ETG_TRACE_USR1(("SetBTLimitationModeResultMsg::SetBTLimitationModeResultMsg entered "));
   m_bSetBTLimitationModeResult = bSetBTLimitationModeResult;
}

/***************************************************************************
 ** FUNCTION:  SetBTLimitationModeResultMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(SetBTLimitationModeResultMsg, spi_tclExtBluetoothDispatcher);

/***************************************************************************
 ** FUNCTION:  SetBTLimitationModeResultMsg::vAllocateMsg
 ***************************************************************************/
t_Void SetBTLimitationModeResultMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("SetBTLimitationModeResultMsg::vAllocateMsg entered\n"));

}

/***************************************************************************
 ** FUNCTION:  SetBTLimitationModeResultMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void SetBTLimitationModeResultMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("SetBTLimitationModeResultMsg::vDeAllocateMsg entered\n"));
}

//!class spi_tclExtBluetoothDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtBluetoothDispatcher::spi_tclExtBluetoothDispatcher
 ***************************************************************************/
spi_tclExtBluetoothDispatcher::spi_tclExtBluetoothDispatcher()
{
   ETG_TRACE_USR1(("spi_tclExtBluetoothDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtBluetoothDispatcher::~spi_tclExtBluetoothDispatcher
 ***************************************************************************/
spi_tclExtBluetoothDispatcher::~spi_tclExtBluetoothDispatcher()
{
   ETG_TRACE_USR1(("~spi_tclExtBluetoothDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg((BTConnectionChangedMsg..)
 ***************************************************************************/
t_Void spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTConnectionChangedMsg* poBTConnectionChangedMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg entered "));
   if (NULL != poBTConnectionChangedMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespBluetooth,
               e16EXT_BLUETOOTH_REGID,
               vPostBTConnectionChangedMsg(*(poBTConnectionChangedMsg->m_poszBTDeviceAddress),poBTConnectionChangedMsg->m_enBTConnResult));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg((BTPairingStatusMsg..)
 ***************************************************************************/
t_Void spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTPairingStatusMsg* poBTPairingStatusMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg entered "));
   if (NULL != poBTPairingStatusMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespBluetooth,
               e16EXT_BLUETOOTH_REGID,
               vPostBTPairingStatusMsg(poBTPairingStatusMsg->m_enBTSetPairingStatus, *(poBTPairingStatusMsg->m_poszBTDeviceAddress)));
   }
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg((BTServiceAvailabilityMsg..)
 ***************************************************************************/
t_Void spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTServiceAvailabilityMsg* poBTServiceAvailabilityMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg entered "));
   if (NULL != poBTServiceAvailabilityMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespBluetooth,
               e16EXT_BLUETOOTH_REGID,
               vPostBTServiceAvailabilityMsg(poBTServiceAvailabilityMsg->m_bServiceAvailable));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg((BTPairingInfoMsg..)
 ***************************************************************************/
t_Void spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTPairingInfoMsg* poBTPairingInfoMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg entered "));
   if (NULL != poBTPairingInfoMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespBluetooth,
               e16EXT_BLUETOOTH_REGID,
               vPostBTPairingInfoMsg(*(poBTPairingInfoMsg->m_poBTPairingReqInfo)));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg((BTLimitationModeMsg..)
 ***************************************************************************/
t_Void spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTLimitationModeMsg* poBTLimitationModeMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg entered "));
   if (NULL != poBTLimitationModeMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespBluetooth,
               e16EXT_BLUETOOTH_REGID,
               vPostBTLimitationModeMsg(*(poBTLimitationModeMsg->m_poBTLimitationModeInfo)));
   }
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg((BTDeviceNameUpdateMsg..)
 ***************************************************************************/
t_Void spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTDeviceNameUpdateMsg* poBTDeviceNameUpdateMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg entered "));
   if (NULL != poBTDeviceNameUpdateMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespBluetooth,
               e16EXT_BLUETOOTH_REGID,
               vPostBTDeviceNameUpdateMsg(*(poBTDeviceNameUpdateMsg->m_poszBTDeviceAddress),*(poBTDeviceNameUpdateMsg->m_poszBTDeviceName)));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg((BTLimitationModeMsg..)
 ***************************************************************************/
t_Void spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(SetBTLimitationModeResultMsg* poSetBTLimitationModeResultMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg entered "));
   if (NULL != poSetBTLimitationModeResultMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespBluetooth,
               e16EXT_BLUETOOTH_REGID,
			   vPostSetBTLimitationModeResultMsg(poSetBTLimitationModeResultMsg->m_bSetBTLimitationModeResult));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg((BTProfileStatusUpdateMsg..)
 ***************************************************************************/
t_Void spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTProfileStatusUpdateMsg* poBTProfileStatusUpdateMsg) const
{
   ETG_TRACE_USR1(("spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg entered "));
   if (NULL != poBTProfileStatusUpdateMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespBluetooth,
               e16EXT_BLUETOOTH_REGID,
               vPostBTProfileStatusUpdateMsg());
   }
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
